/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordActionQueryExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetTerminatedActionForDates() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, "coord-action-get.xml");
        String actionNomialTime = this.getActionNominalTime(actionXml);
        Date nominalTime = DateUtils.parseDateOozieTZ((String)actionNomialTime);
        Date d1 = new Date(nominalTime.getTime() - 1000L);
        Date d2 = new Date(nominalTime.getTime() + 1000L);
        this._testGetTerminatedActionForDates(job.getId(), d1, d2, 1);
        d1 = new Date(nominalTime.getTime() + 1000L);
        d2 = new Date(nominalTime.getTime() + 2000L);
        this._testGetTerminatedActionForDates(job.getId(), d1, d2, 0);
        this.cleanUpDBTables();
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this._testGetTerminatedActionForDates(job.getId(), d1, d2, 0);
    }

    private void _testGetTerminatedActionForDates(String jobId, Date d1, Date d2, int expected) throws Exception {
        List actionIds = CoordActionQueryExecutor.getInstance().getList((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_TERMINATED_ACTIONS_FOR_DATES, new Object[]{jobId, d1, d2});
        TestCoordActionQueryExecutor.assertEquals((int)expected, (int)actionIds.size());
    }

    public void testGetTerminatedActionIdsForDates() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, "coord-action-get.xml");
        String actionNomialTime = this.getActionNominalTime(actionXml);
        Date nominalTime = DateUtils.parseDateOozieTZ((String)actionNomialTime);
        Date d1 = new Date(nominalTime.getTime() - 1000L);
        Date d2 = new Date(nominalTime.getTime() + 1000L);
        this._testGetTerminatedActionIdsForDates(job.getId(), d1, d2, 1);
        d1 = new Date(nominalTime.getTime() + 1000L);
        d2 = new Date(nominalTime.getTime() + 2000L);
        this._testGetTerminatedActionIdsForDates(job.getId(), d1, d2, 0);
        this.cleanUpDBTables();
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this._testGetTerminatedActionIdsForDates(job.getId(), d1, d2, 0);
    }

    private void _testGetTerminatedActionIdsForDates(String jobId, Date d1, Date d2, int expected) throws Exception {
        List actions = CoordActionQueryExecutor.getInstance().getList((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_TERMINATED_ACTION_IDS_FOR_DATES, new Object[]{jobId, d1, d2});
        TestCoordActionQueryExecutor.assertEquals((int)expected, (int)actions.size());
    }
}

