/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionsCountForJobIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Pair;
import org.junit.Assert;

public class TestCoordActionsCountForJobIdJPAExecutor
extends XDataTestCase {
    private static final Pair<String, CoordinatorEngine.FILTER_COMPARATORS> POSITIVE_STATUS_FILTER = Pair.of((Object)"status", (Object)CoordinatorEngine.FILTER_COMPARATORS.EQUALS);
    private static final Pair<String, CoordinatorEngine.FILTER_COMPARATORS> NEGATIVE_STATUS_FILTER = Pair.of((Object)"status", (Object)CoordinatorEngine.FILTER_COMPARATORS.NOT_EQUALS);
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private Timestamp getSqlTime(String str) throws ParseException {
        return new Timestamp(DateUtils.parseDateUTC((String)str).getTime());
    }

    private List<Object> getList(Object ... objs) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objs) {
            list.add(o);
        }
        return list;
    }

    public void testGetActionsCount() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        String[] timeStr = new String[]{"2009-02-01T00:00Z", "2009-02-01T05:00Z", "2009-02-01T10:00Z", "2009-02-01T15:00Z"};
        Date[] ntime = new Date[]{this.getSqlTime(timeStr[0]), this.getSqlTime(timeStr[1]), this.getSqlTime(timeStr[2]), this.getSqlTime(timeStr[3])};
        ArrayList<String> actionIds = new ArrayList<String>(timeStr.length);
        int startAction = 5;
        for (Date time : ntime) {
            CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), startAction++, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, time);
            actionIds.add(action.getId());
        }
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordActionsCountForJobIdJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<Pair, List<Object>> filterMap = new HashMap<Pair, List<Object>>();
        CoordActionsCountForJobIdJPAExecutor actionGetCountCmd = new CoordActionsCountForJobIdJPAExecutor(job.getId(), filterMap);
        int actionCount = (Integer)jpaService.execute((JPAExecutor)actionGetCountCmd);
        Assert.assertEquals((long)4L, (long)actionCount);
        filterMap.put(Pair.of((Object)"nominaltime", (Object)CoordinatorEngine.FILTER_COMPARATORS.GREATER_EQUAL), this.getList(ntime[2]));
        actionGetCountCmd = new CoordActionsCountForJobIdJPAExecutor(job.getId(), filterMap);
        actionCount = (Integer)jpaService.execute((JPAExecutor)actionGetCountCmd);
        Assert.assertEquals((long)2L, (long)actionCount);
    }
}

