/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobGetActionsSubsetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Pair;
import org.junit.Assert;

public class TestCoordJobGetActionsSubsetJPAExecutor
extends XDataTestCase {
    private static final Pair<String, CoordinatorEngine.FILTER_COMPARATORS> POSITIVE_STATUS_FILTER = Pair.of((Object)"status", (Object)CoordinatorEngine.FILTER_COMPARATORS.EQUALS);
    private static final Pair<String, CoordinatorEngine.FILTER_COMPARATORS> NEGATIVE_STATUS_FILTER = Pair.of((Object)"status", (Object)CoordinatorEngine.FILTER_COMPARATORS.NOT_EQUALS);
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private Timestamp getSqlTime(String str) throws ParseException {
        return new Timestamp(DateUtils.parseDateUTC((String)str).getTime());
    }

    private List<Object> getList(Object ... objs) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objs) {
            list.add(o);
        }
        return list;
    }

    public void testGetActionsWithNominalTimeFilter() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        String[] timeStr = new String[]{"2009-02-01T00:00Z", "2009-02-01T05:00Z", "2009-02-01T10:00Z", "2009-02-01T15:00Z"};
        Date[] ntime = new Date[]{this.getSqlTime(timeStr[0]), this.getSqlTime(timeStr[1]), this.getSqlTime(timeStr[2]), this.getSqlTime(timeStr[3])};
        ArrayList<String> actionIds = new ArrayList<String>(timeStr.length);
        int startAction = 5;
        for (Date time : ntime) {
            CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), startAction++, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, time);
            actionIds.add(action.getId());
        }
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsSubsetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<Pair, List<Object>> filterMap = new HashMap<Pair, List<Object>>();
        filterMap.put(Pair.of((Object)"nominaltime", (Object)CoordinatorEngine.FILTER_COMPARATORS.GREATER_EQUAL), this.getList(ntime[2]));
        CoordJobGetActionsSubsetJPAExecutor actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, false);
        List actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(3), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(3), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        filterMap.clear();
        filterMap.put(Pair.of((Object)"nominaltime", (Object)CoordinatorEngine.FILTER_COMPARATORS.LESSTHAN), this.getList(ntime[2]));
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, false);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(0), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(0), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        filterMap.put(Pair.of((Object)"nominaltime", (Object)CoordinatorEngine.FILTER_COMPARATORS.GREATER_EQUAL), this.getList(ntime[1]));
        filterMap.put(Pair.of((Object)"nominaltime", (Object)CoordinatorEngine.FILTER_COMPARATORS.LESSTHAN), this.getList(ntime[3]));
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, false);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 2, 10, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)1L, (long)actions.size());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 2, 10, false);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)1L, (long)actions.size());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 2, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 2, false);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        filterMap.put(Pair.of((Object)"nominaltime", (Object)CoordinatorEngine.FILTER_COMPARATORS.LESSTHAN), this.getList(this.getSqlTime("2009-02-01T23:00Z")));
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 2, 2, false);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(3), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 2, 2, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals(actionIds.get(2), (Object)((CoordinatorActionBean)actions.get(0)).getId());
        Assert.assertEquals(actionIds.get(1), (Object)((CoordinatorActionBean)actions.get(1)).getId());
        filterMap.put(Pair.of((Object)"status", (Object)CoordinatorEngine.FILTER_COMPARATORS.EQUALS), this.getList(CoordinatorAction.Status.SUCCEEDED.name()));
        actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(job.getId(), filterMap, 1, 10, true);
        actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        Assert.assertEquals((long)0L, (long)actions.size());
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        String resourceXmlName = "coord-action-get.xml";
        Date dummyCreationTime = new Date();
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, resourceXmlName, 0);
        action.setConsoleUrl("consoleUrl");
        action.setExternalStatus("externalStatus");
        action.setErrorCode("errorCode");
        action.setErrorMessage("errorMessage");
        action.setTrackerUri("trackerUri");
        action.setCreatedTime(dummyCreationTime);
        String missDeps = this.getTestCaseFileUri("2009/29/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/22/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/15/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/08/_SUCCESS");
        action.setMissingDependencies(missDeps);
        action.setTimeOut(10);
        this.insertRecordCoordAction(action);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, resourceXmlName);
        String actionNominalTime = this.getActionNominalTime(actionXml);
        this._testGetActionsSubset(job.getId(), action.getId(), 1, 1, "consoleUrl", "errorCode", "errorMessage", action.getId() + "_E", "externalStatus", "trackerUri", dummyCreationTime, DateUtils.parseDateOozieTZ((String)actionNominalTime), missDeps, 10, CoordinatorAction.Status.WAITING);
    }

    private void _testGetActionsSubset(String jobId, String actionId, int start, int len, String consoleUrl, String errorCode, String errorMessage, String externalId, String externalStatus, String trackerUri, Date createdTime, Date nominalTime, String missDeps, int timeout, CoordinatorAction.Status status) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsSubsetJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionsSubsetJPAExecutor actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(jobId, null, start, len, false);
        List actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        CoordinatorActionBean action = (CoordinatorActionBean)actions.get(0);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)1, (int)actions.size());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)actionId, (String)action.getId());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)jobId, (String)action.getJobId());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)consoleUrl, (String)action.getConsoleUrl());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)errorCode, (String)action.getErrorCode());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)errorMessage, (String)action.getErrorMessage());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)externalId, (String)action.getExternalId());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)externalStatus, (String)action.getExternalStatus());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)trackerUri, (String)action.getTrackerUri());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((Object)createdTime, (Object)action.getCreatedTime());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((Object)nominalTime, (Object)action.getNominalTime());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)missDeps, (String)action.getMissingDependencies());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)timeout, (int)action.getTimeOut());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
    }

    public void testCoordActionOrderBy() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml", 0);
        List<CoordinatorActionBean> actions = this._testGetActionsSubsetOrderBy(job.getId(), 1, 2, false);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.size(), (int)2);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.get(0).getActionNumber(), (int)2);
    }

    public void testCoordActionOrderByDesc() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml", 0);
        List<CoordinatorActionBean> actions = this._testGetActionsSubsetOrderBy(job.getId(), 1, 2, true);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.size(), (int)2);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.get(0).getActionNumber(), (int)1);
    }

    private List<CoordinatorActionBean> _testGetActionsSubsetOrderBy(String jobId, int start, int len, boolean order) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsSubsetJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionsSubsetJPAExecutor actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(jobId, null, start, len, order);
        return (List)jpaService.execute((JPAExecutor)actionGetCmd);
    }

    public void testCoordActionFilter() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        HashMap<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>> filterMap = new HashMap<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>>();
        ArrayList<String> positiveFilter = new ArrayList<String>();
        positiveFilter.add("RUNNING");
        positiveFilter.add("KILLED");
        filterMap.put(POSITIVE_STATUS_FILTER, positiveFilter);
        List<CoordinatorActionBean> actions = this._testGetActionsSubsetFilter(job.getId(), 1, filterMap, 1, 2);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.size(), (int)1);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.get(0).getActionNumber(), (int)1);
        filterMap.clear();
        ArrayList<String> negativeFilter = new ArrayList<String>();
        negativeFilter.add("WAITING");
        negativeFilter.add("KILLED");
        filterMap.put(NEGATIVE_STATUS_FILTER, negativeFilter);
        actions = this._testGetActionsSubsetFilter(job.getId(), 1, filterMap, 1, 2);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.size(), (int)1);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.get(0).getActionNumber(), (int)1);
        filterMap.clear();
        filterMap.put(POSITIVE_STATUS_FILTER, positiveFilter);
        filterMap.put(NEGATIVE_STATUS_FILTER, negativeFilter);
        actions = this._testGetActionsSubsetFilter(job.getId(), 1, filterMap, 1, 2);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.size(), (int)1);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.get(0).getActionNumber(), (int)1);
        filterMap.clear();
        filterMap.put(POSITIVE_STATUS_FILTER, positiveFilter);
        filterMap.put(NEGATIVE_STATUS_FILTER, positiveFilter);
        actions = this._testGetActionsSubsetFilter(job.getId(), 1, filterMap, 1, 2);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)actions.size(), (int)0);
    }

    private List<CoordinatorActionBean> _testGetActionsSubsetFilter(String jobId, int actionNum, Map<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>> filterMap, int start, int len) throws JPAExecutorException {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsSubsetJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionsSubsetJPAExecutor actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(jobId, filterMap, start, len, false);
        return (List)jpaService.execute((JPAExecutor)actionGetCmd);
    }

    public void testGetActionAllColumns() throws Exception {
        this.services.destroy();
        this.setSystemProperty("oozie.coord.action.get.all.attributes", "true");
        this.services = new Services();
        this.services.init();
        int actionNum = 1;
        String slaXml = "slaXml";
        String resourceXmlName = "coord-action-get.xml";
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, resourceXmlName, 0);
        action.setSlaXml(slaXml);
        this.insertRecordCoordAction(action);
        this._testGetForInfoAllActions(job.getId(), slaXml, 1, 1);
    }

    private void _testGetForInfoAllActions(String jobId, String slaXml, int start, int len) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsSubsetJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionsSubsetJPAExecutor actionGetCmd = new CoordJobGetActionsSubsetJPAExecutor(jobId, null, start, len, false);
        List actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        CoordinatorActionBean action = (CoordinatorActionBean)actions.get(0);
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((Object)CoordinatorAction.Status.WAITING, (Object)action.getStatus());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((String)slaXml, (String)action.getSlaXml());
        TestCoordJobGetActionsSubsetJPAExecutor.assertEquals((int)0, (int)action.getPending());
    }
}

