/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobInfoGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordJobInfoGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordJobGet() throws Exception {
        CoordinatorJobBean coordinatorJob1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        this._testGetJobInfoForStatus();
        this._testGetJobInfoForGroup();
        this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        this._testGetJobInfoForAppName();
        this._testGetJobInfoForUser();
        this._testGetJobInfoForUserAndStatus();
        this._testGetJobInfoForFrequency();
        this._testGetJobInfoForId(coordinatorJob1.getId());
        this._testGetJobInfoForFrequencyAndUnit();
    }

    public void testGetJobInfoForStartCreatedTime() throws Exception {
        CoordinatorJobBean coordinatorJob1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorJobBean coordinatorJob2 = this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        Date createTime1 = DateUtils.parseDateUTC((String)"2012-01-01T10:00Z");
        Date createTime2 = DateUtils.parseDateUTC((String)"2012-01-05T10:00Z");
        coordinatorJob1.setCreatedTime(createTime1);
        coordinatorJob2.setCreatedTime(createTime2);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob1);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getCoordJobs().size());
        filter.clear();
        filter.put("startcreatedtime", Arrays.asList("2012-01-02T10:00Z"));
        coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)1, (int)ret.getCoordJobs().size());
        CoordinatorJobBean jobBean = (CoordinatorJobBean)ret.getCoordJobs().get(0);
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordinatorJob2.getStatus(), (Object)jobBean.getStatus());
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordinatorJob2.getCreatedTime(), (Object)jobBean.getCreatedTime());
    }

    public void testGetJobInfoForEndCreatedTime() throws Exception {
        CoordinatorJobBean coordinatorJob1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorJobBean coordinatorJob2 = this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        CoordinatorJobBean coordinatorJob3 = this.addRecordToCoordJobTable(Job.Status.FAILED, false, false);
        Date createTime1 = DateUtils.parseDateUTC((String)"2012-01-03T10:00Z");
        Date createTime2 = DateUtils.parseDateUTC((String)"2012-01-05T10:00Z");
        Date createTime3 = DateUtils.parseDateUTC((String)"2012-01-010T10:00Z");
        coordinatorJob1.setCreatedTime(createTime1);
        coordinatorJob2.setCreatedTime(createTime2);
        coordinatorJob3.setCreatedTime(createTime3);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob1);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob2);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)3, (int)ret.getCoordJobs().size());
        filter.clear();
        filter.put("startcreatedtime", Arrays.asList("2012-01-02T10:00Z"));
        filter.put("endcreatedtime", Arrays.asList("2012-01-07T10:00Z"));
        coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getCoordJobs().size());
        CoordinatorJobBean jobBean = (CoordinatorJobBean)ret.getCoordJobs().get(0);
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordinatorJob2.getStatus(), (Object)jobBean.getStatus());
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordinatorJob2.getCreatedTime(), (Object)jobBean.getCreatedTime());
        CoordinatorJobBean jobBean1 = (CoordinatorJobBean)ret.getCoordJobs().get(1);
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordinatorJob1.getStatus(), (Object)jobBean1.getStatus());
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordinatorJob1.getCreatedTime(), (Object)jobBean1.getCreatedTime());
    }

    public void testGetJobInfoForWrongTimeFormat() throws Exception {
        this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getCoordJobs().size());
        filter.clear();
        filter.put("startcreatedtime", Arrays.asList("2012-01-02T10:00"));
        coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        try {
            jpaService.execute((JPAExecutor)coordInfoGetCmd);
            TestCoordJobInfoGetJPAExecutor.fail((String)"This should not happen. Check the createdTime passed.");
        }
        catch (JPAExecutorException e) {
            TestCoordJobInfoGetJPAExecutor.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E0302);
            TestCoordJobInfoGetJPAExecutor.assertTrue((boolean)e.getMessage().contains(" Specify time either in UTC format (yyyy-MM-dd'T'HH:mm'Z') or a offset value in days/hours/minutes e.g. (-2d/h/m) from the current time."));
        }
    }

    private void _testGetJobInfoForStatus() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("RUNNING");
        list.add("KILLED");
        filter.put("status", list);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)2);
    }

    private void _testGetJobInfoForGroup() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestCoordJobInfoGetJPAExecutor.getTestGroup());
        filter.put("group", list);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)2);
    }

    private void _testGetJobInfoForAppName() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("COORD-TEST");
        filter.put("name", list);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)3);
    }

    private void _testGetJobInfoForUser() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestCoordJobInfoGetJPAExecutor.getTestUser());
        filter.put("user", list);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)3);
    }

    private void _testGetJobInfoForUserAndStatus() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(TestCoordJobInfoGetJPAExecutor.getTestUser());
        filter.put("user", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("KILLED");
        filter.put("status", list2);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)2);
    }

    private void _testGetJobInfoForFrequency() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> frequencyList = new ArrayList<String>();
        frequencyList.add("1");
        filter.put("frequency", frequencyList);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)3);
    }

    private void _testGetJobInfoForId(String jobId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> jobIdList = new ArrayList<String>();
        jobIdList.add(jobId);
        filter.put("id", jobIdList);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)1);
    }

    private void _testGetJobInfoForFrequencyAndUnit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> unitList = new ArrayList<String>();
        ArrayList<String> frequencyList = new ArrayList<String>();
        unitList.add("MINUTE");
        filter.put("unit", unitList);
        frequencyList = new ArrayList();
        frequencyList.add("1");
        filter.put("frequency", frequencyList);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)0);
        frequencyList.remove(0);
        unitList.remove(0);
        unitList.add("DAY");
        filter.put("unit", unitList);
        frequencyList.add("3");
        filter.put("frequency", frequencyList);
        coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)0);
        frequencyList.remove(0);
        unitList.remove(0);
        unitList.add("DAY");
        filter.put("unit", unitList);
        frequencyList.add("1");
        filter.put("frequency", frequencyList);
        coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)ret.getCoordJobs().size(), (int)3);
    }

    public void testCoordGetJobsSortBy() throws Exception {
        CoordinatorJobBean coordinatorJob1 = this.addRecordToCoordJobTable(Job.Status.FAILED, false, false);
        CoordinatorJobBean coordinatorJob2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        coordinatorJob1.setLastModifiedTime(DateUtils.parseDateUTC((String)"2012-01-04T10:00Z"));
        coordinatorJob1.setCreatedTime(DateUtils.parseDateUTC((String)"2012-01-03T10:00Z"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob1);
        coordinatorJob2.setLastModifiedTime(DateUtils.parseDateUTC((String)"2012-01-05T10:00Z"));
        coordinatorJob2.setCreatedTime(DateUtils.parseDateUTC((String)"2012-01-02T10:00Z"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordinatorJob2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("lastmodifiedtime");
        filter.put("sortby", list);
        CoordJobInfoGetJPAExecutor coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        CoordinatorJobInfo ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getCoordJobs().size());
        this.compareCoordJobs(coordinatorJob2, (CoordinatorJobBean)ret.getCoordJobs().get(0));
        filter.clear();
        list.clear();
        coordInfoGetCmd = new CoordJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (CoordinatorJobInfo)jpaService.execute((JPAExecutor)coordInfoGetCmd);
        TestCoordJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getCoordJobs().size());
        this.compareCoordJobs(coordinatorJob1, (CoordinatorJobBean)ret.getCoordJobs().get(0));
    }

    private void compareCoordJobs(CoordinatorJobBean coordBean, CoordinatorJobBean retCoordBean) {
        TestCoordJobInfoGetJPAExecutor.assertEquals((String)coordBean.getId(), (String)retCoordBean.getId());
        TestCoordJobInfoGetJPAExecutor.assertEquals((String)coordBean.getStatusStr(), (String)retCoordBean.getStatusStr());
        TestCoordJobInfoGetJPAExecutor.assertEquals((Object)coordBean.getCreatedTime(), (Object)retCoordBean.getCreatedTime());
    }
}

