/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        CoordinatorJobBean cjBean = this.addRecordToCoordJobTable(Job.Status.PREP, true, true);
        Query query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("appName"), (Object)cjBean.getAppName());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("appPath"), (Object)cjBean.getAppPath());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("concurrency"), (Object)cjBean.getConcurrency());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("conf"), (Object)cjBean.getConfBlob());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("externalId"), (Object)cjBean.getExternalId());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("frequency"), (Object)cjBean.getFrequency());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastActionNumber"), (Object)cjBean.getLastActionNumber());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("timeOut"), (Object)cjBean.getTimeout());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("timeZone"), (Object)cjBean.getTimeZone());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("createdTime"), (Object)cjBean.getCreatedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)cjBean.getEndTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("execution"), (Object)cjBean.getExecution());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("jobXml"), (Object)cjBean.getJobXmlBlob());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastAction"), (Object)cjBean.getLastActionTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("nextMaterializedTime"), (Object)cjBean.getNextMaterializedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("origJobXml"), (Object)cjBean.getOrigJobXmlBlob());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("slaXml"), (Object)cjBean.getSlaXmlBlob());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)cjBean.getStartTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("timeUnit"), (Object)cjBean.getTimeUnit().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("appNamespace"), (Object)cjBean.getAppNamespace());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("bundleId"), (Object)cjBean.getBundleId());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        cjBean.setBundleId("bundleID-test");
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("bundleId"), (Object)cjBean.getBundleId());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)(cjBean.isPending() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_MODTIME, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_MODTIME, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)(cjBean.isPending() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_LAST_MODIFIED_TIME, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_TIME, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("doneMaterialization"), (Object)(cjBean.isDoneMaterialization() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("suspendedTime"), (Object)cjBean.getSuspendedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_MATERIALIZE, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)(cjBean.isPending() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("doneMaterialization"), (Object)(cjBean.isDoneMaterialization() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastActionTime"), (Object)cjBean.getLastActionTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastActionNumber"), (Object)cjBean.getLastActionNumber());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("nextMatdTime"), (Object)cjBean.getNextMaterializedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        query = CoordJobQueryExecutor.getInstance().getUpdateQuery(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_CHANGE, cjBean, em);
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)cjBean.getEndTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)cjBean.getStatus().toString());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)(cjBean.isPending() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("doneMaterialization"), (Object)(cjBean.isDoneMaterialization() ? 1 : 0));
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("concurrency"), (Object)cjBean.getConcurrency());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("pauseTime"), (Object)cjBean.getPauseTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastActionNumber"), (Object)cjBean.getLastActionNumber());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastActionTime"), (Object)cjBean.getLastActionTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("nextMatdTime"), (Object)cjBean.getNextMaterializedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)cjBean.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)cjBean.getId());
        em.close();
    }

    public void testExecuteUpdate() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS, job);
        CoordinatorJobBean job1 = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job.getId()});
        TestCoordJobQueryExecutor.assertEquals((Object)job1.getStatus(), (Object)Job.Status.RUNNING);
        job1.setStatus(Job.Status.SUCCEEDED);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING, job1);
        CoordinatorJobBean job2 = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job1.getId()});
        TestCoordJobQueryExecutor.assertEquals((Object)job2.getStatus(), (Object)Job.Status.SUCCEEDED);
        CoordinatorJobBean job3 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        Date initialLMT = job3.getLastModifiedTime();
        job3.setLastModifiedTime(new Date());
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_CHANGE, job3);
        job3 = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job3.getId()});
        Date afterChangeLMT = job3.getLastModifiedTime();
        TestCoordJobQueryExecutor.assertNotNull((Object)job3.getLastModifiedTimestamp());
        TestCoordJobQueryExecutor.assertTrue((boolean)afterChangeLMT.after(initialLMT));
    }

    public void testGet() throws Exception {
        CoordinatorJobBean bean = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, true);
        bean.setAppNamespace("uri:oozie:coordinator:0.1");
        bean.setBundleId("dummy-bundleid");
        bean.setOrigJobXml("dummy-origjobxml");
        bean.setSlaXml("<sla></sla>");
        bean.setExecution("LIFO");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, bean);
        CoordinatorJobBean retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_USER_APPNAME, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_STATUS_PARENTID, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getBundleId(), (String)retBean.getBundleId());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getStatus(), (Object)retBean.getStatus());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_INPUT_CHECK, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppNamespace(), (String)retBean.getAppNamespace());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getExecution(), (String)retBean.getExecution());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getFrequency(), (String)retBean.getFrequency());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getTimeUnit(), (Object)retBean.getTimeUnit());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getTimeZone(), (String)retBean.getTimeZone());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getStartTime(), (Object)retBean.getStartTime());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getEndTime(), (Object)retBean.getEndTime());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getJobXml(), (String)retBean.getJobXml());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getConf());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getOrigJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getSlaXmlBlob());
        retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_ACTION_READY, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getExecution(), (String)retBean.getExecution());
        TestCoordJobQueryExecutor.assertEquals((int)bean.getConcurrency(), (int)retBean.getConcurrency());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getFrequency(), (String)retBean.getFrequency());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getTimeUnit(), (Object)retBean.getTimeUnit());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getTimeZone(), (String)retBean.getTimeZone());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getStartTime(), (Object)retBean.getStartTime());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getEndTime(), (Object)retBean.getEndTime());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getJobXml(), (String)retBean.getJobXml());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getConf());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getOrigJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getSlaXmlBlob());
        retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_ACTION_KILL, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getConf());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getOrigJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getSlaXmlBlob());
        retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_MATERIALIZE, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getFrequency(), (String)retBean.getFrequency());
        TestCoordJobQueryExecutor.assertEquals((int)bean.getMatThrottling(), (int)retBean.getMatThrottling());
        TestCoordJobQueryExecutor.assertEquals((int)bean.getTimeout(), (int)retBean.getTimeout());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getTimeZone(), (String)retBean.getTimeZone());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getStartTime(), (Object)retBean.getStartTime());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getEndTime(), (Object)retBean.getEndTime());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getPauseTime(), (Object)retBean.getPauseTime());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getNextMaterializedTime(), (Object)retBean.getNextMaterializedTime());
        TestCoordJobQueryExecutor.assertEquals((Object)bean.getLastActionTime(), (Object)retBean.getLastActionTime());
        TestCoordJobQueryExecutor.assertEquals((int)bean.getLastActionNumber(), (int)retBean.getLastActionNumber());
        TestCoordJobQueryExecutor.assertEquals((boolean)bean.isDoneMaterialization(), (boolean)retBean.isDoneMaterialization());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getBundleId(), (String)retBean.getBundleId());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getConf(), (String)retBean.getConf());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getJobXml(), (String)retBean.getJobXml());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getExecution(), (String)retBean.getExecution());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getOrigJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getSlaXmlBlob());
        retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_SUSPEND_KILL, new Object[]{bean.getId()});
        TestCoordJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getBundleId(), (String)retBean.getBundleId());
        TestCoordJobQueryExecutor.assertEquals((String)bean.getAppNamespace(), (String)retBean.getAppNamespace());
        TestCoordJobQueryExecutor.assertEquals((boolean)bean.isDoneMaterialization(), (boolean)retBean.isDoneMaterialization());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getConf());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getOrigJobXmlBlob());
        TestCoordJobQueryExecutor.assertNull((Object)retBean.getSlaXmlBlob());
    }

    public void testGetList() throws Exception {
        CoordinatorJobBean bean1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, true, true);
        CoordinatorJobBean bean2 = this.addRecordToCoordJobTable(Job.Status.DONEWITHERROR, true, true);
        Date queryTime = new Date();
        bean1.setLastModifiedTime(new Date(queryTime.getTime() + 1000L));
        bean2.setLastModifiedTime(new Date(queryTime.getTime() + 2000L));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_LAST_MODIFIED_TIME, bean1);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_LAST_MODIFIED_TIME, bean2);
        List retBeans = CoordJobQueryExecutor.getInstance().getList(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOBS_CHANGED, new Object[]{new Timestamp(queryTime.getTime())});
        TestCoordJobQueryExecutor.assertEquals((int)2, (int)retBeans.size());
        TestCoordJobQueryExecutor.assertEquals((String)bean1.getId(), (String)((CoordinatorJobBean)retBeans.get(0)).getId());
        TestCoordJobQueryExecutor.assertEquals((Object)bean1.getStatus(), (Object)((CoordinatorJobBean)retBeans.get(0)).getStatus());
        TestCoordJobQueryExecutor.assertEquals((String)bean2.getId(), (String)((CoordinatorJobBean)retBeans.get(1)).getId());
        TestCoordJobQueryExecutor.assertEquals((Object)bean2.getStatus(), (Object)((CoordinatorJobBean)retBeans.get(1)).getStatus());
    }

    public void testInsert() throws Exception {
        CoordinatorJobBean bean = new CoordinatorJobBean();
        bean.setId("test-oozie");
        bean.setAppName("testApp");
        bean.setUser("oozie");
        CoordJobQueryExecutor.getInstance().insert((JsonBean)bean);
        CoordinatorJobBean retBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{"test-oozie"});
        TestCoordJobQueryExecutor.assertEquals((String)retBean.getAppName(), (String)"testApp");
        TestCoordJobQueryExecutor.assertEquals((String)retBean.getUser(), (String)"oozie");
    }
}

