/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsToBeMaterializedJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;

public class TestCoordJobsToBeMaterializedJPAExecutor
extends XFsTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testCoordJobsToBeMaterializedCommand() throws Exception {
        String jobId = "00000-" + new Date().getTime() + "-TestCoordJobsToBeMaterializedJPAExecutor-C";
        this.insertJob(jobId, Job.Status.PREP);
        this._testCoordJobsToBeMaterialized();
    }

    private void _testCoordJobsToBeMaterialized() {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsToBeMaterializedJPAExecutor.assertNotNull((Object)jpaService);
        try {
            Date d1 = new Date();
            Date d2 = new Date(d1.getTime() + 1000L);
            CoordJobsToBeMaterializedJPAExecutor cmatcmd = new CoordJobsToBeMaterializedJPAExecutor(d2, 50);
            List jobList = (List)jpaService.execute((JPAExecutor)cmatcmd);
            if (jobList.size() == 0) {
                TestCoordJobsToBeMaterializedJPAExecutor.fail((String)("Test of getCoordinatorJobsToBeMaterialized returned no records. Date =" + d2));
            }
            d2 = new Date(d1.getTime() - 31536000000L);
            CoordJobsToBeMaterializedJPAExecutor cmatcmdnew = new CoordJobsToBeMaterializedJPAExecutor(d2, 50);
            jobList = (List)jpaService.execute((JPAExecutor)cmatcmdnew);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordJobsToBeMaterializedJPAExecutor.fail((String)"Unable to Get Materialized Jobs ");
        }
    }

    private void insertJob(String jobId, Job.Status status) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.getCoordJobXml(appPath);
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(jobId);
        coordJob.setAppName("COORD-TEST");
        coordJob.setAppPath(appPath.toString());
        coordJob.setStatus(status);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(TestCoordJobsToBeMaterializedJPAExecutor.getTestUser());
        coordJob.setGroup(TestCoordJobsToBeMaterializedJPAExecutor.getTestGroup());
        Properties conf = this.getCoordConf(appPath);
        String confStr = XmlUtils.writePropToString((Properties)conf);
        coordJob.setConf(confStr);
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        coordJob.setMatThrottling(1);
        try {
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z"));
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-12-17T01:00Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordJobsToBeMaterializedJPAExecutor.fail((String)"Could not set Date/time");
        }
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordJobsToBeMaterializedJPAExecutor.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestCoordJobsToBeMaterializedJPAExecutor.fail((String)"Unable to insert the test job record to table");
            throw ce;
        }
    }

    private String getCoordJobXml(Path appPath) {
        String inputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)"coord-job-get.xml", (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get coord-rerun-job.xml", (Object[])new Object[]{ioe}));
        }
    }

    private Properties getCoordConf(Path appPath) {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "workflow");
        OozieClient coordClient = LocalOozie.getCoordClient();
        Properties conf = coordClient.createConfiguration();
        conf.setProperty("oozie.coord.application.path", appPath.toString());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("wfAppPath", wfAppPath.toString());
        conf.remove("user.name");
        conf.setProperty("user.name", TestCoordJobsToBeMaterializedJPAExecutor.getTestUser());
        return conf;
    }
}

