/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import java.util.List;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.SLAEventsGetForSeqIdJPAExecutor;
import org.apache.oozie.executor.jpa.SLAEventsGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestSLAEventsGetForSeqIdJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSLAEventsGetForSeqId() throws Exception {
        Date current = new Date();
        String wfId = "0000000-" + current.getTime() + "-TestSLAEventsGetForSeqIdJPAExecutor-W";
        this.addRecordToSLAEventTable(wfId, SLAEvent.Status.CREATED, current);
        this.addRecordToSLAEventTable(wfId, SLAEvent.Status.STARTED, current);
        this.addRecordToSLAEventTable(wfId, SLAEvent.Status.SUCCEEDED, current);
        this._testGetSLAEventsForSeqId(wfId, current);
    }

    private void _testGetSLAEventsForSeqId(String jobId, Date current) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForSeqIdJPAExecutor.assertNotNull((Object)jpaService);
        SLAEventsGetJPAExecutor slaEventsGetAllCmd = new SLAEventsGetJPAExecutor();
        List fullList = (List)jpaService.execute((JPAExecutor)slaEventsGetAllCmd);
        TestSLAEventsGetForSeqIdJPAExecutor.assertNotNull((Object)fullList);
        long lastId = ((SLAEventBean)fullList.get(0)).getEvent_id();
        SLAEventsGetForSeqIdJPAExecutor slaEventsGetCmd = new SLAEventsGetForSeqIdJPAExecutor(lastId, 10, new long[1]);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForSeqIdJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForSeqIdJPAExecutor.assertEquals((int)2, (int)list.size());
        SLAEventBean seBean = (SLAEventBean)list.get(0);
        TestSLAEventsGetForSeqIdJPAExecutor.assertEquals((String)seBean.getSlaId(), (String)jobId);
        TestSLAEventsGetForSeqIdJPAExecutor.assertEquals((String)seBean.getUser(), (String)TestSLAEventsGetForSeqIdJPAExecutor.getTestUser());
        TestSLAEventsGetForSeqIdJPAExecutor.assertEquals((String)seBean.getGroupName(), (String)TestSLAEventsGetForSeqIdJPAExecutor.getTestGroup());
        TestSLAEventsGetForSeqIdJPAExecutor.assertEquals((Object)seBean.getJobStatus(), (Object)SLAEvent.Status.STARTED);
        TestSLAEventsGetForSeqIdJPAExecutor.assertEquals((long)seBean.getStatusTimestamp().getTime(), (long)current.getTime());
    }
}

