/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetWorkflowParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, WorkflowJobBean> wflist = new HashMap<String, WorkflowJobBean>();
        WorkflowJobBean wfJobA = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean subwfJobA1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobA.getId());
        WorkflowJobBean subwfJobA2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobA.getId());
        WorkflowJobBean subwfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobB.getId());
        ArrayList<Object> children = new ArrayList<WorkflowJobBean>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor(wfJobA.getId(), 10)));
        wflist.put(subwfJobA1.getId(), subwfJobA1);
        wflist.put(subwfJobA2.getId(), subwfJobA2);
        this.checkChildren(children, wflist);
        children = new ArrayList();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor(wfJobB.getId(), 10)));
        wflist.clear();
        wflist.put(subwfJobB.getId(), subwfJobB);
        this.checkChildren(children, wflist);
    }

    public void testGetCoordinatorParentTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, WorkflowJobBean> wflist = new HashMap<String, WorkflowJobBean>();
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean subwfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        ArrayList<WorkflowJobBean> children = new ArrayList<WorkflowJobBean>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor(wfJob.getId(), 3)));
        TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertEquals((int)3, (int)children.size());
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor(wfJob.getId(), 3, 3)));
        TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertEquals((int)5, (int)children.size());
        wflist.put(subwfJob1.getId(), subwfJob1);
        wflist.put(subwfJob2.getId(), subwfJob2);
        wflist.put(subwfJob3.getId(), subwfJob3);
        wflist.put(subwfJob4.getId(), subwfJob4);
        wflist.put(subwfJob5.getId(), subwfJob5);
        this.checkChildren(children, wflist);
    }

    private void checkChildren(List<WorkflowJobBean> children, HashMap<String, WorkflowJobBean> wfJobBaselist) {
        TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertEquals((int)wfJobBaselist.size(), (int)children.size());
        for (int i = 0; i < children.size(); ++i) {
            WorkflowJobBean wfJobBase = wfJobBaselist.get(children.get(i).getId());
            TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertNotNull((Object)wfJobBase);
            TestWorkflowJobsBasicInfoFromWorkflowParentIdJPAExecutor.assertEquals((Object)wfJobBase.getStatus(), (Object)children.get(i).getStatus());
        }
    }
}

