/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetForPurgeJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestWorkflowJobsGetForPurgeJPAExecutor
extends XDataTestCase {
    private static final long DAY_IN_MS = 86400000L;
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfJobsGetForPurgeWithParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        WorkflowJobBean job3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        job3.setParentId(job1.getId());
        job3.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, (Object)job3);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetForPurgeJPAExecutor(1L, 20)));
        this.checkWorkflows(list, job1.getId(), job2.getId());
    }

    public void testWfJobsGetForPurgeTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        WorkflowJobBean job3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean job4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean job5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetForPurgeJPAExecutor(1L, 3)));
        TestWorkflowJobsGetForPurgeJPAExecutor.assertEquals((int)3, (int)list.size());
        list.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetForPurgeJPAExecutor(1L, 3, 3)));
        TestWorkflowJobsGetForPurgeJPAExecutor.assertEquals((int)5, (int)list.size());
        this.checkWorkflows(list, job1.getId(), job2.getId(), job3.getId(), job4.getId(), job5.getId());
    }

    @Override
    protected WorkflowJobBean addRecordToWfJobTable(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = new Configuration();
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestWorkflowJobsGetForPurgeJPAExecutor.getTestUser());
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, jobStatus, instanceStatus);
        Timestamp startTS = new Timestamp(System.currentTimeMillis() - 259200000L);
        Timestamp endTS = new Timestamp(System.currentTimeMillis() - 172800000L);
        wfBean.setStartTime(DateUtils.toDate((Timestamp)startTS));
        wfBean.setEndTime(DateUtils.toDate((Timestamp)endTS));
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestWorkflowJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestWorkflowJobsGetForPurgeJPAExecutor.fail((String)"Unable to insert the test wf job record to table");
            throw je;
        }
        return wfBean;
    }

    private void checkWorkflows(List<String> wfs, String ... wfJobIDs) {
        TestWorkflowJobsGetForPurgeJPAExecutor.assertEquals((int)wfJobIDs.length, (int)wfs.size());
        Arrays.sort(wfJobIDs);
        Collections.sort(wfs);
        for (int i = 0; i < wfJobIDs.length; ++i) {
            TestWorkflowJobsGetForPurgeJPAExecutor.assertEquals((String)wfJobIDs[i], (String)wfs.get(i));
        }
    }
}

