/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetFromCoordParentIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowJobsGetFromCoordParentIdJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetCoordinatorParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsGetFromCoordParentIdJPAExecutor.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJobA = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coordJobB = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJobA1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJobA2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfActionA1 = this.addRecordToWfActionTable(wfJobA1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionA2 = this.addRecordToWfActionTable(wfJobA2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionB = this.addRecordToWfActionTable(wfJobB.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordActionA1 = this.addRecordToCoordActionTable(coordJobA.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobA1.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordActionA2 = this.addRecordToCoordActionTable(coordJobA.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobA2.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordActionB = this.addRecordToCoordActionTable(coordJobB.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobB.getId(), "SUCCEEDED", 0);
        ArrayList<String> children = new ArrayList<String>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromCoordParentIdJPAExecutor(coordJobA.getId(), 10)));
        this.checkChildren(children, wfJobA1.getId(), wfJobA2.getId());
        children = new ArrayList();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromCoordParentIdJPAExecutor(coordJobB.getId(), 10)));
        this.checkChildren(children, wfJobB.getId());
    }

    public void testGetWorkflowParentTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsGetFromCoordParentIdJPAExecutor.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob2.getId(), "2", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob3.getId(), "2", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob5.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob1.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob2.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction3 = this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob3.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction4 = this.addRecordToCoordActionTable(coordJob.getId(), 4, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob4.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction5 = this.addRecordToCoordActionTable(coordJob.getId(), 5, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob5.getId(), "SUCCEEDED", 0);
        ArrayList<String> children = new ArrayList<String>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromCoordParentIdJPAExecutor(coordJob.getId(), 3)));
        TestWorkflowJobsGetFromCoordParentIdJPAExecutor.assertEquals((int)3, (int)children.size());
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromCoordParentIdJPAExecutor(coordJob.getId(), 3, 3)));
        TestWorkflowJobsGetFromCoordParentIdJPAExecutor.assertEquals((int)5, (int)children.size());
        this.checkChildren(children, wfJob1.getId(), wfJob2.getId(), wfJob3.getId(), wfJob4.getId(), wfJob5.getId());
    }

    private void checkChildren(List<String> children, String ... wfJobIDs) {
        TestWorkflowJobsGetFromCoordParentIdJPAExecutor.assertEquals((int)wfJobIDs.length, (int)children.size());
        Arrays.sort(wfJobIDs);
        Collections.sort(children);
        for (int i = 0; i < wfJobIDs.length; ++i) {
            TestWorkflowJobsGetFromCoordParentIdJPAExecutor.assertEquals((String)wfJobIDs[i], (String)children.get(i));
        }
    }
}

