/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultConnectionContext
extends XTestCase {
    private Services services;
    private Session session1;
    private Session session2;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = this.services.getConf();
        conf.set("oozie.services.ext", JMSAccessorService.class.getName() + "," + JMSTopicService.class.getName());
        conf.set("oozie.jms.producer.connection.properties", "java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false;connectionFactoryNames#ConnectionFactory");
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testThreadLocalSession() throws JMSException {
        String jmsProps = this.services.getConf().get("oozie.jms.producer.connection.properties");
        JMSConnectionInfo connInfo = new JMSConnectionInfo(jmsProps);
        ConnectionContext jmsContext = ((JMSAccessorService)Services.get().get(JMSAccessorService.class)).createConnectionContext(connInfo);
        Thread th = new Thread(new SessionThread(jmsContext));
        th.start();
        try {
            th.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestDefaultConnectionContext.assertEquals((Object)this.session1, (Object)this.session2);
        Session session3 = jmsContext.createThreadLocalSession(1);
        Session session4 = jmsContext.createThreadLocalSession(1);
        TestDefaultConnectionContext.assertTrue((boolean)session3.equals(session4));
        TestDefaultConnectionContext.assertFalse((boolean)this.session1.equals(session3));
    }

    class SessionThread
    implements Runnable {
        private ConnectionContext connContext;

        SessionThread(ConnectionContext connContext) {
            this.connContext = connContext;
        }

        @Override
        public void run() {
            try {
                TestDefaultConnectionContext.this.session1 = this.connContext.createThreadLocalSession(1);
                TestDefaultConnectionContext.this.session2 = this.connContext.createThreadLocalSession(1);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }
}

