/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetRunningActionsCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.CoordMaterializeTriggerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;

public class TestCoordMaterializeTriggerService
extends XDataTestCase {
    private Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordMaterializeTriggerService1() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-20T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, start, end, false, false, 0);
        this.waitForStatus(30000, job, Job.Status.PREP);
        CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable runnable = new CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable(3600, 300);
        runnable.run();
        this.waitForStatus(10000, job, Job.Status.RUNNING);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordMaterializeTriggerService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        int numWaitingActions = (Integer)this.jpaService.execute((JPAExecutor)new CoordJobGetRunningActionsCountJPAExecutor(coordJob.getId()));
        assert (numWaitingActions <= coordJob.getMatThrottling());
    }

    private void waitForStatus(int timeout, final CoordinatorJobBean job, final Job.Status status) {
        this.waitFor(timeout, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
                CoordinatorJobBean coordJob = (CoordinatorJobBean)TestCoordMaterializeTriggerService.this.jpaService.execute((JPAExecutor)coordGetCmd);
                return status == coordJob.getStatus();
            }
        });
    }

    public void testCoordMaterializeTriggerService2() throws Exception {
        Date start = new Date();
        Date end = new Date(start.getTime() + 172800000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, start, end, false, false, 0);
        this.waitForStatus(30000, job, Job.Status.PREP);
        CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable runnable = new CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable(3600, 300);
        runnable.run();
        this.waitForStatus(10000, job, Job.Status.RUNNING);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordMaterializeTriggerService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
    }

    public void testCoordMaterializeTriggerService3() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CoordMaterializeTriggerService.materialization.system.limit", "1");
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)this.services.get(JPAService.class);
        Date start = new Date();
        Date end = new Date(start.getTime() + 18000000L);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        this.addRecordToCoordActionTable(job1.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        job1.setMatThrottling(1);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job1);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.PREP, start, end, false, false, 0);
        CoordinatorJobBean job3 = this.addRecordToCoordJobTable(Job.Status.PREP, start, end, false, false, 0);
        CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable runnable = new CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable(3600, 300);
        runnable.run();
        this.waitForStatus(10000, job2, Job.Status.RUNNING);
        job2 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job2.getId()));
        TestCoordMaterializeTriggerService.assertEquals((Object)Job.Status.RUNNING, (Object)job2.getStatus());
        job3 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job3.getId()));
        TestCoordMaterializeTriggerService.assertEquals((Object)Job.Status.PREP, (Object)job3.getStatus());
    }

    public void testMaxMatThrottleNotPicked() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CoordMaterializeTriggerService.materialization.system.limit", "10");
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)this.services.get(JPAService.class);
        Date start = new Date();
        Date end = new Date(start.getTime() + 18000000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        job.setMatThrottling(3);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        job = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        Date lastModifiedDate = job.getLastModifiedTime();
        CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable runnable = new CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable(3600, 300);
        runnable.run();
        this.waitForModification(job.getId(), lastModifiedDate);
        job = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        TestCoordMaterializeTriggerService.assertNotSame((Object)lastModifiedDate, (Object)job.getLastModifiedTime());
        job.setMatThrottling(2);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        job = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        lastModifiedDate = job.getLastModifiedTime();
        runnable.run();
        job = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job.getId()));
        TestCoordMaterializeTriggerService.assertEquals((Object)lastModifiedDate, (Object)job.getLastModifiedTime());
    }

    private void waitForModification(final String id, final Date lastModifiedDate) {
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(id);
                CoordinatorJobBean coordJob = (CoordinatorJobBean)TestCoordMaterializeTriggerService.this.jpaService.execute((JPAExecutor)coordGetCmd);
                return !coordJob.getLastModifiedTime().equals(lastModifiedDate);
            }
        });
    }

    public void testMaxMatThrottleNotPickedMultipleJobs() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CoordMaterializeTriggerService.materialization.system.limit", "3");
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)this.services.get(JPAService.class);
        Date start = new Date();
        Date end = new Date(start.getTime() + 18000000L);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job1.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        job1.setMatThrottling(3);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job1);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        this.addRecordToCoordActionTable(job2.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job2.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        job2.setMatThrottling(3);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job2);
        CoordinatorJobBean job3 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        this.addRecordToCoordActionTable(job3.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job3.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        job3.setMatThrottling(2);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job3);
        job1 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job1.getId()));
        Date lastModifiedDate1 = job1.getLastModifiedTime();
        job2 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job2.getId()));
        Date lastModifiedDate2 = job2.getLastModifiedTime();
        job3 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job3.getId()));
        Date lastModifiedDate3 = job3.getLastModifiedTime();
        CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable runnable = new CoordMaterializeTriggerService.CoordMaterializeTriggerRunnable(3600, 300);
        runnable.run();
        this.waitForModification(job1.getId(), lastModifiedDate1);
        this.waitForModification(job2.getId(), lastModifiedDate2);
        this.waitForModification(job3.getId(), lastModifiedDate3);
        job1 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job1.getId()));
        TestCoordMaterializeTriggerService.assertNotSame((Object)lastModifiedDate1, (Object)job1.getLastModifiedTime());
        job2 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job2.getId()));
        TestCoordMaterializeTriggerService.assertNotSame((Object)lastModifiedDate2, (Object)job2.getLastModifiedTime());
        job3 = (CoordinatorJobBean)this.jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(job3.getId()));
        TestCoordMaterializeTriggerService.assertEquals((Object)lastModifiedDate3, (Object)job3.getLastModifiedTime());
    }

    @Override
    protected CoordinatorJobBean createCoordJob(Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.writeCoordXml(appPath);
        String startDateStr = null;
        String endDateStr = null;
        try {
            startDateStr = DateUtils.formatDateOozieTZ((Date)start);
            endDateStr = DateUtils.formatDateOozieTZ((Date)end);
            appXml = appXml.replaceAll("#start", startDateStr);
            appXml = appXml.replaceAll("#end", endDateStr);
        }
        catch (Exception ex) {
            TestCoordMaterializeTriggerService.fail((String)("Could not get coord-matLookup-trigger.xml" + ex.getMessage()));
            throw ex;
        }
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.COORDINATOR));
        coordJob.setAppName("COORD-TEST");
        coordJob.setAppPath(appPath.toString());
        coordJob.setStatus(status);
        coordJob.setTimeZone("America/Los_Angeles");
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(TestCoordMaterializeTriggerService.getTestUser());
        coordJob.setGroup(TestCoordMaterializeTriggerService.getTestGroup());
        Configuration conf = this.getCoordConf(appPath);
        coordJob.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.DAY);
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        coordJob.setMatThrottling(1);
        try {
            coordJob.setStartTime(start);
            coordJob.setEndTime(end);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordMaterializeTriggerService.fail((String)"Could not set Date/time");
        }
        return coordJob;
    }

    @Override
    protected String getCoordJobXml(Path appPath) {
        try {
            Reader reader = IOUtils.getResourceAsReader((String)"coord-matLookup-trigger.xml", (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get coord-matLookup-trigger.xml", (Object[])new Object[]{ioe}));
        }
    }
}

