/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;

public class TestLiteWorkflowAppService
extends XTestCase {
    private static String[] parentLibs1 = new String[]{"parent1.jar", "parent2.jar"};
    private static String[] childLibs1 = new String[]{"child1.jar", "child2.so"};
    private static String[] parentLibs2 = new String[]{"parent1.jar", "parent2.jar"};
    private static String[] childLibs2 = new String[0];
    private static String[] parentLibs3 = new String[0];
    private static String[] childLibs3 = new String[]{"child1.jar", "child2.so"};
    private static String[] parentLibs4 = new String[0];
    private static String[] childLibs4 = new String[0];
    private static String[] parentLibs5 = new String[]{"parent1.jar", "parent2.jar", "same.jar"};
    private static String[] childLibs5 = new String[]{"child1.jar", "same.jar", "child2.so"};

    public void testService() throws Exception {
        Services services = new Services();
        try {
            services.init();
            TestLiteWorkflowAppService.assertNotNull((Object)services.get(WorkflowAppService.class));
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadDefinition() throws Exception {
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            XConfiguration conf = new XConfiguration();
            WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
            String wfDef = wps.readDefinition(this.getTestCaseFileUri("workflow.xml"), TestLiteWorkflowAppService.getTestUser(), (Configuration)conf);
            TestLiteWorkflowAppService.assertNotNull((String)reader.toString(), (Object)wfDef);
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxWfDefinition() throws Exception {
        this.setSystemProperty("oozie.service.WorkflowAppService.WorkflowDefinitionMaxLength", "100");
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            XConfiguration conf = new XConfiguration();
            WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
            wps.readDefinition(this.getTestCaseFileUri("workflow.xml"), TestLiteWorkflowAppService.getTestUser(), (Configuration)conf);
            TestLiteWorkflowAppService.fail((String)"an exception should be thrown as the definition exceeds the given maximum");
        }
        catch (WorkflowException wfe) {
            TestLiteWorkflowAppService.assertEquals((Object)wfe.getErrorCode(), (Object)ErrorCode.E0736);
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoAppPath() throws Exception {
        Services services = new Services();
        services.init();
        WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
        try {
            TestLiteWorkflowAppService.assertNotNull((Object)wps.parseDef((Configuration)new XConfiguration()));
            TestLiteWorkflowAppService.fail();
        }
        catch (Exception exception) {
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchema() throws Exception {
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            WorkflowApp app = wps.parseDef((Configuration)jobConf);
            TestLiteWorkflowAppService.assertNotNull((Object)app);
            TestLiteWorkflowAppService.assertEquals((String)"test-wf", (String)app.getName());
            reader = IOUtils.getResourceAsReader((String)"wf-schema-invalid.xml", (int)-1);
            writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            try {
                wps.parseDef((Configuration)jobConf);
                TestLiteWorkflowAppService.fail();
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtSchema() throws Exception {
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.setSystemProperty("oozie.service.ActionService.executor.ext.classes", TestActionExecutor.class.getName());
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            LiteWorkflowApp app = (LiteWorkflowApp)wps.parseDef((Configuration)jobConf);
            TestLiteWorkflowAppService.assertNotNull((Object)app);
            TestLiteWorkflowAppService.assertEquals((String)"test-wf", (String)app.getName());
            reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-invalid.xml", (int)-1);
            writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            try {
                wps.parseDef((Configuration)jobConf);
                TestLiteWorkflowAppService.fail();
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActionNameLength() throws Exception {
        this.setSystemProperty("oozie.service.ActionService.executor.ext.classes", TestActionExecutor.class.getName());
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-action-name-too-long.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            try {
                LiteWorkflowApp app = (LiteWorkflowApp)wps.parseDef((Configuration)jobConf);
                TestLiteWorkflowAppService.fail();
            }
            catch (WorkflowException ex) {
                TestLiteWorkflowAppService.assertEquals((Object)ErrorCode.E0724, (Object)ex.getErrorCode());
            }
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParsing() throws Exception {
        Services services = new Services();
        try {
            services.init();
            WorkflowAppService wps = (WorkflowAppService)services.get(WorkflowAppService.class);
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            LiteWorkflowApp app = (LiteWorkflowApp)wps.parseDef((Configuration)jobConf);
            TestLiteWorkflowAppService.assertNotNull((Object)app);
            TestLiteWorkflowAppService.assertEquals((String)"test-wf", (String)app.getName());
            TestLiteWorkflowAppService.assertNotNull((Object)app.getNode(":start:"));
            TestLiteWorkflowAppService.assertEquals((String)"a", (String)((String)app.getNode(":start:").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"b", (String)((String)app.getNode("a").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"c", (String)((String)app.getNode("a").getTransitions().get(1)));
            TestLiteWorkflowAppService.assertEquals((String)"c", (String)((String)app.getNode("a").getTransitions().get(2)));
            TestLiteWorkflowAppService.assertTrue((boolean)app.getNode("b").getConf().contains("kill"));
            TestLiteWorkflowAppService.assertEquals((String)"d", (String)((String)app.getNode("c").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"e", (String)((String)app.getNode("c").getTransitions().get(1)));
            TestLiteWorkflowAppService.assertEquals((int)2, (int)app.getNode("c").getTransitions().size());
            TestLiteWorkflowAppService.assertEquals((String)"f", (String)((String)app.getNode("d").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"b", (String)((String)app.getNode("d").getTransitions().get(1)));
            TestLiteWorkflowAppService.assertTrue((boolean)app.getNode("d").getConf().startsWith("<map-reduce"));
            TestLiteWorkflowAppService.assertEquals((String)"f", (String)((String)app.getNode("e").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"b", (String)((String)app.getNode("e").getTransitions().get(1)));
            TestLiteWorkflowAppService.assertTrue((boolean)app.getNode("e").getConf().startsWith("<pig"));
            TestLiteWorkflowAppService.assertEquals((String)"g", (String)((String)app.getNode("f").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"z", (String)((String)app.getNode("g").getTransitions().get(0)));
            TestLiteWorkflowAppService.assertEquals((String)"b", (String)((String)app.getNode("g").getTransitions().get(1)));
            TestLiteWorkflowAppService.assertTrue((boolean)app.getNode("g").getConf().startsWith("<fs"));
            TestLiteWorkflowAppService.assertNotNull((Object)app.getNode("z"));
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateprotoConf() throws Exception {
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            this.createTestCaseSubDir("lib");
            writer = new FileWriter(new File(this.getTestCaseDir(), "lib/maputil.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            writer = new FileWriter(new File(this.getTestCaseDir(), "lib/reduceutil.so"));
            writer.write("bla bla");
            ((Writer)writer).close();
            this.createTestCaseSubDir("scripts");
            writer = new FileWriter(new File(this.getTestCaseDir(), "scripts/myscript.sh"));
            writer.write("bla bla");
            ((Writer)writer).close();
            WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            XConfiguration protoConf = wps.createProtoActionConf((Configuration)jobConf, true);
            TestLiteWorkflowAppService.assertEquals((String)TestLiteWorkflowAppService.getTestUser(), (String)protoConf.get("user.name"));
            TestLiteWorkflowAppService.assertEquals((int)2, (int)protoConf.getStrings("oozie.wf.application.lib").length);
            ArrayList<String> found = new ArrayList<String>();
            found.add(protoConf.getStrings("oozie.wf.application.lib")[0]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[1]);
            ArrayList<String> expected = new ArrayList<String>();
            expected.add(this.getTestCaseFileUri("lib/reduceutil.so"));
            expected.add(this.getTestCaseFileUri("lib/maputil.jar"));
            Collections.sort(found);
            Collections.sort(expected);
            for (int i = 0; i < expected.size(); ++i) {
                assert (new URI((String)expected.get(i)).equals(new URI((String)found.get(i))));
            }
            Assert.assertTrue((!new URI((String)found.get(0)).equals(new URI((String)found.get(1))) ? 1 : 0) != 0);
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateprotoConfWithLibPath() throws Exception {
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            this.createTestCaseSubDir("lib");
            writer = new FileWriter(new File(this.getTestCaseDir(), "lib/maputil.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            writer = new FileWriter(new File(this.getTestCaseDir(), "lib/reduceutil.so"));
            writer.write("bla bla");
            ((Writer)writer).close();
            this.createTestCaseSubDir("libx");
            writer = new FileWriter(new File(this.getTestCaseDir(), "libx/maputilx.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.set("oozie.libpath", this.getTestCaseFileUri("libx"));
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            XConfiguration protoConf = wps.createProtoActionConf((Configuration)jobConf, true);
            TestLiteWorkflowAppService.assertEquals((String)TestLiteWorkflowAppService.getTestUser(), (String)protoConf.get("user.name"));
            TestLiteWorkflowAppService.assertEquals((int)3, (int)protoConf.getStrings("oozie.wf.application.lib").length);
            ArrayList<String> found = new ArrayList<String>();
            found.add(protoConf.getStrings("oozie.wf.application.lib")[0]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[1]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[2]);
            ArrayList<String> expected = new ArrayList<String>();
            expected.add(this.getTestCaseFileUri("lib/reduceutil.so"));
            expected.add(this.getTestCaseFileUri("lib/maputil.jar"));
            expected.add(this.getTestCaseFileUri("libx/maputilx.jar"));
            Collections.sort(found);
            Collections.sort(expected);
            TestLiteWorkflowAppService.assertEquals((int)expected.size(), (int)found.size());
            for (int i = 0; i < expected.size(); ++i) {
                assert (new URI((String)expected.get(i)).equals(new URI((String)found.get(i))));
            }
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateprotoConfWithMulipleLibPath() throws Exception {
        Services services = new Services();
        try {
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            this.createTestCaseSubDir("lib");
            writer = new FileWriter(new File(this.getTestCaseDir(), "lib/maputil.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            writer = new FileWriter(new File(this.getTestCaseDir(), "lib/reduceutil.so"));
            writer.write("bla bla");
            ((Writer)writer).close();
            this.createTestCaseSubDir("libx");
            writer = new FileWriter(new File(this.getTestCaseDir(), "libx/maputil_x.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            this.createTestCaseSubDir("liby");
            writer = new FileWriter(new File(this.getTestCaseDir(), "liby/maputil_y1.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            writer = new FileWriter(new File(this.getTestCaseDir(), "liby/maputil_y2.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            this.createTestCaseSubDir("libz");
            writer = new FileWriter(new File(this.getTestCaseDir(), "libz/maputil_z.jar"));
            writer.write("bla bla");
            ((Writer)writer).close();
            WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
            jobConf.setStrings("oozie.libpath", new String[]{this.getTestCaseFileUri("libx"), this.getTestCaseFileUri("liby"), this.getTestCaseFileUri("libz")});
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            XConfiguration protoConf = wps.createProtoActionConf((Configuration)jobConf, true);
            TestLiteWorkflowAppService.assertEquals((String)TestLiteWorkflowAppService.getTestUser(), (String)protoConf.get("user.name"));
            TestLiteWorkflowAppService.assertEquals((int)6, (int)protoConf.getStrings("oozie.wf.application.lib").length);
            ArrayList<String> found = new ArrayList<String>();
            found.add(protoConf.getStrings("oozie.wf.application.lib")[0]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[1]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[2]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[3]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[4]);
            found.add(protoConf.getStrings("oozie.wf.application.lib")[5]);
            ArrayList<String> expected = new ArrayList<String>();
            expected.add(this.getTestCaseFileUri("lib/reduceutil.so"));
            expected.add(this.getTestCaseFileUri("lib/maputil.jar"));
            expected.add(this.getTestCaseFileUri("libx/maputil_x.jar"));
            expected.add(this.getTestCaseFileUri("liby/maputil_y1.jar"));
            expected.add(this.getTestCaseFileUri("liby/maputil_y2.jar"));
            expected.add(this.getTestCaseFileUri("libz/maputil_z.jar"));
            Collections.sort(expected);
            Collections.sort(found);
            TestLiteWorkflowAppService.assertEquals((int)expected.size(), (int)found.size());
            for (int i = 0; i < expected.size(); ++i) {
                assert (new URI((String)expected.get(i)).equals(new URI((String)found.get(i))));
            }
        }
        finally {
            services.destroy();
        }
    }

    public void testCreateProtoConfWithSubWorkflowLib1() throws Exception {
        String inherit = "true";
        String inheritWF = null;
        String[] expectedLibs1 = new String[]{"parent1.jar", "parent2.jar", "child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 1, parentLibs1, childLibs1, expectedLibs1);
        String[] expectedLibs2 = new String[]{"parent1.jar", "parent2.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 2, parentLibs2, childLibs2, expectedLibs2);
        String[] expectedLibs3 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 3, parentLibs3, childLibs3, expectedLibs3);
        String[] expectedLibs4 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 4, parentLibs4, childLibs4, expectedLibs4);
        String[] expectedLibs5 = new String[]{"parent1.jar", "parent2.jar", "child1.jar", "child2.so", "same.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 5, parentLibs5, childLibs5, expectedLibs5);
    }

    public void testCreateProtoConfWithSubWorkflowLib2() throws Exception {
        String inherit = "false";
        String inheritWF = null;
        String[] expectedLibs1 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 1, parentLibs1, childLibs1, expectedLibs1);
        String[] expectedLibs2 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 2, parentLibs2, childLibs2, expectedLibs2);
        String[] expectedLibs3 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 3, parentLibs3, childLibs3, expectedLibs3);
        String[] expectedLibs4 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 4, parentLibs4, childLibs4, expectedLibs4);
        String[] expectedLibs5 = new String[]{"child1.jar", "child2.so", "same.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 5, parentLibs5, childLibs5, expectedLibs5);
    }

    public void testCreateProtoConfWithSubWorkflowLib3() throws Exception {
        String inherit = "true";
        String inheritWF = "true";
        String[] expectedLibs1 = new String[]{"parent1.jar", "parent2.jar", "child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 1, parentLibs1, childLibs1, expectedLibs1);
        String[] expectedLibs2 = new String[]{"parent1.jar", "parent2.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 2, parentLibs2, childLibs2, expectedLibs2);
        String[] expectedLibs3 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 3, parentLibs3, childLibs3, expectedLibs3);
        String[] expectedLibs4 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 4, parentLibs4, childLibs4, expectedLibs4);
        String[] expectedLibs5 = new String[]{"parent1.jar", "parent2.jar", "child1.jar", "child2.so", "same.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 5, parentLibs5, childLibs5, expectedLibs5);
    }

    public void testCreateProtoConfWithSubWorkflowLib4() throws Exception {
        String inherit = "false";
        String inheritWF = "true";
        String[] expectedLibs1 = new String[]{"parent1.jar", "parent2.jar", "child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 1, parentLibs1, childLibs1, expectedLibs1);
        String[] expectedLibs2 = new String[]{"parent1.jar", "parent2.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 2, parentLibs2, childLibs2, expectedLibs2);
        String[] expectedLibs3 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 3, parentLibs3, childLibs3, expectedLibs3);
        String[] expectedLibs4 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 4, parentLibs4, childLibs4, expectedLibs4);
        String[] expectedLibs5 = new String[]{"parent1.jar", "parent2.jar", "child1.jar", "child2.so", "same.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 5, parentLibs5, childLibs5, expectedLibs5);
    }

    public void testCreateProtoConfWithSubWorkflowLib5() throws Exception {
        String inherit = "true";
        String inheritWF = "false";
        String[] expectedLibs1 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 1, parentLibs1, childLibs1, expectedLibs1);
        String[] expectedLibs2 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 2, parentLibs2, childLibs2, expectedLibs2);
        String[] expectedLibs3 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 3, parentLibs3, childLibs3, expectedLibs3);
        String[] expectedLibs4 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 4, parentLibs4, childLibs4, expectedLibs4);
        String[] expectedLibs5 = new String[]{"child1.jar", "child2.so", "same.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 5, parentLibs5, childLibs5, expectedLibs5);
    }

    public void testCreateProtoConfWithSubWorkflowLib6() throws Exception {
        String inherit = "false";
        String inheritWF = "false";
        String[] expectedLibs1 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 1, parentLibs1, childLibs1, expectedLibs1);
        String[] expectedLibs2 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 2, parentLibs2, childLibs2, expectedLibs2);
        String[] expectedLibs3 = new String[]{"child1.jar", "child2.so"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 3, parentLibs3, childLibs3, expectedLibs3);
        String[] expectedLibs4 = new String[]{};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 4, parentLibs4, childLibs4, expectedLibs4);
        String[] expectedLibs5 = new String[]{"child1.jar", "child2.so", "same.jar"};
        this.checkSubworkflowLibHelper(inherit, inheritWF, 5, parentLibs5, childLibs5, expectedLibs5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSubworkflowLibHelper(String inherit, String inheritWF, int unique, String[] parentLibs, String[] childLibs, String[] expectedLibs) throws Exception {
        Services services = new Services();
        try {
            services.getConf().set("oozie.subworkflow.classpath.inheritance", inherit);
            services.init();
            Reader reader = IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1);
            String childWFDir = this.createTestCaseSubDir("child-wf-" + unique);
            File childWFFile = new File(childWFDir, "workflow.xml");
            FileWriter writer = new FileWriter(childWFFile);
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
            XConfiguration jobConf = new XConfiguration();
            jobConf.set("oozie.wf.application.path", childWFFile.toURI().toString());
            jobConf.set("user.name", TestLiteWorkflowAppService.getTestUser());
            if (inheritWF != null) {
                jobConf.set("oozie.wf.subworkflow.classpath.inheritance", inheritWF);
            }
            String childLibDir = this.createTestCaseSubDir("child-wf-" + unique, "lib");
            for (String childLib : childLibs) {
                writer = new FileWriter(new File(childLibDir, childLib));
                writer.write("bla bla");
                ((Writer)writer).close();
            }
            String parentLibDir = this.createTestCaseSubDir("parent-wf-" + unique, "lib");
            String[] parentLibsFullPaths = new String[parentLibs.length];
            for (int i = 0; i < parentLibs.length; ++i) {
                parentLibsFullPaths[i] = new File(parentLibDir, parentLibs[i]).toString();
                writer = new FileWriter(parentLibsFullPaths[i]);
                writer.write("bla bla");
                ((Writer)writer).close();
            }
            jobConf.setStrings("oozie.wf.application.lib", parentLibsFullPaths);
            XConfiguration protoConf = wps.createProtoActionConf((Configuration)jobConf, true);
            TestLiteWorkflowAppService.assertEquals((String)TestLiteWorkflowAppService.getTestUser(), (String)protoConf.get("user.name"));
            Object[] foundLibs = protoConf.getStrings("oozie.wf.application.lib");
            if (expectedLibs.length > 0) {
                TestLiteWorkflowAppService.assertEquals((int)expectedLibs.length, (int)foundLibs.length);
                for (int i = 0; i < foundLibs.length; ++i) {
                    Path p = new Path((String)foundLibs[i]);
                    foundLibs[i] = p.getName();
                }
                Arrays.sort(expectedLibs);
                Arrays.sort(foundLibs);
                TestLiteWorkflowAppService.assertEquals((String)Arrays.toString(expectedLibs), (String)Arrays.toString(foundLibs));
            } else {
                TestLiteWorkflowAppService.assertEquals(null, (Object)foundLibs);
            }
        }
        finally {
            services.destroy();
        }
    }

    public static class TestActionExecutor
    extends ActionExecutor {
        protected TestActionExecutor() {
            super("test");
        }

        public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public boolean isCompleted(String externalStatus) {
            return true;
        }
    }
}

