/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.test.XTestCase;

public class TestLiteWorkflowStoreService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testService() throws Exception {
        TestLiteWorkflowStoreService.assertNotNull((Object)Services.get().get(WorkflowStoreService.class));
    }

    public void testCreateStore() throws Exception {
        WorkflowStoreService wls = (WorkflowStoreService)Services.get().get(WorkflowStoreService.class);
        TestLiteWorkflowStoreService.assertNotNull((Object)wls);
        TestLiteWorkflowStoreService.assertNotNull((Object)wls.create());
    }

    public void testRetry() throws Exception {
        String errorCodeWithWhitespaces = "\n\t\tTEST_ERROR\n  ";
        Configuration testConf = ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf();
        testConf.set("oozie.service.LiteWorkflowStoreService.user.retry.error.code", errorCodeWithWhitespaces);
        testConf.set("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", " ");
        Set allowedRetryCodes = LiteWorkflowStoreService.getUserRetryErrorCode();
        TestLiteWorkflowStoreService.assertTrue((boolean)allowedRetryCodes.contains("TEST_ERROR"));
    }

    public void testRetryAllErrorCode() throws Exception {
        String errorCodeWithWhitespaces = "\n\t\tTEST_ERROR,ALL\n  ";
        Configuration testConf = ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf();
        testConf.set("oozie.service.LiteWorkflowStoreService.user.retry.error.code", errorCodeWithWhitespaces);
        Set allowedRetryCodes = LiteWorkflowStoreService.getUserRetryErrorCode();
        TestLiteWorkflowStoreService.assertTrue((boolean)allowedRetryCodes.contains("TEST_ERROR"));
        TestLiteWorkflowStoreService.assertTrue((boolean)allowedRetryCodes.contains("ALL"));
        testConf.set("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", "ALL");
        allowedRetryCodes = LiteWorkflowStoreService.getUserRetryErrorCode();
        TestLiteWorkflowStoreService.assertTrue((boolean)allowedRetryCodes.contains("TEST_ERROR"));
        TestLiteWorkflowStoreService.assertTrue((boolean)allowedRetryCodes.contains("ALL"));
        testConf.set("oozie.service.LiteWorkflowStoreService.user.retry.error.code", " ");
        testConf.set("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", "ALL");
        allowedRetryCodes = LiteWorkflowStoreService.getUserRetryErrorCode();
        TestLiteWorkflowStoreService.assertTrue((boolean)allowedRetryCodes.contains("ALL"));
    }
}

