/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Date;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PauseTransitService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;

public class TestPauseTransitService
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testPauseUnpause1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        job.setPauseTime(new Date(new Date().getTime() - 30000L));
        job.setKickoffTime(new Date(new Date().getTime() + 3600000L));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String jobId = job.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return job1.getStatus() == Job.Status.PREPPAUSED;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.PREPPAUSED, (Object)job.getStatus());
        job.setPauseTime(new Date(new Date().getTime() + 3600000L));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        pauseStartRunnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return job1.getStatus() == Job.Status.PREP;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
    }

    public void testPauseUnpause2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        job.setPauseTime(new Date(new Date().getTime() - 30000L));
        job.setKickoffTime(new Date(new Date().getTime() + 3600000L));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String jobId = job.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return job1.getStatus() == Job.Status.PREPPAUSED;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.PREPPAUSED, (Object)job.getStatus());
        job.setPauseTime(null);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        pauseStartRunnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return job1.getStatus() == Job.Status.PREP;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.PREP, (Object)job.getStatus());
    }

    public void testPauseBundleAndCoordinator() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        Date pauseTime = new Date(new Date().getTime() - 30000L);
        job.setPauseTime(pauseTime);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        BundleActionBean bundleAction1 = this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.RUNNING);
        BundleActionBean bundleAction2 = this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.RUNNING);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable("action1", Job.Status.RUNNING, start, end, false);
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable("action2", Job.Status.RUNNING, start, end, false);
        coordJob1.setPauseTime(pauseTime);
        coordJob1.setBundleId(job.getId());
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME, coordJob1);
        coordJob2.setPauseTime(pauseTime);
        coordJob2.setBundleId(job.getId());
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME, coordJob2);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String jobId = job.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bJob1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return bJob1.getStatus() == Job.Status.PAUSED;
            }
        });
        final String coordJobId1 = coordJob1.getId();
        final String coordJobId2 = coordJob2.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean cJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId1));
                CoordinatorJobBean cJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId2));
                return cJob1.getStatus() == Job.Status.PAUSED && cJob2.getStatus() == Job.Status.PAUSED;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
        coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId1));
        TestPauseTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)coordJob1.getStatus());
        coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId2));
        TestPauseTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)coordJob2.getStatus());
        bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(job.getId(), "action1"));
        TestPauseTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)bundleAction1.getStatus());
        bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(job.getId(), "action2"));
        TestPauseTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)bundleAction2.getStatus());
    }

    public void testUnpauseBundleAndCoordinator() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PAUSED, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        job.setPauseTime(null);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        BundleActionBean bundleAction1 = this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.PAUSED);
        BundleActionBean bundleAction2 = this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.PAUSED);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable("action1", Job.Status.PAUSED, start, end, false);
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable("action2", Job.Status.PAUSED, start, end, false);
        coordJob1.setPauseTime(null);
        coordJob1.setBundleId(job.getId());
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME, coordJob1);
        coordJob2.setPauseTime(null);
        coordJob2.setBundleId(job.getId());
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME, coordJob2);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPauseTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String jobId = job.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bJob1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return bJob1.getStatus() == Job.Status.RUNNING;
            }
        });
        final String coordJobId1 = coordJob1.getId();
        final String coordJobId2 = coordJob2.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean cJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId1));
                CoordinatorJobBean cJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId2));
                return cJob1.getStatus() == Job.Status.RUNNING && cJob2.getStatus() == Job.Status.RUNNING;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
        coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId1));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob1.getStatus());
        coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId2));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob2.getStatus());
        bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(job.getId(), "action1"));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleAction1.getStatus());
        bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(job.getId(), "action2"));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleAction2.getStatus());
    }

    public void testPauseCoordinatorForBackwardSupport() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        Date pauseTime = new Date(new Date().getTime() - 30000L);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable("action1", Job.Status.RUNNING, start, end, false);
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable("action2", Job.Status.RUNNING, start, end, false);
        coordJob1.setAppNamespace("uri:oozie:coordinator:0.1");
        coordJob1.setPauseTime(pauseTime);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME, coordJob1);
        coordJob2.setAppNamespace("uri:oozie:coordinator:0.1");
        coordJob2.setPauseTime(pauseTime);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME, coordJob2);
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String coordJobId1 = coordJob1.getId();
        String coordJobId2 = coordJob2.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean cJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId1));
                return cJob1.getStatus() == Job.Status.RUNNING;
            }
        });
        coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId1));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob1.getStatus());
        coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId2));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob2.getStatus());
    }

    public void testStart1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        job.setKickoffTime(new Date(new Date().getTime() - 30000L));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String jobId = job.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return job1.getStatus() == Job.Status.RUNNING;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    public void testStart2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPauseTransitService.assertNotNull((Object)jpaService);
        job.setKickoffTime(new Date(new Date().getTime() - 30000L));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)job);
        PauseTransitService.PauseTransitRunnable pauseStartRunnable = new PauseTransitService.PauseTransitRunnable();
        pauseStartRunnable.run();
        final String jobId = job.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return job1.getStatus() == Job.Status.RUNNING;
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestPauseTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(String coordId, Job.Status status, Date start, Date end, boolean pending) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, start, end, pending, false, 0);
        coordJob.setId(coordId);
        coordJob.setAppName(coordId);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPauseTransitService.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPauseTransitService.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }
}

