/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.PurgeXCommand;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PurgeService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestPurgeService
extends XDataTestCase {
    private Services services;
    String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testPurgeServiceForWorkflow() throws Exception {
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setStrings("user.name", new String[]{TestPurgeService.getTestUser()});
        conf.setStrings("group.name", new String[]{TestPurgeService.getTestGroup()});
        conf.set("oozie.wf.log.token", "t");
        conf.set("external-status", "ok");
        conf.set("signal-value", "based_on_action_status");
        final String jobId = engine.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestPurgeService.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)engine.getJob(jobId).getStatus());
        new PurgeXCommand(1, 1, 1, 10000).call();
        this.sleep(1000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(jobId);
        WorkflowJobBean wfBean = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        Date endDate = new Date(System.currentTimeMillis() - 172800000L);
        wfBean.setEndTime(endDate);
        wfBean.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END, (Object)wfBean);
        PurgeService.PurgeRunnable purgeRunnable = new PurgeService.PurgeRunnable(1, 1, 1, 100);
        purgeRunnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    engine.getJob(jobId).getStatus();
                }
                catch (Exception ex) {
                    return true;
                }
                return false;
            }
        });
        try {
            engine.getJob(jobId).getStatus();
            TestPurgeService.fail((String)"Job should be purged. Should fail.");
        }
        catch (Exception ex) {
            TestPurgeService.assertEquals(ex.getClass(), DagEngineException.class);
            DagEngineException dex = (DagEngineException)ex;
            TestPurgeService.assertEquals((Object)ErrorCode.E0604, (Object)dex.getErrorCode());
        }
    }

    public void testPurgeServiceForCoordinator() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, start, end, false, false, 0);
        final String jobId = job.getId();
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeService.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetExecutor = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetExecutor = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetExecutor);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetExecutor);
        TestPurgeService.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
        TestPurgeService.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        PurgeService.PurgeRunnable purgeRunnable = new PurgeService.PurgeRunnable(1, 1, 1, 100);
        purgeRunnable.run();
        final CoordinatorEngine engine = new CoordinatorEngine("u");
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    engine.getCoordJob(jobId).getStatus();
                }
                catch (Exception ex) {
                    return true;
                }
                return false;
            }
        });
        try {
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetExecutor);
            TestPurgeService.fail((String)"Job should be purged. Should fail.");
        }
        catch (JPAExecutorException jPAExecutorException) {
            // empty catch block
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetExecutor);
            TestPurgeService.fail((String)"Action should be purged. Should fail.");
        }
        catch (JPAExecutorException jPAExecutorException) {
            // empty catch block
        }
    }

    public void testPurgeServiceForBundle() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        final String jobId = job.getId();
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeService.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPurgeService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor1 = new BundleActionGetJPAExecutor(job.getId(), "action1");
        BundleActionBean action1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
        TestPurgeService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action1.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor2 = new BundleActionGetJPAExecutor(job.getId(), "action2");
        BundleActionBean action2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
        TestPurgeService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action2.getStatus());
        PurgeService.PurgeRunnable purgeRunnable = new PurgeService.PurgeRunnable(1, 1, 1, 100);
        purgeRunnable.run();
        final BundleEngine engine = new BundleEngine("u");
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    engine.getBundleJob(jobId).getStatus();
                }
                catch (Exception ex) {
                    return true;
                }
                return false;
            }
        });
        try {
            job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
            TestPurgeService.fail((String)"Job should be purged. Should fail.");
        }
        catch (JPAExecutorException jPAExecutorException) {
            // empty catch block
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
            TestPurgeService.fail((String)"Action should be purged. Should fail.");
        }
        catch (JPAExecutorException jPAExecutorException) {
            // empty catch block
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
            TestPurgeService.fail((String)"Action should be purged. Should fail.");
        }
        catch (JPAExecutorException jPAExecutorException) {
            // empty catch block
        }
    }

    protected BundleJobBean addRecordToBundleJobTable(Job.Status jobStatus, Date lastModifiedTime) throws Exception {
        BundleJobBean bundle = this.createBundleJob(jobStatus, false);
        bundle.setLastModifiedTime(lastModifiedTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeService.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeService.fail((String)"Unable to insert the test bundle job record to table");
            throw je;
        }
        return bundle;
    }

    @Override
    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, start, end, pending, doneMatd, lastActionNum);
        coordJob.setLastModifiedTime(DateUtils.parseDateOozieTZ((String)"2009-12-18T01:00Z"));
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeService.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeService.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }
}

