/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.HiveActionExecutor;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.PigActionExecutor;
import org.apache.oozie.action.hadoop.TestJavaActionExecutor;
import org.apache.oozie.hadoop.utils.HadoopShims;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.junit.Test;

public class TestShareLibService
extends XFsTestCase {
    Services services;
    private static String testCaseDirPath;
    String shareLibPath = "shareLibPath";
    SimpleDateFormat dt = new SimpleDateFormat("yyyyMMddHHmmss");
    final String sharelibPath = "sharelib";
    final String metaFile = "/user/test/config.properties";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        testCaseDirPath = this.getTestCaseDir();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void setSystemProps() throws IOException {
        IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)(MyOozie.class.getName() + ".jar"), (Class[])new Class[]{MyOozie.class});
        IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)(MyPig.class.getName() + ".jar"), (Class[])new Class[]{MyPig.class});
        IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)(TestHive.class.getName() + ".jar"), (Class[])new Class[]{TestHive.class});
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.service.WorkflowAppService.system.libpath", this.getFsTestCaseDir() + "/share/lib");
        conf.set("oozie.services", conf.get("oozie.services") + "," + DummyShareLibService.class.getName());
        conf.setStrings("oozie.service.ActionService.executor.classes", new String[]{DummyPigActionExecutor.class.getName(), DummyHiveActionExecutor.class.getName()});
    }

    @Test
    public void testfailFast() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.service.ShareLibService.fail.fast.on.startup", "true");
        conf.set("oozie.service.ShareLibService.mapping.file", String.valueOf(new Date().getTime()));
        try {
            this.services.init();
            TestShareLibService.fail((String)"Should throw exception");
        }
        catch (Throwable e) {
            TestShareLibService.assertTrue((boolean)e.getMessage().contains("E0104: Could not fully initialize service"));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateLauncherLibPath() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            List launcherPath = shareLibService.getSystemLibJars("oozie");
            TestShareLibService.assertNotNull((Object)launcherPath);
            TestShareLibService.assertTrue((boolean)this.getFileSystem().exists((Path)launcherPath.get(0)));
            List pigLauncherPath = shareLibService.getSystemLibJars("pig");
            TestShareLibService.assertTrue((boolean)this.getFileSystem().exists((Path)pigLauncherPath.get(0)));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddShareLibDistributedCache() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        try {
            this.services.init();
            String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node></java>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)new XConfiguration()).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            PigActionExecutor ae = new PigActionExecutor();
            JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), MyPig.class.getName() + ".jar", MyOozie.class.getName() + ".jar");
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddShareLib_pig() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        try {
            this.services.init();
            String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node></pig>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)new XConfiguration()).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            PigActionExecutor ae = new PigActionExecutor();
            JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), "MyPig.jar", "MyOozie.jar");
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddShareLib_pig_withVersion() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        FileSystem fs = this.getFileSystem();
        Date time = new Date(System.currentTimeMillis());
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        fs.mkdirs(libpath);
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
        Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
        fs.mkdirs(pigPath);
        fs.mkdirs(pigPath1);
        fs.mkdirs(pigPath2);
        this.createFile(libpath.toString() + "/" + "pig_10" + "/" + "pig-10.jar");
        try {
            this.services.init();
            String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><property><name>oozie.action.sharelib.for.pig</name><value>pig_10</value></property></pig>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            protoConf.setBoolean("oozie.use.system.libpath", true);
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            PigActionExecutor ae = new PigActionExecutor();
            JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.pig", "pig_10");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), "MyPig.jar", "MyOozie.jar", "pig-10.jar");
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeShareLib() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        FileSystem fs = this.getFileSystem();
        long expiryTime = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7), TimeUnit.DAYS);
        String expireTs = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs1 = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Path expirePath = new Path(basePath, "lib_" + expireTs);
        Path noexpirePath = new Path(basePath, "lib_" + noexpireTs);
        Path noexpirePath1 = new Path(basePath, "lib_" + noexpireTs1);
        this.createDirs(fs, expirePath, noexpirePath, noexpirePath1);
        try {
            this.services.init();
            TestShareLibService.assertEquals((int)4, (int)fs.listStatus(basePath).length);
            TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath));
            TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath1));
            TestShareLibService.assertTrue((boolean)fs.exists(expirePath));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeLauncherJar() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        FileSystem fs = this.getFileSystem();
        long expiryTime = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7), TimeUnit.DAYS);
        String expireTs = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs1 = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Path expirePath = new Path(basePath, "launcher_" + expireTs);
        Path noexpirePath = new Path(basePath, "launcher_" + noexpireTs);
        Path noexpirePath1 = new Path(basePath, "launcher_" + noexpireTs1);
        this.createDirs(fs, expirePath, noexpirePath, noexpirePath1);
        try {
            this.services.init();
            TestShareLibService.assertEquals((int)4, (int)fs.listStatus(basePath).length);
            TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath));
            TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath1));
            TestShareLibService.assertTrue((boolean)fs.exists(expirePath));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeJar() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        final FileSystem fs = this.getFileSystem();
        long expiryTime = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7), TimeUnit.DAYS);
        String expireTs = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String expireTs1 = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        String noexpireTs = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs1 = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        final Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Path expirePath = new Path(basePath, "launcher_" + expireTs);
        Path expirePath1 = new Path(basePath, "launcher_" + expireTs1);
        Path noexpirePath = new Path(basePath, "launcher_" + noexpireTs);
        Path noexpirePath1 = new Path(basePath, "launcher_" + noexpireTs1);
        this.createDirs(fs, expirePath, expirePath1, noexpirePath, noexpirePath1);
        try {
            this.services.init();
            this.waitFor(20000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return fs.listStatus(basePath).length == 4;
                }
            });
            TestShareLibService.assertEquals((int)4, (int)fs.listStatus(basePath).length);
            TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath));
            TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath1));
            TestShareLibService.assertTrue((boolean)fs.exists(expirePath));
            TestShareLibService.assertFalse((boolean)fs.exists(expirePath1));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetShareLibCompatible() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        FileSystem fs = this.getFileSystem();
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        fs.mkdirs(basePath);
        Path pigPath = new Path(basePath.toString() + "/" + "pig");
        fs.mkdirs(pigPath);
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig"));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetShareLibPath() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        FileSystem fs = this.getFileSystem();
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Date time = new Date(System.currentTimeMillis());
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        fs.mkdirs(libpath);
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
        Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
        fs.mkdirs(pigPath);
        fs.mkdirs(pigPath1);
        fs.mkdirs(pigPath2);
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig"));
            TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig_9"));
            TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig_10"));
            TestShareLibService.assertNull((Object)shareLibService.getShareLibJars("pig_11"));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShareLib() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        FileSystem fs = this.getFileSystem();
        String dir1 = this.dt.format(new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String dir2 = this.dt.format(new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        String dir3 = this.dt.format(new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(3L, TimeUnit.DAYS)));
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Path path1 = new Path(basePath, "lib_" + dir1);
        Path path2 = new Path(basePath, "lib_" + dir2);
        Path path3 = new Path(basePath, "lib_" + dir3);
        this.createDirs(fs, path1, path2, path3);
        this.createFile(path1.toString() + "/" + "pig" + "/" + "pig.jar");
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("pig").get(0)).getName().endsWith("pig.jar"));
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShareLibLoadFile() throws Exception {
        this.services = new Services();
        FileSystem fs = this.getFileSystem();
        this.setSystemProps();
        this.createTestShareLibMetaFile(fs);
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.service.ShareLibService.mapping.file", fs.getUri() + "/user/test/config.properties");
        conf.set("oozie.action.ship.launcher.jar", "true");
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("something_new").get(0)).getName().endsWith("somethingNew.jar"));
            TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("pig").get(0)).getName().endsWith("pig.jar"));
            TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("directjar").get(0)).getName().endsWith("direct.jar"));
            if (HadoopShims.isSymlinkSupported()) {
                TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("linkFile").get(0)).getName().endsWith("targetOfLinkFile.xml"));
            }
            List listOfPaths = shareLibService.getShareLibJars("directjar");
            for (Path p : listOfPaths) {
                TestShareLibService.assertTrue((boolean)p.toString().startsWith("hdfs"));
            }
            fs.delete(new Path("shareLibPath/"), true);
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadfromDFS() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        try {
            this.services.init();
            FileSystem fs = this.getFileSystem();
            Date time = new Date(System.currentTimeMillis());
            Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
            Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
            fs.mkdirs(libpath);
            Path pigPath = new Path(libpath.toString() + "/" + "pig");
            Path ooziePath = new Path(libpath.toString() + "/" + "oozie");
            Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
            Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
            fs.mkdirs(pigPath);
            fs.mkdirs(ooziePath);
            fs.mkdirs(pigPath1);
            fs.mkdirs(pigPath2);
            this.createFile(libpath.toString() + "/" + "pig_10" + "/" + "pig-10.jar");
            this.createFile(libpath.toString() + "/" + "oozie" + "/" + "oozie_luncher.jar");
            String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><property><name>oozie.action.sharelib.for.pig</name><value>pig_10</value></property></pig>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            protoConf.setBoolean("oozie.use.system.libpath", true);
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            PigActionExecutor ae = new PigActionExecutor();
            JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.pig", "pig_10");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), "pig-10.jar", "oozie_luncher.jar");
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShareLibLoadFileMultipleFile() throws Exception {
        FileSystem fs = this.getFileSystem();
        this.services = new Services();
        this.createTestShareLibMetaFile_multipleFile(fs);
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.service.ShareLibService.mapping.file", fs.getUri() + "/user/test/config.properties");
        conf.set("oozie.action.ship.launcher.jar", "true");
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            TestShareLibService.assertNull((Object)shareLibService.getShareLibJars("something_new"));
            TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("pig").size(), (int)2);
            fs.delete(new Path("shareLibPath/"), true);
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleLauncherCall() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        try {
            FileSystem fs = this.getFileSystem();
            Date time = new Date(System.currentTimeMillis());
            Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
            Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
            fs.mkdirs(libpath);
            Path ooziePath = new Path(libpath.toString() + "/" + "oozie");
            fs.mkdirs(ooziePath);
            this.createFile(libpath.toString() + "/" + "oozie" + "/" + "oozie_luncher.jar");
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            List launcherPath = shareLibService.getSystemLibJars("oozie");
            TestShareLibService.assertEquals((int)launcherPath.size(), (int)2);
            launcherPath = shareLibService.getSystemLibJars("oozie");
            TestShareLibService.assertEquals((int)launcherPath.size(), (int)2);
        }
        finally {
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetafileSymlink() throws ServiceException, IOException {
        if (!HadoopShims.isSymlinkSupported()) {
            return;
        }
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        this.services.init();
        FileSystem fs = this.getFileSystem();
        Properties prop = new Properties();
        try {
            String testPath = "shareLibPath/";
            Path basePath = new Path(testPath + "/" + "testPath");
            Path basePath1 = new Path(testPath + "/" + "testPath1");
            Path hive_site = new Path(basePath.toString() + "/" + "hive_conf" + "/" + "hive-site.xml");
            Path hive_site1 = new Path(basePath.toString() + "/" + "hive_conf" + "/" + "hive-site1.xml");
            Path symlink = new Path("symlink/");
            Path symlink_hive_site = new Path("symlink/hive_conf/hive-site.xml");
            fs.mkdirs(basePath);
            this.createFile(basePath.toString() + "/" + "pig" + "/" + "pig.jar");
            this.createFile(basePath.toString() + "/" + "pig" + "/" + "pig_1.jar");
            this.createFile(basePath1.toString() + "/" + "pig" + "/" + "pig_2.jar");
            this.createFile(basePath1.toString() + "/" + "pig" + "/" + "pig_3.jar");
            this.createFile(basePath1.toString() + "/" + "pig" + "/" + "pig_4.jar");
            this.createFile(hive_site.toString());
            HadoopShims fileSystem = new HadoopShims(fs);
            fileSystem.createSymlink(basePath, symlink, true);
            fileSystem.createSymlink(hive_site, symlink_hive_site, true);
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".pig", "/user/test/" + symlink.toString());
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".hive_conf", "/user/test/" + symlink_hive_site.toString() + "#hive-site.xml");
            this.createTestShareLibMetaFile(fs, prop);
            TestShareLibService.assertEquals((boolean)fileSystem.isSymlink(symlink), (boolean)true);
            conf.set("oozie.service.ShareLibService.mapping.file", fs.getUri() + "/user/test/config.properties");
            conf.set("oozie.action.ship.launcher.jar", "true");
            try {
                ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
                TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("pig").size(), (int)2);
                TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("hive_conf").size(), (int)1);
                new HadoopShims(fs).createSymlink(basePath1, symlink, true);
                new HadoopShims(fs).createSymlink(hive_site1, symlink_hive_site, true);
                TestShareLibService.assertEquals((Object)new HadoopShims(fs).getSymLinkTarget((Path)shareLibService.getShareLibJars("hive_conf").get(0)), (Object)hive_site1);
                TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("pig").size(), (int)3);
            }
            finally {
                fs.delete(new Path("shareLibPath/"), true);
                fs.delete(new Path("/user/test/config.properties"), true);
                fs.delete(new Path("/user/test/config.properties"), true);
                fs.delete(symlink, true);
                this.services.destroy();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateJarsInDistributedCache() throws Exception {
        this.services = new Services();
        this.setSystemProps();
        FileSystem fs = this.getFileSystem();
        Path basePath = new Path(((ConfigurationService)this.services.get(ConfigurationService.class)).getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        Date time = new Date(System.currentTimeMillis());
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        this.createDirs(fs, pigPath, new Path(pigPath, "temp"));
        this.createFile(new Path(pigPath, "pig.jar"));
        this.createFile(new Path(pigPath, "hive.jar"));
        this.createFile(new Path(new Path(pigPath, "temp"), "pig.jar#pig.jar"));
        try {
            this.verifyFilesInDistributedCache(this.setUpPigJob(true), "pig.jar", "hive.jar", "MyOozie.jar", "MyPig.jar");
            ShareLibService shareLibService = (ShareLibService)this.services.get(ShareLibService.class);
            List shareLib = shareLibService.getShareLibJars("pig");
            TestShareLibService.assertEquals((int)shareLib.size(), (int)3);
            TestShareLibService.assertTrue((boolean)shareLib.toString().contains("pig.jar#pig.jar"));
            TestShareLibService.assertTrue((boolean)shareLib.toString().contains("hive.jar"));
        }
        finally {
            this.services.destroy();
        }
    }

    private URI[] setUpPigJob(boolean useSystemSharelib) throws Exception {
        this.services.init();
        String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node></pig>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShareLibService.getTestUser());
        WorkflowJobBean wfj = new WorkflowJobBean();
        protoConf.setBoolean("oozie.use.system.libpath", useSystemSharelib);
        wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
        ((Object)((Object)testJavaActionExecutor)).getClass();
        ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
        PigActionExecutor ae = new PigActionExecutor();
        JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        jobConf.set("oozie.action.sharelib.for.pig", "pig");
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
        return DistributedCache.getCacheFiles((Configuration)jobConf);
    }

    private void createFile(String ... filenames) throws IOException {
        for (String filename : filenames) {
            Path path = new Path(filename);
            this.createFile(path);
        }
    }

    private void createFile(Path ... paths) throws IOException {
        for (Path path : paths) {
            FSDataOutputStream out = this.getFileSystem().create(path);
            out.close();
        }
    }

    private void createTestShareLibMetaFile(FileSystem fs) {
        Properties prop = new Properties();
        try {
            String testPath = "shareLibPath/";
            String symlink = "/user/test/linkFile.xml";
            Path basePath = new Path(testPath + "/" + "testPath");
            Path somethingNew = new Path(testPath + "/" + "something_new");
            Path directJarDir = new Path(testPath + "/" + "directJarDir");
            Path linkDir = new Path(testPath + "/" + "linkDir");
            fs.mkdirs(basePath);
            fs.mkdirs(somethingNew);
            fs.mkdirs(directJarDir);
            fs.mkdirs(linkDir);
            this.createFile(basePath.toString() + "/" + "pig" + "/" + "pig.jar");
            this.createFile(somethingNew.toString() + "/" + "somethingNew" + "/" + "somethingNew.jar");
            String directJarPath = directJarDir.toString() + "/" + "direct.jar";
            String symlinkTarget = linkDir.toString() + "/" + "targetOfLinkFile.xml";
            this.createFile(directJarPath);
            this.createFile(symlinkTarget);
            HadoopShims fsShim = new HadoopShims(fs);
            fsShim.createSymlink(new Path(symlinkTarget), new Path(symlink), true);
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".pig", "/user/test/" + basePath.toString());
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".something_new", "/user/test/" + somethingNew.toString());
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".directjar", "/user/test/" + directJarPath.toString());
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".linkFile", symlink + "#targetOfLinkFile.xml");
            this.createTestShareLibMetaFile(fs, prop);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createTestShareLibMetaFile(FileSystem fs, Properties prop) {
        try {
            FSDataOutputStream out = fs.create(new Path("/user/test/config.properties"));
            prop.store((OutputStream)out, null);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void createTestShareLibMetaFile_multipleFile(FileSystem fs) {
        Properties prop = new Properties();
        try {
            String testPath = "shareLibPath/";
            Path basePath = new Path(testPath + "/" + "testPath");
            Path somethingNew = new Path(testPath + "/" + "something_new");
            fs.mkdirs(basePath);
            fs.mkdirs(somethingNew);
            this.createFile(basePath.toString() + "/" + "pig" + "/" + "pig.jar");
            this.createFile(somethingNew.toString() + "/" + "somethingNew" + "/" + "somethingNew.jar");
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".pig", "/user/test/" + basePath.toString() + "/" + "pig" + "/" + "pig.jar,/user/test/" + somethingNew.toString() + "/" + "somethingNew" + "/" + "somethingNew.jar");
            FSDataOutputStream out = fs.create(new Path("/user/test/config.properties"));
            prop.store((OutputStream)out, null);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createDirs(FileSystem fs, Path ... paths) throws IOException {
        for (Path path : paths) {
            fs.mkdirs(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfFileAddedToActionConf() throws Exception {
        try {
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            protoConf.setBoolean("oozie.use.system.libpath", true);
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf");
            ShareLibService shareLibService = (ShareLibService)this.services.get(ShareLibService.class);
            TestShareLibService.assertEquals((int)((Map)shareLibService.getShareLibConfigMap().get("hive_conf")).values().size(), (int)1);
            TestShareLibService.assertEquals((String)((Map)shareLibService.getShareLibConfigMap().get("hive_conf")).keySet().toArray(new Path[0])[0].getName(), (String)"hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf");
            String actionXml = "<hive><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><script>test</script></hive>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            HiveActionExecutor ae = new HiveActionExecutor();
            JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            JobConf actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            Object[] cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            String cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            Properties prop = new Properties();
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "/user/test/sharelib/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            prop = new Properties();
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "hdfs:///user/test/sharelib/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
            prop = new Properties();
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "/user/test/sharelib/hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
            prop = new Properties();
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "/user/test/sharelib/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
        }
        finally {
            this.getFileSystem().delete(new Path("sharelib"), true);
            this.services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfFileAddedToDistributedCache() throws Exception {
        try {
            Properties prop = new Properties();
            prop.put("oozie.hive_conf", "/user/test/sharelib/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><script>test</script></pig>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            protoConf.setBoolean("oozie.use.system.libpath", true);
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            PigActionExecutor ae = new PigActionExecutor();
            JobConf jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.pig", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            Object[] cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
            String cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), null);
            TestShareLibService.assertTrue((boolean)URLDecoder.decode(cacheFilesStr).contains("hive-site.xml#hive-site.xml"));
            this.setupSharelibConf("hbase-site.xml", "oozie.hbase_conf");
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.pig", "hbase_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), (Configuration)jobConf);
            cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertTrue((boolean)cacheFilesStr.contains("hbase-site.xml"));
        }
        finally {
            this.getFileSystem().delete(new Path("sharelib"), true);
            this.services.destroy();
        }
    }

    private void setupSharelibConf(String file, String tag) throws ServiceException, IOException {
        Properties prop = new Properties();
        prop.put(tag, "/user/test/sharelib");
        this.setupSharelibConf(file, tag, prop);
    }

    private void setupSharelibConf(String file, String tag, Properties prop) throws IOException, ServiceException {
        this.services = new Services();
        this.setSystemProps();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.action.ship.launcher.jar", "true");
        conf.set("oozie.service.ShareLibService.mapping.file", this.getFileSystem().getUri() + "/user/test/config.properties");
        XConfiguration hiveConf = new XConfiguration();
        hiveConf.set(tag + "-sharelib-test", "test");
        this.createDirs(this.getFileSystem(), new Path("sharelib"));
        FSDataOutputStream out = this.getFileSystem().create(new Path("sharelib", file));
        PrintWriter bufOut = new PrintWriter((OutputStream)out);
        bufOut.write(hiveConf.toXmlString(false));
        bufOut.close();
        this.createTestShareLibMetaFile(this.getFileSystem(), prop);
        this.services.init();
    }

    private void verifyFilesInDistributedCache(URI[] cacheFiles, String ... files) {
        String cacheFilesStr = Arrays.toString(cacheFiles);
        new HadoopShims(this.getFileSystem());
        if (HadoopShims.isYARN()) {
            TestShareLibService.assertEquals((int)cacheFiles.length, (int)(files.length + 2));
            TestShareLibService.assertTrue((boolean)cacheFilesStr.contains("MRAppJar.jar"));
            TestShareLibService.assertTrue((boolean)cacheFilesStr.contains("hadoop-mapreduce-client-jobclient-"));
        } else {
            TestShareLibService.assertEquals((int)cacheFiles.length, (int)files.length);
        }
        for (String file : files) {
            TestShareLibService.assertTrue((boolean)cacheFilesStr.contains(file));
        }
    }

    static class TestHive {
        TestHive() {
        }
    }

    static class MyPig {
        MyPig() {
        }
    }

    static class MyOozie {
        MyOozie() {
        }
    }

    public static class DummyHiveActionExecutor
    extends HiveActionExecutor {
        public List<Class> getLauncherClasses() {
            return Arrays.asList(TestHive.class);
        }
    }

    public static class DummyPigActionExecutor
    extends PigActionExecutor {
        public List<Class> getLauncherClasses() {
            return Arrays.asList(MyPig.class);
        }
    }

    public static class DummyShareLibService
    extends ShareLibService {
        public String findContainingJar(Class clazz) {
            if (JavaActionExecutor.getCommonLauncherClasses().contains(clazz)) {
                return testCaseDirPath + "/" + MyOozie.class.getName() + ".jar";
            }
            return testCaseDirPath + "/" + clazz.getName() + ".jar";
        }
    }
}

