/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.SparkConfigurationService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;

public class TestSparkConfigurationService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testSparkConfigsEmpty() throws Exception {
        SparkConfigurationService scs = (SparkConfigurationService)Services.get().get(SparkConfigurationService.class);
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)"");
        scs.init(Services.get());
        Map sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((int)0, (int)sparkConfigs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSparkConfigs() throws Exception {
        File sparkConf1Dir = new File(this.getTestCaseConfDir(), "spark-conf-1");
        File sparkConf3Dir = new File(this.getTestCaseConfDir(), "spark-conf-3");
        File sparkConf4Dir = new File(this.getTestCaseConfDir(), "spark-conf-4");
        sparkConf1Dir.mkdirs();
        sparkConf3Dir.mkdirs();
        sparkConf4Dir.mkdirs();
        File sparkConf1 = new File(sparkConf1Dir, "spark-defaults.conf");
        Properties sparkConf1Props = new Properties();
        sparkConf1Props.setProperty("a", "A");
        sparkConf1Props.setProperty("b", "B");
        sparkConf1Props.setProperty("spark.yarn.jar", "foo");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(sparkConf1);
            sparkConf1Props.store(fos, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeSafely((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        IOUtils.closeSafely((Closeable[])new Closeable[]{fos});
        File sparkConf4 = new File(sparkConf4Dir, "spark-defaults.conf");
        Properties sparkConf4Props = new Properties();
        sparkConf4Props.setProperty("y", "Y");
        sparkConf4Props.setProperty("z", "Z");
        fos = null;
        try {
            fos = new FileOutputStream(sparkConf4);
            sparkConf4Props.store(fos, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeSafely((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        IOUtils.closeSafely((Closeable[])new Closeable[]{fos});
        SparkConfigurationService scs = (SparkConfigurationService)Services.get().get(SparkConfigurationService.class);
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)("rm1=" + sparkConf1Dir.getAbsolutePath() + ",rm2,rm3=" + sparkConf3Dir.getAbsolutePath() + ",rm4=" + sparkConf4Dir.getName()));
        scs.init(Services.get());
        Map sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((String)"A", (String)((String)sparkConfigs.get("a")));
        TestSparkConfigurationService.assertEquals((String)"B", (String)((String)sparkConfigs.get("b")));
        sparkConfigs = scs.getSparkConfig("rm2");
        TestSparkConfigurationService.assertEquals((int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm3");
        TestSparkConfigurationService.assertEquals((int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm4");
        TestSparkConfigurationService.assertEquals((int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((String)"Y", (String)((String)sparkConfigs.get("y")));
        TestSparkConfigurationService.assertEquals((String)"Z", (String)((String)sparkConfigs.get("z")));
        scs.destroy();
        ConfigurationService.setBoolean((String)"oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jar", (boolean)false);
        scs.init(Services.get());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((int)3, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((String)"A", (String)((String)sparkConfigs.get("a")));
        TestSparkConfigurationService.assertEquals((String)"B", (String)((String)sparkConfigs.get("b")));
        TestSparkConfigurationService.assertEquals((String)"foo", (String)((String)sparkConfigs.get("spark.yarn.jar")));
        ConfigurationService.setBoolean((String)"oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jar", (boolean)true);
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)("rm1=" + sparkConf1Dir.getAbsolutePath() + ",*=" + sparkConf4Dir.getAbsolutePath()));
        scs.init(Services.get());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((String)"A", (String)((String)sparkConfigs.get("a")));
        TestSparkConfigurationService.assertEquals((String)"B", (String)((String)sparkConfigs.get("b")));
        sparkConfigs = scs.getSparkConfig("rm2");
        TestSparkConfigurationService.assertEquals((int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((String)"Y", (String)((String)sparkConfigs.get("y")));
        TestSparkConfigurationService.assertEquals((String)"Z", (String)((String)sparkConfigs.get("z")));
        sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((String)"Y", (String)((String)sparkConfigs.get("y")));
        TestSparkConfigurationService.assertEquals((String)"Z", (String)((String)sparkConfigs.get("z")));
    }
}

