/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogAuditFilter;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogUserFilterParam;

public class TestXLogStreamingService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void setupXLog() throws CommandException {
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
    }

    public void testDisableLogOverWS() throws Exception {
        Properties props = new Properties();
        props.setProperty("log4j.appender.oozie.File", "");
        File propsFile = new File(this.getTestCaseConfDir(), "test-disable-log-over-ws-log4j.properties");
        FileOutputStream fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        this.setSystemProperty("oozie.log4j.file", propsFile.getName());
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.File", "oozie.log");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.File", "${oozie.log.dir}/oozie.log");
        props.setProperty("log4j.appender.oozie", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie", "org.blah.blah");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie", "org.apache.log4j.DailyRollingFileAppender");
        props.setProperty("log4j.appender.oozie.DatePattern", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.DatePattern", "'.'yyyy-MM");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.DatePattern", "'.'yyyy-MM-dd");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.DatePattern", "'.'yyyy-MM-dd-HH");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie", "org.apache.log4j.rolling.RollingFileAppender");
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie.log-blah");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/blah.log-%d{yyyy-MM-dd-HH}");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie.log-%d{yyyy-MM-dd-HH}");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie.log-%d{yyyy-MM-dd-HH}.gz");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheckWithServices());
    }

    public void testDisableErrorLogOverWS() throws Exception {
        Properties props = new Properties();
        props.setProperty("log4j.appender.oozieError.File", "");
        File propsFile = new File(this.getTestCaseConfDir(), "test-disable-log-over-ws-log4j.properties");
        FileOutputStream fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        this.setSystemProperty("oozie.log4j.file", propsFile.getName());
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.File", "oozie-error.log");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.File", "${oozie.log.dir}/oozie-error.log");
        props.setProperty("log4j.appender.oozieError", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError", "org.blah.blah");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError", "org.apache.log4j.DailyRollingFileAppender");
        props.setProperty("log4j.appender.oozieError.DatePattern", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.DatePattern", "'.'yyyy-MM");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.DatePattern", "'.'yyyy-MM-dd");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.DatePattern", "'.'yyyy-MM-dd-HH");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError", "org.apache.log4j.rolling.RollingFileAppender");
        props.setProperty("log4j.appender.oozieError.RollingPolicy.FileNamePattern", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie-error.log-blah");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.RollingPolicy.FileNamePattern", "${oozie.log.dir}/blah.log-%d{yyyy-MM-dd-HH}");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertTrue((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie-error.log-%d{yyyy-MM-dd-HH}");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doerrorStreamDisabledCheckWithServices());
        props.setProperty("log4j.appender.oozieError.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie-error.log-%d{yyyy-MM-dd-HH}.gz");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestXLogStreamingService.assertFalse((boolean)this.doerrorStreamDisabledCheckWithServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoDashInConversionPattern() throws Exception {
        this.setupXLog();
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(null));
        xf.setParameter("USER", "oozie");
        xf.setLogLevel("DEBUG|INFO");
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        try {
            new Services().init();
            TestXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L1_:317 - SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L2_:317 - SERVER[foo] USER[blah] GROUP[oozie] TOKEN[-]APP[-] JOB[-] ACTION[-] Released Lock");
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L3_:317 SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L4_:317 SERVER[foo] USER[blah] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
            String out = this.doStreamLog(xf);
            String[] outArr = out.split("\n");
            TestXLogStreamingService.assertEquals((int)2, (int)outArr.length);
            TestXLogStreamingService.assertTrue((boolean)outArr[0].contains("_L1_"));
            TestXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
            TestXLogStreamingService.assertTrue((boolean)outArr[1].contains("_L3_"));
            TestXLogStreamingService.assertFalse((boolean)out.contains("_L4_"));
        }
        finally {
            Services.get().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorLog() throws Exception {
        this.setupXLog();
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(null));
        xf.setParameter("USER", "oozie");
        xf.setLogLevel("DEBUG|INFO");
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.setProperty("log4j.appender.oozieError.File", this.getTestCaseDir() + "/oozie-error.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        try {
            new Services().init();
            TestXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L1_:317 - SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
            LogFactory.getLog((String)"a").warn((Object)"2009-06-24 02:44:14,505 WARN _L2_:317 - SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Error while writing to file");
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:45:14,505 INFO _L3_:317 - SERVER[foo] USER[blah] GROUP[oozie] TOKEN[-]APP[-] JOB[-] ACTION[-] Released Lock");
            LogFactory.getLog((String)"a").error((Object)"2009-06-24 02:46:14,505 ERROR _L4_:317 - SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Error while writing to DB");
            LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:47:14,505 INFO _L5_:317 SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
            LogFactory.getLog((String)"a").fatal((Object)"2009-06-24 02:48:14,505 FATAL _L6_:317 SERVER[foo] USER[blah] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
            String out = this.doStreamLog(xf);
            String[] outArr = out.split("\n");
            TestXLogStreamingService.assertEquals((int)2, (int)outArr.length);
            TestXLogStreamingService.assertTrue((boolean)outArr[0].contains("_L1_"));
            TestXLogStreamingService.assertFalse((boolean)out.contains("_L3_"));
            TestXLogStreamingService.assertTrue((boolean)outArr[1].contains("_L5_"));
            TestXLogStreamingService.assertFalse((boolean)out.contains("_L4_"));
            XLogFilter.reset();
            XLogFilter.defineParameter((String)"USER");
            XLogFilter.defineParameter((String)"GROUP");
            XLogFilter.defineParameter((String)"TOKEN");
            XLogFilter.defineParameter((String)"APP");
            XLogFilter.defineParameter((String)"JOB");
            XLogFilter.defineParameter((String)"ACTION");
            xf = new XLogFilter(new XLogUserFilterParam(null));
            xf.setParameter("USER", "oozie");
            String errorOut = this.doStreamErrorLog(xf);
            String[] errorOutArr = errorOut.split("\n");
            TestXLogStreamingService.assertEquals((int)2, (int)errorOutArr.length);
            TestXLogStreamingService.assertTrue((boolean)errorOutArr[0].contains("_L2_"));
            TestXLogStreamingService.assertTrue((boolean)errorOutArr[1].contains("_L4_"));
            TestXLogStreamingService.assertFalse((boolean)errorOut.contains("_L6_"));
        }
        finally {
            Services.get().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuditLog() throws Exception {
        this.setupXLog();
        XLogAuditFilter xf = new XLogAuditFilter(new XLogUserFilterParam(null));
        xf.setParameter("USER", "oozie");
        xf.setLogLevel("DEBUG|INFO");
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.setProperty("log4j.appender.oozieaudit.File", this.getTestCaseDir() + "/oozie-audit.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        try {
            new Services().init();
            XLog auditLog = XLog.getLog((String)"oozieaudit");
            xf.setParameter("JOB", "0000000-150322000230582-oozie-puru-C");
            auditLog.info((Object)"2015-03-22 00:04:35,494  INFO oozieaudit:520 - IP [127.0.0.1], USER [purushah], GROUP [null], APP [-], JOBID [0000000-150322000230582-oozie-puru-C], OPERATION [start], PARAMETER [null], STATUS [SUCCESS], HTTPCODE [200], ERRORCODE [null], ERRORMESSAGE [L1]");
            auditLog.info((Object)"2015-03-22 00:05:13,823  INFO oozieaudit:520 - IP [127.0.0.1], USER [purushah], GROUP [null], APP [-], JOBID [0000000-150322000230582-oozie-puru-C], OPERATION [suspend], PARAMETER [0000000-150322000230582-oozie-puru-C], STATUS [SUCCESS], HTTPCODE [200], ERRORCODE [null], ERRORMESSAGE [L2]");
            auditLog.info((Object)"2015-03-22 00:05:13,823  INFO oozieaudit:520 - IP [127.0.0.1], USER [purushah], GROUP [null], APP [-], JOBID [0000001-150322000230582-oozie-puru-C], OPERATION [suspend], PARAMETER [0000001-150322000230582-oozie-puru-C], STATUS [SUCCESS], HTTPCODE [200], ERRORCODE [null], ERRORMESSAGE [L3]");
            String out = this.doStreamAuditLog((XLogFilter)xf);
            String[] outArr = out.split("\n");
            TestXLogStreamingService.assertEquals((int)2, (int)outArr.length);
            TestXLogStreamingService.assertTrue((boolean)outArr[0].contains("L1"));
            TestXLogStreamingService.assertTrue((boolean)out.contains("L2"));
            TestXLogStreamingService.assertFalse((boolean)out.contains("L3"));
        }
        finally {
            Services.get().destroy();
        }
    }

    private boolean doStreamDisabledCheckWithServices() throws Exception {
        boolean result = false;
        try {
            new Services().init();
            result = this.doStreamDisabledCheck();
        }
        finally {
            Services.get().destroy();
        }
        return result;
    }

    private boolean doStreamDisabledCheck() throws Exception {
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(null));
        return this.doStreamLog(xf).equals("Log streaming disabled!!");
    }

    private String doStreamLog(XLogFilter xf) throws Exception {
        StringWriter w = new StringWriter();
        ((XLogStreamingService)Services.get().get(XLogStreamingService.class)).streamLog(xf, null, null, (Writer)w, new HashMap());
        return w.toString();
    }

    private String doStreamErrorLog(XLogFilter xf) throws Exception {
        StringWriter w = new StringWriter();
        ((XLogStreamingService)Services.get().get(XLogStreamingService.class)).streamErrorLog(xf, null, null, (Writer)w, new HashMap());
        return w.toString();
    }

    private String doStreamAuditLog(XLogFilter xf) throws Exception {
        StringWriter w = new StringWriter();
        ((XLogStreamingService)Services.get().get(XLogStreamingService.class)).streamAuditLog(xf, null, null, (Writer)w, new HashMap());
        return w.toString();
    }

    private boolean doErrorStreamDisabledCheck() throws Exception {
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(null));
        return this.doStreamErrorLog(xf).equals("Error Log is disabled!!");
    }

    private boolean doerrorStreamDisabledCheckWithServices() throws Exception {
        boolean result = false;
        try {
            new Services().init();
            result = this.doErrorStreamDisabledCheck();
        }
        finally {
            Services.get().destroy();
        }
        return result;
    }
}

