/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.util.DateUtils;

public class MockCoordinatorEngineService
extends CoordinatorEngineService {
    public static final String JOB_ID = "coord-job-C-";
    public static final String ACTION_ID = "coord-action-C@-";
    public static final String COORD_APP = "<coordinator-app></coordinator-app>";
    public static final String CONFIGURATION = "<configuration></configuration>";
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String LOG = "log";
    public static final String JOB_ID_END = "-C";
    public static String did = null;
    public static Integer offset = null;
    public static Integer length = null;
    public static String order = null;
    public static String filter = null;
    public static List<CoordinatorJob> coordJobs;
    public static List<Boolean> started;
    public static final int INIT_COORD_COUNT = 4;

    public static void reset() {
        did = null;
        offset = null;
        length = null;
        order = null;
        filter = null;
        coordJobs = new ArrayList<CoordinatorJob>();
        started = new ArrayList<Boolean>();
        for (int i = 0; i < 4; ++i) {
            coordJobs.add(MockCoordinatorEngineService.createDummyCoordinatorJob(i));
            started.add(false);
        }
    }

    public CoordinatorEngine getCoordinatorEngine(String user) {
        return new MockCoordinatorEngine(user);
    }

    public CoordinatorEngine getSystemCoordinatorEngine() {
        return new MockCoordinatorEngine();
    }

    private static CoordinatorJob createDummyCoordinatorJob(int idx) {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(JOB_ID + idx);
        coordJob.setAppName("testApp");
        coordJob.setAppPath("testAppPath");
        coordJob.setStatus(Job.Status.RUNNING);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(USER);
        coordJob.setGroup(GROUP);
        coordJob.setConf(CONFIGURATION);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        try {
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-02-03T23:59Z"));
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<CoordinatorActionBean> actions = new ArrayList<CoordinatorActionBean>();
        for (int i = 0; i < idx; ++i) {
            actions.add(MockCoordinatorEngineService.createDummyAction(i, JOB_ID + idx));
        }
        coordJob.setActions(actions);
        return coordJob;
    }

    private static CoordinatorJob createDummyCoordinatorJob(int idx, Configuration conf) {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(JOB_ID + idx);
        coordJob.setAppName("testApp");
        coordJob.setAppPath("testAppPath");
        coordJob.setStatus(Job.Status.RUNNING);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(USER);
        coordJob.setGroup(GROUP);
        coordJob.setConf(conf.toString());
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        try {
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-02-03T23:59Z"));
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<CoordinatorActionBean> actions = new ArrayList<CoordinatorActionBean>();
        for (int i = 0; i < idx; ++i) {
            actions.add(MockCoordinatorEngineService.createDummyAction(i, JOB_ID + idx));
        }
        coordJob.setActions(actions);
        return coordJob;
    }

    private static CoordinatorActionBean createDummyAction(int idx, String jobId) {
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setId(ACTION_ID + idx);
        action.setJobId(jobId);
        action.setActionNumber(idx);
        action.setNominalTime(new Date());
        action.setLastModifiedTime(new Date());
        action.setStatus(CoordinatorAction.Status.SUBMITTED);
        action.setActionXml(COORD_APP);
        action.setCreatedConf(CONFIGURATION);
        return action;
    }

    static {
        MockCoordinatorEngineService.reset();
    }

    private static class MockCoordinatorEngine
    extends CoordinatorEngine {
        public MockCoordinatorEngine() {
        }

        public MockCoordinatorEngine(String user) {
            super(user);
        }

        public String submitJob(Configuration conf, boolean startJob) throws CoordinatorEngineException {
            did = "submit";
            int idx = coordJobs.size();
            coordJobs.add(MockCoordinatorEngineService.createDummyCoordinatorJob(idx, conf));
            started.add(startJob);
            return MockCoordinatorEngineService.JOB_ID + idx;
        }

        public String dryRunSubmit(Configuration conf) throws CoordinatorEngineException {
            did = "dryrun";
            int idx = coordJobs.size();
            coordJobs.add(MockCoordinatorEngineService.createDummyCoordinatorJob(idx, conf));
            started.add(false);
            return MockCoordinatorEngineService.JOB_ID + idx;
        }

        public void resume(String jobId) throws CoordinatorEngineException {
            did = "resume";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, true);
        }

        public void suspend(String jobId) throws CoordinatorEngineException {
            did = "suspend";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, false);
        }

        public void kill(String jobId) throws CoordinatorEngineException {
            did = "kill";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, false);
        }

        public CoordinatorActionInfo killActions(String jobId, String rangeType, String scope) throws CoordinatorEngineException {
            did = "kill";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, false);
            List actions = coordJobs.get(idx).getActions();
            ArrayList<CoordinatorActionBean> actionBeans = new ArrayList<CoordinatorActionBean>();
            for (CoordinatorAction action : actions) {
                actionBeans.add((CoordinatorActionBean)action);
            }
            return new CoordinatorActionInfo(actionBeans);
        }

        public void change(String jobId, String changeValue) throws CoordinatorEngineException {
            did = "change";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, true);
        }

        public void reRun(String jobId, Configuration conf) throws BaseEngineException {
            throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[]{"invalid use of rerun"}));
        }

        public CoordinatorActionInfo ignore(String jobId, String type, String scope) throws CoordinatorEngineException {
            did = "ignore";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, true);
            return null;
        }

        public CoordinatorActionInfo reRun(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed, Configuration conf) throws BaseEngineException {
            did = "coord-rerun";
            int idx = this.validateCoordinatorIdx(jobId);
            started.set(idx, true);
            List actions = coordJobs.get(idx).getActions();
            ArrayList<CoordinatorActionBean> actionBeans = new ArrayList<CoordinatorActionBean>();
            for (CoordinatorAction action : actions) {
                actionBeans.add((CoordinatorActionBean)action);
            }
            return new CoordinatorActionInfo(actionBeans);
        }

        public CoordinatorJobBean getCoordJob(String jobId) throws BaseEngineException {
            did = "info";
            int idx = this.validateCoordinatorIdx(jobId);
            return (CoordinatorJobBean)coordJobs.get(idx);
        }

        public CoordinatorJobBean getCoordJob(String jobId, String filter, int start, int length, boolean desc) throws BaseEngineException {
            did = "info";
            offset = start;
            MockCoordinatorEngineService.length = length;
            order = desc ? "desc" : "asc";
            MockCoordinatorEngineService.filter = filter;
            int idx = this.validateCoordinatorIdx(jobId);
            return (CoordinatorJobBean)coordJobs.get(idx);
        }

        public String getJobStatus(String jobId) throws CoordinatorEngineException {
            did = "status";
            int idx = this.validateCoordinatorIdx(jobId);
            return coordJobs.get(idx).getStatus().toString();
        }

        public String getDefinition(String jobId) throws BaseEngineException {
            did = "definition";
            this.validateCoordinatorIdx(jobId);
            return MockCoordinatorEngineService.COORD_APP;
        }

        public void streamLog(String jobId, Writer writer, Map<String, String[]> params) throws IOException, BaseEngineException {
            did = MockCoordinatorEngineService.LOG;
            this.validateCoordinatorIdx(jobId);
            writer.write(MockCoordinatorEngineService.LOG);
        }

        public void streamLog(String jobId, String logRetrievalScope, String logRetrievalType, Writer writer, Map<String, String[]> params) throws IOException, BaseEngineException {
            did = MockCoordinatorEngineService.LOG;
            this.validateCoordinatorIdx(jobId);
            writer.write(MockCoordinatorEngineService.LOG);
        }

        public String updateJob(Configuration conf, String jobId, boolean dryrun, boolean showDiff) throws CoordinatorEngineException {
            did = dryrun ? "update&dryrun" : "update";
            this.validateCoordinatorIdx(jobId);
            return "";
        }

        public CoordinatorJobInfo suspendJobs(String filter, int start, int length) throws CoordinatorEngineException {
            did = "jobs";
            return new CoordinatorJobInfo(new ArrayList(), 0, 0, 0);
        }

        public CoordinatorJobInfo resumeJobs(String filter, int start, int length) throws CoordinatorEngineException {
            did = "jobs";
            return new CoordinatorJobInfo(new ArrayList(), 0, 0, 0);
        }

        public CoordinatorJobInfo killJobs(String filter, int start, int length) throws CoordinatorEngineException {
            did = "jobs";
            return new CoordinatorJobInfo(new ArrayList(), 0, 0, 0);
        }

        public void disableSLAAlert(String id, String actions, String dates, String childIds) throws BaseEngineException {
            did = "sla-disable";
        }

        public void changeSLA(String id, String actions, String dates, String childIds, String newParams) throws BaseEngineException {
            did = "sla-change";
        }

        public void enableSLAAlert(String id, String actions, String dates, String childIds) throws BaseEngineException {
            did = "sla-enable";
        }

        private int validateCoordinatorIdx(String jobId) throws CoordinatorEngineException {
            int idx = -1;
            try {
                if (jobId.endsWith(MockCoordinatorEngineService.JOB_ID_END)) {
                    jobId = jobId.replace(MockCoordinatorEngineService.JOB_ID, "");
                    jobId = jobId.replace(MockCoordinatorEngineService.JOB_ID_END, "");
                } else {
                    jobId = jobId.replace(MockCoordinatorEngineService.JOB_ID, "");
                }
                idx = Integer.parseInt(jobId);
            }
            catch (Exception e) {
                throw new CoordinatorEngineException(ErrorCode.ETEST, new Object[]{jobId});
            }
            if (idx >= coordJobs.size()) {
                throw new CoordinatorEngineException(ErrorCode.ETEST, new Object[]{jobId});
            }
            return idx;
        }
    }
}

