/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.oozie.servlet.CallbackServlet;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;

public class TestCallbackServlet
extends DagServletTestCase {
    public void testCallbackGet() throws Exception {
        this.runTest("/callback", CallbackServlet.class, true, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestCallbackServlet.this.createURL("", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", "error");
                params.put("status", "error");
                url = TestCallbackServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                params = new HashMap();
                params.put("id", "ok");
                params.put("status", "ok");
                url = TestCallbackServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testCallbackPost() throws Exception {
        this.runTest("/callback", CallbackServlet.class, true, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                URL url = TestCallbackServlet.this.createURL("", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", "error");
                params.put("status", "error");
                url = TestCallbackServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "text/plain");
                Properties props = new Properties();
                props.setProperty("a", "A");
                props.store(conn.getOutputStream(), "UTF-8");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("id", "ok");
                params.put("status", "ok");
                url = TestCallbackServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "text/plain");
                props = new Properties();
                props.setProperty("a", "A");
                props.store(conn.getOutputStream(), "UTF-8");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((Object)props, (Object)MockDagEngineService.properties);
                return null;
            }
        });
    }

    static {
        new CallbackServlet();
    }
}

