/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.MyJsonRestServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;

public class TestJsonRestServlet
extends XTestCase {
    EmbeddedServletContainer container;

    private int invoke(String method, String resource, String queryString) throws Exception {
        return this.invoke(method, resource, queryString, "dummy");
    }

    private int invoke(String method, String resource, String queryString, String contentType) throws Exception {
        String s = this.container.getServletURL("/dummy");
        if (resource != null) {
            s = s + resource;
        }
        if (queryString != null) {
            s = s + "?" + queryString;
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(s).openConnection();
        conn.setRequestProperty("content-type", contentType);
        conn.setRequestMethod(method);
        conn.connect();
        return conn.getResponseCode();
    }

    private String invokeAndGetResponse(String method, String resource, String queryString, String contentType) throws Exception {
        String s = this.container.getServletURL("/dummy");
        if (resource != null) {
            s = s + resource;
        }
        if (queryString != null) {
            s = s + "?" + queryString;
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(s).openConnection();
        conn.setRequestProperty("content-type", contentType);
        conn.setRequestMethod(method);
        conn.connect();
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            line = reader.readLine();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(JsonRestServlet.ResourceInfo[] resourceInfo, Callable<Void> assertions) throws Exception {
        this.container = new EmbeddedServletContainer("test");
        Services services = new Services();
        try {
            services.init();
            MyJsonRestServlet.ACTIVE = resourceInfo;
            this.container.addServletEndpoint("/dummy/*", MyJsonRestServlet.class);
            this.container.start();
            assertions.call();
        }
        finally {
            this.container.stop();
            services.destroy();
        }
    }

    public void testEmptyResources() {
        try {
            MyJsonRestServlet.ACTIVE = MyJsonRestServlet.EMPTY;
            new MyJsonRestServlet();
            TestJsonRestServlet.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoResourceNoParams() throws Exception {
        this.runTest(MyJsonRestServlet.NO_RESOURCE_NO_PARAMS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", null, null));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", null));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "a=A"));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/", null));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/hello", null));
                return null;
            }
        });
    }

    public void testParamsRequired() throws Exception {
        this.runTest(MyJsonRestServlet.PARAMS_REQUIRED, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "required=true"));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "required=true&optional=true"));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "optional=true"));
                return null;
            }
        });
    }

    public void testParamTypes() throws Exception {
        this.runTest(MyJsonRestServlet.PARAM_TYPES, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "boolean=true"));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "boolean=false"));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "boolean=x"));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "integer=1"));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "integer=x"));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "string=a"));
                return null;
            }
        });
    }

    public void testResourceGetPostParamGet() throws Exception {
        this.runTest(MyJsonRestServlet.RESOURCE_GET_POST_PARAM_GET, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "param=true"));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "", "param=true"));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "", ""));
                return null;
            }
        });
    }

    public void testFixedResource() throws Exception {
        this.runTest(MyJsonRestServlet.FIXED_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource", ""));
                return null;
            }
        });
    }

    public void testWildCardResource() throws Exception {
        this.runTest(MyJsonRestServlet.WILDCARD_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/any", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/any", ""));
                return null;
            }
        });
    }

    public void testInvalidResource() throws Exception {
        this.runTest(MyJsonRestServlet.WILDCARD_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/any/any", ""));
                return null;
            }
        });
    }

    public void testNoResourceWithParam() throws Exception {
        this.runTest(MyJsonRestServlet.WILDCARD_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("PUT", "/", "action=kill"));
                return null;
            }
        });
    }

    public void testMultipleResources() throws Exception {
        this.runTest(MyJsonRestServlet.MULTIPLE_RESOURCES, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource1", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource1", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/resource2", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "/resource2", ""));
                return null;
            }
        });
    }

    public void testMultipleResourcesNoResource() throws Exception {
        this.runTest(MyJsonRestServlet.MULTIPLE_RESOURCES_NO_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource1", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource2", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource1", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource2", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", ""));
                return null;
            }
        });
    }

    public void testMultipleResourcesWildCard() throws Exception {
        this.runTest(MyJsonRestServlet.MULTIPLE_RESOURCES_WILDCARD, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource1", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource2", ""));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "/any", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource1", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource2", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/any", ""));
                return null;
            }
        });
    }

    public void testContentTypeJsonCron() throws Exception {
        this.runTest(MyJsonRestServlet.CONTENT_TYPE_JSON_CRON_TEST, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "application/xml"));
                Assert.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "application/xml; param=x"));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", ""));
                Assert.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "application/json"));
                String response = TestJsonRestServlet.this.invokeAndGetResponse("GET", "", "json=object", "application/xml");
                Assert.assertTrue((boolean)response.contains("object"));
                response = TestJsonRestServlet.this.invokeAndGetResponse("GET", "", "json=array", "application/xml");
                Assert.assertTrue((boolean)response.contains("array"));
                return null;
            }
        });
    }

    static {
        new MyJsonRestServlet();
    }
}

