/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V0JobServlet;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV0JobServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    private void _testAction(final String action, final Configuration conf) throws Exception {
        this.runTest("/v0/job/*", V0JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", action);
                URL url = TestV0JobServlet.this.createURL("job-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                if (conf != null) {
                    conf.writeXml(conn.getOutputStream());
                }
                if (conf == null || conf.get("user.name") != null) {
                    Assert.assertEquals((int)200, (int)conn.getResponseCode());
                    Assert.assertEquals((String)action, (String)MockDagEngineService.did);
                } else {
                    Assert.assertEquals((int)400, (int)conn.getResponseCode());
                }
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("action", action);
                url = TestV0JobServlet.this.createURL("job-" + (MockDagEngineService.workflows.size() + 1) + "-W", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                if (conf != null) {
                    conf.writeXml(conn.getOutputStream());
                }
                if (conf == null || conf.get("user.name") != null) {
                    Assert.assertEquals((int)400, (int)conn.getResponseCode());
                    Assert.assertEquals((String)action, (String)MockDagEngineService.did);
                } else {
                    Assert.assertEquals((int)400, (int)conn.getResponseCode());
                }
                return null;
            }
        });
    }

    public void testStart() throws Exception {
        this._testAction("start", null);
    }

    public void testSuspend() throws Exception {
        this._testAction("suspend", null);
    }

    public void testResume() throws Exception {
        this._testAction("resume", null);
    }

    public void testKill() throws Exception {
        this._testAction("kill", null);
    }

    public void testReRun() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestV0JobServlet.getTestUser());
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        this.getFileSystem().mkdirs(appPath);
        this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
        conf.set("oozie.wf.application.path", appPath.toString());
        this._testAction("rerun", (Configuration)conf);
    }

    private void _testNonJsonResponses(final String show, final String contentType, final String response) throws Exception {
        this.runTest("/v0/job/*", V0JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", show);
                URL url = TestV0JobServlet.this.createURL("job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith(contentType));
                String output = IOUtils.getReaderAsString((Reader)new InputStreamReader(conn.getInputStream()), (int)1000);
                Assert.assertEquals((String)response, (String)output);
                Assert.assertEquals((String)show, (String)MockDagEngineService.did);
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("show", show);
                url = TestV0JobServlet.this.createURL("job-" + (MockDagEngineService.workflows.size() + 1) + "-W", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)show, (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testJobDef() throws Exception {
        this._testNonJsonResponses("definition", "application/xml", "<workflow-app/>");
    }

    public void testJobLog() throws Exception {
        this._testNonJsonResponses("log", "text/plain", "log");
    }

    public void testJobInfo() throws Exception {
        this.runTest("/v0/job/*", V0JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "info");
                URL url = TestV0JobServlet.this.createURL("job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"job-1-W", (Object)obj.get((Object)"id"));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                url = TestV0JobServlet.this.createURL("job-" + (MockDagEngineService.workflows.size() + 1) + "-W", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testGraph() throws Exception {
        this.runTest("/v0/job/*", V0JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "graph");
                URL url = TestV0JobServlet.this.createURL("job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)ErrorCode.E0306.name(), (String)conn.getHeaderField("oozie-error-code"));
                return null;
            }
        });
    }

    static {
        new V0JobServlet();
    }
}

