/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.V1JobServlet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV1AdminServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testStatus() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("status", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)OozieClient.SYSTEM_MODE.NORMAL.toString(), (Object)json.get((Object)"systemMode"));
                return null;
            }
        });
    }

    public void testOsEnv() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("os-env", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)(Shell.WINDOWS ? "USERNAME" : "USER")));
                return null;
            }
        });
    }

    public void testJavaSysProps() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("java-sys-properties", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"java.version"));
                return null;
            }
        });
    }

    public void testConfiguration() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("configuration", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"oozie.services"));
                return null;
            }
        });
    }

    public void testInstrumentation() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("instrumentation", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"variables"));
                return null;
            }
        });
    }

    public void testSafeMode() throws Exception {
        this.runTest(new String[]{"/v1/admin/*", "/v1/job/*"}, new Class[]{V1AdminServlet.class, V1JobServlet.class}, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "start");
                URL url = TestV1AdminServlet.this.createURL("/v1/job/*", "job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                url = TestV1AdminServlet.this.createURL("/v1/admin/*", "status", Collections.EMPTY_MAP);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"systemMode"));
                Assert.assertEquals((Object)OozieClient.SYSTEM_MODE.NORMAL.toString(), (Object)json.get((Object)"systemMode"));
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("systemmode", OozieClient.SYSTEM_MODE.SAFEMODE.toString());
                url = TestV1AdminServlet.this.createURL("/v1/admin/*", "status", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                url = TestV1AdminServlet.this.createURL("/v1/admin/*", "status", Collections.EMPTY_MAP);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"systemMode"));
                Assert.assertEquals((Object)OozieClient.SYSTEM_MODE.SAFEMODE.toString(), (Object)json.get((Object)"systemMode"));
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("action", "start");
                url = TestV1AdminServlet.this.createURL("/v1/job/*", "job-1-W", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                Assert.assertEquals((int)503, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("systemmode", OozieClient.SYSTEM_MODE.NORMAL.toString());
                url = TestV1AdminServlet.this.createURL("/v1/admin/*", "status", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                url = TestV1AdminServlet.this.createURL("/v1/admin/*", "status", Collections.EMPTY_MAP);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"systemMode"));
                Assert.assertEquals((Object)OozieClient.SYSTEM_MODE.NORMAL.toString(), (Object)json.get((Object)"systemMode"));
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("action", "start");
                url = TestV1AdminServlet.this.createURL("/v1/job/*", "job-1-W", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testVersion() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("build-version", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)BuildInfo.getBuildInfo().getProperty("build.version"), (Object)json.get((Object)"buildVersion"));
                return null;
            }
        });
    }

    public void testV1QueueDump() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("queue-dump", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"queueDump"));
                return null;
            }
        });
    }

    public void testAvailableTimeZones() throws Exception {
        this.runTest("/v1/admin/*", V1AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestV1AdminServlet.this.createURL("available-timezones", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertTrue((boolean)json.containsKey((Object)"available-timezones"));
                JSONArray array = (JSONArray)json.get((Object)"available-timezones");
                Assert.assertFalse((boolean)array.isEmpty());
                return null;
            }
        });
    }

    static {
        new V1AdminServlet();
        new V1JobServlet();
    }
}

