/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV1JobServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    private void _testAction(final String action, final Configuration conf) throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", action);
                URL url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                if (conf != null) {
                    conf.writeXml(conn.getOutputStream());
                }
                if (conf == null || conf.get("user.name") != null) {
                    Assert.assertEquals((int)200, (int)conn.getResponseCode());
                    Assert.assertEquals((String)action, (String)MockCoordinatorEngineService.did);
                } else {
                    Assert.assertEquals((int)400, (int)conn.getResponseCode());
                }
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", action);
                url = TestV1JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                if (conf != null) {
                    conf.writeXml(conn.getOutputStream());
                }
                if (conf == null || conf.get("user.name") != null) {
                    Assert.assertEquals((int)400, (int)conn.getResponseCode());
                    Assert.assertEquals((String)action, (String)MockCoordinatorEngineService.did);
                } else {
                    Assert.assertEquals((int)400, (int)conn.getResponseCode());
                }
                return null;
            }
        });
    }

    public void testSuspend() throws Exception {
        this._testAction("suspend", null);
    }

    public void testResume() throws Exception {
        this._testAction("resume", null);
    }

    public void testKill() throws Exception {
        this._testAction("kill", null);
    }

    public void testStart() throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "start");
                URL url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals(null, (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testStartForErrorCode() throws Exception {
        V1JobServlet testV1JobServlet = new V1JobServlet(){

            protected String getResourceName(HttpServletRequest request) {
                return "-C";
            }
        };
        try {
            testV1JobServlet.startJob(null, null);
            TestV1JobServlet.fail((String)"Negative test to test an exception. Should not be succeeding!");
        }
        catch (XServletException xse) {
            TestV1JobServlet.assertEquals((Object)xse.getErrorCode(), (Object)ErrorCode.E0303);
            TestV1JobServlet.assertTrue((boolean)xse.getMessage().contains("Invalid parameter value, [action] = [start]"));
        }
        catch (Exception e) {
            TestV1JobServlet.fail((String)"Did not expect a generic exception. Was expecting XServletException");
        }
    }

    private void _testNonJsonResponses(final String show, final String contentType, final String response) throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", show);
                URL url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith(contentType));
                String output = IOUtils.getReaderAsString((Reader)new InputStreamReader(conn.getInputStream()), (int)1000);
                Assert.assertEquals((String)response, (String)output);
                Assert.assertEquals((String)show, (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", show);
                url = TestV1JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)show, (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testJobDef() throws Exception {
        this._testNonJsonResponses("definition", "application/xml", "<coordinator-app></coordinator-app>");
    }

    public void testJobLog() throws Exception {
        this._testNonJsonResponses("log", "text/plain", "log");
    }

    public void testJobInfo() throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "info");
                URL url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "2");
                params.put("len", "50");
                url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(2));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(50));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "0");
                params.put("len", "0");
                url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(1000));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                url = TestV1JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testCoordChange() throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "change");
                String changeValue = "endtime=2011-12-01T05:00Z";
                params.put("value", changeValue);
                URL url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "change");
                changeValue = "concurrency=200";
                params.put("value", changeValue);
                url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "change");
                changeValue = "endtime=2011-12-01T05:00Z;concurrency=200";
                params.put("value", changeValue);
                url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "change");
                changeValue = "endtime=2011-12-01T05:00";
                params.put("value", changeValue);
                url = TestV1JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testCoordActionKill() throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "kill");
                String rangeType = "action";
                params.put("type", rangeType);
                String scope = "1-3";
                params.put("scope", scope);
                URL url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"kill", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "kill");
                rangeType = "date";
                params.put("type", rangeType);
                scope = "2009-12-15T01:00Z::2009-12-16T01:00Z, 2009-12-20T01:00Z";
                params.put("scope", scope);
                url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"kill", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testGraph() throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "graph");
                URL url = TestV1JobServlet.this.createURL("job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("image/png"));
                MockCoordinatorEngineService.reset();
                params.clear();
                params.put("show", "graph");
                url = TestV1JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)ErrorCode.E0306.name(), (String)conn.getHeaderField("oozie-error-code"));
                return null;
            }
        });
    }

    static {
        new V1JobServlet();
    }
}

