/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.oozie.AppType;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.V2SLAServlet;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.DateUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV2SLAServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSLA() throws Exception {
        this.runTest("/v2/sla", V2SLAServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Date currentTime = new Date(System.currentTimeMillis());
                Date nominalTime1 = DateUtils.parseDateUTC((String)"2012-06-01T10:00Z");
                Date nominalTime2 = DateUtils.parseDateUTC((String)"2012-06-02T10:20Z");
                Date nominalTime3 = DateUtils.parseDateUTC((String)"2012-06-03T14:00Z");
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(2, "1-", "-W", "1-C", nominalTime1, "testapp-1", AppType.WORKFLOW_JOB, currentTime, SLAEvent.EventStatus.END_MISS, SLAEvent.SLAStatus.IN_PROCESS);
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(3, "2-", "-W", null, nominalTime2, "testapp-2", AppType.WORKFLOW_JOB, currentTime, SLAEvent.EventStatus.END_MISS, SLAEvent.SLAStatus.IN_PROCESS);
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(6, "3-", "-W", "2-C", nominalTime3, "testapp-3", AppType.WORKFLOW_JOB, currentTime, SLAEvent.EventStatus.END_MISS, SLAEvent.SLAStatus.IN_PROCESS);
                HashMap<String, String> queryParams = new HashMap<String, String>();
                JSONArray array = null;
                URL url = TestV2SLAServlet.this.createURL("", queryParams);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                queryParams.put("filter", "app_name=testapp-1");
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                TestV2SLAServlet.this.assertSLAJSONResponse(array, 1, 2, "1-", "-W", "1-C", nominalTime1, "testapp-1", AppType.WORKFLOW_JOB, currentTime);
                queryParams.put("filter", "app_name=testapp-2;id=2-2-W");
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                TestV2SLAServlet.this.assertSLAJSONResponse(array, 2, 2, "2-", "-W", null, nominalTime2, "testapp-2", AppType.WORKFLOW_JOB, currentTime);
                queryParams.put("filter", "app_name=testapp-3;nominal_start=2012-06-03T16:00Z");
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                TestV2SLAServlet.this.assertSLAJSONResponse(array, 3, 6, "3-", "-W", "2-C", nominalTime3, "testapp-3", AppType.WORKFLOW_JOB, currentTime);
                queryParams.put("filter", "parent_id=2-C;nominal_start=2012-06-03T016:00Z;nominal_end=2012-06-03T17:00Z");
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                TestV2SLAServlet.this.assertSLAJSONResponse(array, 3, 4, "3-", "-W", "2-C", nominalTime3, "testapp-3", AppType.WORKFLOW_JOB, currentTime);
                return null;
            }
        });
    }

    public void testBundleSLA() throws Exception {
        this.runTest("/v2/sla", V2SLAServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String id;
                ArrayList<Object> beans = new ArrayList<Object>();
                String bundleId = "0000000-000000000000000-" + Services.get().getSystemId() + "-B";
                BundleJobBean bjBean = TestV2SLAServlet.this.createBundleJob(bundleId, Job.Status.RUNNING, false);
                String bundleName = bjBean.getAppName();
                beans.add(bjBean);
                CoordinatorJobBean cjBean1 = TestV2SLAServlet.this.createCoordJob(Job.Status.SUCCEEDED, false, true);
                beans.add(cjBean1);
                CoordinatorJobBean cjBean2 = TestV2SLAServlet.this.createCoordJob(Job.Status.SUCCEEDED, false, true);
                beans.add(cjBean2);
                BundleActionBean baBean1 = TestV2SLAServlet.this.createBundleAction(bundleId, cjBean1.getId(), "bundle-action-1", 0, Job.Status.RUNNING);
                beans.add(baBean1);
                BundleActionBean baBean2 = TestV2SLAServlet.this.createBundleAction(bundleId, cjBean2.getId(), "bundle-action-2", 0, Job.Status.RUNNING);
                beans.add(baBean2);
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(beans, null, null);
                Calendar cal = Calendar.getInstance();
                cal.add(12, -12);
                Date actualStartForMet = cal.getTime();
                cal.add(12, 2);
                Date expectedStart = cal.getTime();
                cal.add(12, 1);
                Date actualStartForMiss = cal.getTime();
                cal.add(12, 3);
                Date actualEndForMet = cal.getTime();
                cal.add(12, 1);
                Date expectedEnd = cal.getTime();
                cal.add(12, 2);
                Date actualEndForMiss = cal.getTime();
                cal.add(12, 8);
                Date futureExpectedEnd = cal.getTime();
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(cjBean1.getId() + "@1", cjBean1.getId(), "testapp-1", AppType.COORDINATOR_ACTION, SLAEvent.EventStatus.END_MET, SLAEvent.SLAStatus.MET, expectedStart, actualStartForMet, 7L, 6L, expectedEnd, actualEndForMet, actualStartForMet);
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(cjBean1.getId() + "@2", cjBean1.getId(), "testapp-1", AppType.COORDINATOR_ACTION, SLAEvent.EventStatus.END_MISS, SLAEvent.SLAStatus.MISS, expectedStart, actualStartForMiss, 5L, 6L, expectedEnd, actualEndForMiss, actualStartForMet);
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(cjBean2.getId() + "@1", cjBean2.getId(), "testapp-2", AppType.COORDINATOR_ACTION, SLAEvent.EventStatus.DURATION_MISS, SLAEvent.SLAStatus.IN_PROCESS, expectedStart, actualStartForMiss, 8L, 9L, futureExpectedEnd, null, actualStartForMet);
                TestV2SLAServlet.this.insertEntriesIntoSLASummaryTable(cjBean2.getId() + "@2", cjBean2.getId(), "testapp-2", AppType.COORDINATOR_ACTION, null, SLAEvent.SLAStatus.NOT_STARTED, expectedStart, null, 10L, -1L, futureExpectedEnd, null, expectedStart);
                HashMap<String, String> queryParams = new HashMap<String, String>();
                JSONArray array = null;
                URL url = TestV2SLAServlet.this.createURL("", queryParams);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                queryParams.put("timezone", "GMT");
                queryParams.put("filter", String.format("bundle=%s", bundleId));
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                Assert.assertEquals((int)4, (int)array.size());
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = (JSONObject)array.get(i);
                    id = (String)json.get((Object)"id");
                    if (!id.equals(cjBean1.getId() + "@1")) continue;
                    Assert.assertEquals((Object)-2L, (Object)json.get((Object)"startDelay"));
                    Assert.assertEquals((Object)0L, (Object)json.get((Object)"durationDelay"));
                    Assert.assertEquals((Object)-1L, (Object)json.get((Object)"endDelay"));
                }
                queryParams.clear();
                queryParams.put("timezone", "GMT");
                queryParams.put("filter", String.format("bundle=%s", bundleName));
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                Assert.assertEquals((int)4, (int)array.size());
                queryParams.clear();
                queryParams.put("timezone", "GMT");
                queryParams.put("filter", String.format("bundle=%s;event_status=END_MISS", bundleId));
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                Assert.assertEquals((int)1, (int)array.size());
                JSONObject json = (JSONObject)array.get(0);
                String parentId = (String)json.get((Object)"parentId");
                Assert.assertTrue((parentId.equals(cjBean1.getId()) || parentId.equals(cjBean2.getId()) ? 1 : 0) != 0);
                id = (String)json.get((Object)"id");
                Assert.assertTrue((boolean)id.equals(cjBean1.getId() + "@2"));
                String es = (String)json.get((Object)"eventStatus");
                Assert.assertTrue((boolean)es.contains(SLAEvent.EventStatus.END_MISS.toString()));
                queryParams.clear();
                queryParams.put("filter", String.format("bundle=%s;sla_status=MISS", bundleId));
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                Assert.assertEquals((int)1, (int)array.size());
                json = (JSONObject)array.get(0);
                id = (String)json.get((Object)"id");
                Assert.assertTrue((boolean)id.equals(cjBean1.getId() + "@2"));
                parentId = (String)json.get((Object)"parentId");
                Assert.assertTrue((boolean)parentId.equals(cjBean1.getId()));
                Assert.assertEquals((Object)1L, (Object)json.get((Object)"startDelay"));
                Assert.assertEquals((Object)0L, (Object)json.get((Object)"durationDelay"));
                Assert.assertEquals((Object)2L, (Object)json.get((Object)"endDelay"));
                queryParams.clear();
                queryParams.put("filter", String.format("bundle=%s;event_status=START_MISS,END_MISS", bundleName));
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                Assert.assertEquals((int)3, (int)array.size());
                for (int i = 0; i < array.size(); ++i) {
                    json = (JSONObject)array.get(i);
                    id = (String)json.get((Object)"id");
                    Assert.assertTrue((id.equals(cjBean1.getId() + "@2") || id.equals(cjBean2.getId() + "@1") || id.equals(cjBean2.getId() + "@2") ? 1 : 0) != 0);
                    parentId = (String)json.get((Object)"parentId");
                    Assert.assertTrue((parentId.equals(cjBean1.getId()) || parentId.equals(cjBean2.getId()) ? 1 : 0) != 0);
                }
                queryParams.clear();
                queryParams.put("filter", String.format("bundle=%s;event_status=DURATION_MISS;sla_status=IN_PROCESS", bundleName));
                array = TestV2SLAServlet.this.getSLAJSONResponse(queryParams);
                Assert.assertEquals((int)1, (int)array.size());
                json = (JSONObject)array.get(0);
                Assert.assertEquals((String)(cjBean2.getId() + "@1"), (String)((String)json.get((Object)"id")));
                Assert.assertEquals((String)cjBean2.getId(), (String)((String)json.get((Object)"parentId")));
                String eventStatus = (String)json.get((Object)"eventStatus");
                Assert.assertTrue((boolean)eventStatus.contains("DURATION_MISS"));
                Assert.assertTrue((boolean)eventStatus.contains("START_MISS"));
                Assert.assertFalse((eventStatus.contains("END_MISS") || eventStatus.contains("END_MET") ? 1 : 0) != 0);
                Assert.assertEquals((Object)9L, (Object)json.get((Object)"actualDuration"));
                Assert.assertEquals((Object)0L, (Object)json.get((Object)"durationDelay"));
                return null;
            }
        });
    }

    private JSONArray getSLAJSONResponse(Map<String, String> queryParams) throws Exception {
        URL url = this.createURL("", queryParams);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        TestV2SLAServlet.assertEquals((int)200, (int)conn.getResponseCode());
        TestV2SLAServlet.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
        JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
        JSONArray array = (JSONArray)json.get((Object)"slaSummaryList");
        return array;
    }

    private void assertSLAJSONResponse(JSONArray array, int startRange, int endRange, String jobIDPrefix, String jobIDSuffix, String parentId, Date startNominalTime, String appName, AppType appType, Date currentTime) throws Exception {
        Calendar nominalTime = Calendar.getInstance();
        nominalTime.setTime(startNominalTime);
        nominalTime.add(10, startRange - 1);
        int index = 0;
        TestV2SLAServlet.assertEquals((int)(endRange - (startRange - 1)), (int)array.size());
        for (int i = startRange; i <= endRange; ++i) {
            Calendar actualStart = (Calendar)nominalTime.clone();
            actualStart.add(12, i);
            Calendar expectedEnd = (Calendar)nominalTime.clone();
            expectedEnd.add(12, 60);
            Calendar actualEnd = (Calendar)expectedEnd.clone();
            actualEnd.add(12, i);
            JSONObject json = (JSONObject)array.get(index++);
            TestV2SLAServlet.assertEquals((Object)(jobIDPrefix + i + jobIDSuffix), (Object)json.get((Object)"id"));
            TestV2SLAServlet.assertEquals((Object)parentId, (Object)json.get((Object)"parentId"));
            TestV2SLAServlet.assertEquals((Object)appName, (Object)json.get((Object)"appName"));
            TestV2SLAServlet.assertEquals((Object)appType.name(), (Object)json.get((Object)"appType"));
            TestV2SLAServlet.assertEquals((Object)"RUNNING", (Object)json.get((Object)"jobStatus"));
            TestV2SLAServlet.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS.name(), (Object)json.get((Object)"slaStatus"));
            TestV2SLAServlet.assertEquals((Object)nominalTime.getTimeInMillis(), (Object)json.get((Object)"nominalTime"));
            TestV2SLAServlet.assertEquals((Object)nominalTime.getTimeInMillis(), (Object)json.get((Object)"expectedStart"));
            TestV2SLAServlet.assertEquals((Object)actualStart.getTimeInMillis(), (Object)json.get((Object)"actualStart"));
            TestV2SLAServlet.assertEquals((Object)expectedEnd.getTimeInMillis(), (Object)json.get((Object)"expectedEnd"));
            TestV2SLAServlet.assertEquals((Object)actualEnd.getTimeInMillis(), (Object)json.get((Object)"actualEnd"));
            TestV2SLAServlet.assertEquals((Object)10L, (Object)json.get((Object)"expectedDuration"));
            TestV2SLAServlet.assertEquals((Object)15L, (Object)json.get((Object)"actualDuration"));
            nominalTime.add(10, 1);
        }
    }

    private void insertEntriesIntoSLASummaryTable(int numEntries, String jobIDPrefix, String jobIDSuffix, String parentId, Date startNominalTime, String appName, AppType appType, Date currentTime, SLAEvent.EventStatus eventStatus, SLAEvent.SLAStatus slaStatus) throws JPAExecutorException {
        Calendar nominalTime = Calendar.getInstance();
        nominalTime.setTime(startNominalTime);
        for (int i = 1; i <= numEntries; ++i) {
            Calendar actualStart = (Calendar)nominalTime.clone();
            actualStart.add(12, i);
            Calendar expectedEnd = (Calendar)nominalTime.clone();
            expectedEnd.add(12, 60);
            Calendar actualEnd = (Calendar)expectedEnd.clone();
            actualEnd.add(12, i);
            this.insertEntriesIntoSLASummaryTable(jobIDPrefix + i + jobIDSuffix, parentId, appName, appType, eventStatus, slaStatus, nominalTime.getTime(), actualStart.getTime(), 10L, 15L, expectedEnd.getTime(), actualEnd.getTime(), nominalTime.getTime());
            nominalTime.add(10, 1);
        }
    }

    private void insertEntriesIntoSLASummaryTable(String jobID, String parentId, String appName, AppType appType, SLAEvent.EventStatus eventStatus, SLAEvent.SLAStatus slaStatus, Date expectedStartTime, Date actualStartTime, long expectedDuration, long actualDuration, Date expectedEndTime, Date actualEndTime, Date nominalTime) throws JPAExecutorException {
        SLASummaryBean bean = new SLASummaryBean();
        bean.setId(jobID);
        bean.setParentId(parentId);
        bean.setAppName(appName);
        bean.setAppType(appType);
        bean.setJobStatus("RUNNING");
        bean.setEventStatus(eventStatus);
        bean.setSLAStatus(slaStatus);
        bean.setNominalTime(nominalTime);
        bean.setExpectedStart(expectedStartTime);
        bean.setActualStart(actualStartTime);
        bean.setExpectedDuration(expectedDuration);
        bean.setActualDuration(actualDuration);
        bean.setExpectedEnd(expectedEndTime);
        bean.setActualEnd(actualEndTime);
        bean.setUser("testuser");
        bean.setLastModifiedTime(Calendar.getInstance().getTime());
        SLASummaryQueryExecutor.getInstance().insert((JsonBean)bean);
    }
}

