/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.AppType;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BundleActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLAEventInsertJPAExecutor;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.test.XHCatTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class XDataTestCase
extends XHCatTestCase {
    protected static String slaXml = " <sla:info xmlns:sla='uri:oozie:sla:0.1'> <sla:app-name>test-app</sla:app-name> <sla:nominal-time>2009-03-06T10:00Z</sla:nominal-time> <sla:should-start>5</sla:should-start> <sla:should-end>120</sla:should-end> <sla:notification-msg>Notifying User for nominal time : 2009-03-06T10:00Z </sla:notification-msg> <sla:alert-contact>abc@example.com</sla:alert-contact> <sla:dev-contact>abc@example.com</sla:dev-contact> <sla:qa-contact>abc@example.com</sla:qa-contact> <sla:se-contact>abc@example.com</sla:se-contact></sla:info>";
    protected String bundleName;
    protected String bundleId;
    protected String CREATE_TIME = "2012-07-22T00:00Z";

    @VisibleForTesting
    public void setUpPub() throws Exception {
        this.setUp();
    }

    @VisibleForTesting
    public void tearDownPub() throws Exception {
        this.tearDown();
    }

    protected void addRecordToCoordJobTable(CoordinatorJobBean coordJob) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, boolean pending, boolean doneMatd) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, pending, doneMatd);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(String appXml) throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-03T23:59Z");
        appXml = appXml.replaceAll("#start", DateUtils.formatDateOozieTZ((Date)start));
        appXml = appXml.replaceAll("#end", DateUtils.formatDateOozieTZ((Date)end));
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        this.writeToFile(appXml, appPath, "coordinator.xml");
        CoordinatorJobBean coordJob = this.createCoordBean(appPath, appXml, Job.Status.PREP, start, end, false, false, 0);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        return this.addRecordToCoordJobTable(status, start, end, new Date(), pending, doneMatd, lastActionNum);
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date start, Date end, Date createdTime, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, start, end, createdTime, pending, doneMatd, lastActionNum);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(String testFileName, Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(testFileName, status, start, end, pending, doneMatd, lastActionNum);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected CoordinatorJobBean addRecordToCoordJobTableWithBundle(String bundleId, String coordId, Job.Status status, boolean pending, boolean doneMatd, int lastActionNumber) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, pending, doneMatd);
        coordJob.setBundleId(bundleId);
        coordJob.setId(coordId);
        coordJob.setAppName(coordId);
        coordJob.setLastActionNumber(lastActionNumber);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected CoordinatorJobBean addRecordToCoordJobTableWithBundle(String bundleId, String coordId, Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNumber) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, start, end, pending, doneMatd, 0);
        coordJob.setBundleId(bundleId);
        coordJob.setId(coordId);
        coordJob.setAppName(coordId);
        coordJob.setLastActionNumber(lastActionNumber);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected CoordinatorJobBean createCoordJob(Job.Status status, boolean pending, boolean doneMatd) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.writeCoordXml(appPath);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        return this.createCoordBean(appPath, appXml, status, start, end, pending, doneMatd, 0);
    }

    protected CoordinatorJobBean createCoordJob(Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.writeCoordXml(appPath, start, end);
        return this.createCoordBean(appPath, appXml, status, start, end, pending, doneMatd, lastActionNum);
    }

    protected CoordinatorJobBean createCoordJob(Job.Status status, Date start, Date end, Date createTime, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.writeCoordXml(appPath, start, end);
        return this.createCoordBean(appPath, appXml, status, start, end, createTime, pending, doneMatd, lastActionNum);
    }

    protected CoordinatorJobBean createCoordJob(String testFileName, Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.writeCoordXml(appPath, testFileName);
        return this.createCoordBean(appPath, appXml, status, start, end, pending, doneMatd, lastActionNum);
    }

    private CoordinatorJobBean createCoordBean(Path appPath, String appXml, Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        return this.createCoordBean(appPath, appXml, status, start, end, new Date(), pending, doneMatd, lastActionNum);
    }

    private CoordinatorJobBean createCoordBean(Path appPath, String appXml, Job.Status status, Date start, Date end, Date createdTime, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.COORDINATOR));
        coordJob.setAppName("COORD-TEST");
        coordJob.setAppPath(appPath.toString());
        coordJob.setStatus(status);
        coordJob.setTimeZone("America/Los_Angeles");
        coordJob.setCreatedTime(createdTime);
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(XDataTestCase.getTestUser());
        coordJob.setGroup(XDataTestCase.getTestGroup());
        if (pending) {
            coordJob.setPending();
        }
        if (doneMatd) {
            coordJob.setDoneMaterialization();
        }
        coordJob.setLastActionNumber(lastActionNum);
        Configuration conf = this.getCoordConf(appPath);
        coordJob.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        coordJob.setJobXml(appXml);
        coordJob.setFrequency("1");
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.DAY);
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        coordJob.setMatThrottling(1);
        try {
            coordJob.setStartTime(start);
            coordJob.setEndTime(end);
        }
        catch (Exception e) {
            e.printStackTrace();
            XDataTestCase.fail((String)"Could not set Date/time");
        }
        return coordJob;
    }

    protected String writeCoordXml(Path appPath) throws IOException, UnsupportedEncodingException {
        String appXml = this.getCoordJobXml(appPath);
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath + "/coordinator.xml")));
        byte[] bytes = appXml.getBytes("UTF-8");
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader reader2 = new InputStreamReader(bais);
        IOUtils.copyCharStream((Reader)reader2, (Writer)writer);
        return appXml;
    }

    protected String writeCoordXml(Path appPath, Date start, Date end) throws IOException, UnsupportedEncodingException {
        String appXml = this.getCoordJobXml(appPath, start, end);
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath + "/coordinator.xml")));
        byte[] bytes = appXml.getBytes("UTF-8");
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader reader2 = new InputStreamReader(bais);
        IOUtils.copyCharStream((Reader)reader2, (Writer)writer);
        return appXml;
    }

    protected String writeCoordXml(Path appPath, String testFileName) throws IOException, UnsupportedEncodingException {
        String appXml = this.getCoordJobXml(testFileName);
        this.writeToFile(appXml, appPath, "coordinator.xml");
        return appXml;
    }

    protected CoordinatorActionBean addRecordToCoordActionTable(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, int pending) throws Exception {
        return this.addRecordToCoordActionTable(jobId, actionNum, status, resourceXmlName, pending, null);
    }

    protected CoordinatorActionBean addRecordToCoordActionTable(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, int pending, Date actionNominalTime) throws Exception {
        CoordinatorActionBean action = this.createCoordAction(jobId, actionNum, status, resourceXmlName, pending, actionNominalTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertCmd = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
        return action;
    }

    protected CoordinatorActionBean addRecordToCoordActionTable(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, String wfId, String wfStatus, int pending) throws Exception {
        CoordinatorActionBean action = this.createCoordAction(jobId, actionNum, status, resourceXmlName, pending);
        action.setExternalId(wfId);
        action.setExternalStatus(wfStatus);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertExecutor = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertExecutor);
            if (wfId != null) {
                WorkflowJobBean wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(wfId));
                wfJob.setParentId(action.getId());
                WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, (Object)wfJob);
            }
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
        return action;
    }

    protected CoordinatorActionBean addRecordToCoordActionTable(CoordinatorActionBean action, String wfId) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertExecutor = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertExecutor);
            if (wfId != null) {
                WorkflowJobBean wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(wfId));
                wfJob.setParentId(action.getId());
                WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, (Object)wfJob);
            }
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
        return action;
    }

    protected CoordinatorJobBean getCoordinatorJob(String jobId) throws Exception {
        CoordinatorJobBean coordJob = null;
        try {
            coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        }
        catch (JPAExecutorException e) {
            throw new Exception(e);
        }
        return coordJob;
    }

    protected CoordinatorActionBean getCoordinatorAction(String actionId) throws Exception {
        CoordinatorActionBean cAction = null;
        try {
            cAction = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{actionId});
        }
        catch (JPAExecutorException e) {
            throw new Exception(e);
        }
        return cAction;
    }

    protected CoordinatorActionBean createCoordAction(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, int pending) throws Exception {
        return this.createCoordAction(jobId, actionNum, status, resourceXmlName, pending, "Z", null);
    }

    protected CoordinatorActionBean createCoordAction(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, int pending, Date actionNominalTime) throws Exception {
        return this.createCoordAction(jobId, actionNum, status, resourceXmlName, pending, "Z", actionNominalTime);
    }

    protected CoordinatorActionBean createCoordAction(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, int pending, String oozieTimeZoneMask, Date actionNominalTime) throws Exception {
        String actionId = ((UUIDService)Services.get().get(UUIDService.class)).generateChildId(jobId, actionNum + "");
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, resourceXmlName);
        actionXml = actionXml.replace("${TZ}", oozieTimeZoneMask);
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setId(actionId);
        if (status != CoordinatorAction.Status.SUBMITTED && status != CoordinatorAction.Status.READY) {
            action.setExternalId(actionId + "_E");
        }
        action.setJobId(jobId);
        action.setActionNumber(actionNum);
        action.setPending(pending);
        try {
            if (actionNominalTime == null) {
                String nominalTime = this.getActionNominalTime(actionXml);
                action.setNominalTime(DateUtils.parseDateOozieTZ((String)nominalTime));
            } else {
                action.setNominalTime(actionNominalTime);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            XDataTestCase.fail((String)"Unable to get action nominal time");
            throw new IOException(e);
        }
        action.setLastModifiedTime(new Date());
        action.setCreatedTime(new Date());
        action.setStatus(status);
        action.setActionXml(actionXml);
        action.setTimeOut(10);
        Configuration conf = this.getCoordConf(appPath);
        action.setCreatedConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        action.setRunConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        return action;
    }

    protected WorkflowJobBean addRecordToWfJobTable(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus, String parentId) throws Exception {
        WorkflowJobBean subwfBean = this.addRecordToWfJobTable(jobStatus, instanceStatus);
        subwfBean.setParentId(parentId);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, (Object)subwfBean);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test wf job record to table");
            throw je;
        }
        return subwfBean;
    }

    protected WorkflowJobBean addRecordToWfJobTable(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        return this.addRecordToWfJobTable((WorkflowApp)app, jobStatus, instanceStatus);
    }

    protected WorkflowJobBean addRecordToWfJobTable(WorkflowApp app, WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        Configuration conf = new Configuration();
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", XDataTestCase.getTestUser());
        WorkflowJobBean wfBean = this.createWorkflow(app, conf, jobStatus, instanceStatus);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test wf job record to table");
            throw je;
        }
        return wfBean;
    }

    protected Path getAppPath() {
        Path baseDir = this.getFsTestCaseDir();
        return new Path(baseDir, "app");
    }

    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        return this.addRecordToWfActionTable(wfId, actionName, status, "", false);
    }

    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String actionName, WorkflowAction.Status status, boolean pending) throws Exception {
        return this.addRecordToWfActionTable(wfId, actionName, status, "", pending);
    }

    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String actionName, WorkflowAction.Status status, String execPath, boolean pending) throws Exception {
        WorkflowActionBean action = this.createWorkflowAction(wfId, actionName, status, pending);
        action.setExecutionPath(execPath);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test wf action record to table");
            throw je;
        }
        return action;
    }

    @Deprecated
    protected void addRecordToSLAEventTable(String slaId, SLAEvent.Status status, Date today) throws Exception {
        this.addRecordToSLAEventTable(slaId, "app-name", status, today);
    }

    @Deprecated
    protected void addRecordToSLAEventTable(String slaId, String appName, SLAEvent.Status status, Date today) throws Exception {
        SLAEventBean sla = new SLAEventBean();
        sla.setSlaId(slaId);
        sla.setAppName(appName);
        sla.setParentClientId("parent-client-id");
        sla.setParentSlaId("parent-sla-id");
        sla.setExpectedStart(today);
        sla.setExpectedEnd(today);
        sla.setNotificationMsg("notification-msg");
        sla.setAlertContact("alert-contact");
        sla.setDevContact("dev-contact");
        sla.setQaContact("qa-contact");
        sla.setSeContact("se-contact");
        sla.setAlertFrequency("alert-frequency");
        sla.setAlertPercentage("alert-percentage");
        sla.setUpstreamApps("upstream-apps");
        sla.setAppType(SLAEvent.SlaAppType.WORKFLOW_JOB);
        sla.setUser(XDataTestCase.getTestUser());
        sla.setGroupName(XDataTestCase.getTestGroup());
        sla.setJobStatus(status);
        sla.setStatusTimestamp(today);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            SLAEventInsertJPAExecutor slaInsertCmd = new SLAEventInsertJPAExecutor(sla);
            jpaService.execute((JPAExecutor)slaInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test sla event record to table");
            throw je;
        }
    }

    protected SLASummaryBean addRecordToSLASummaryTable(String appName, SLAEvent.SLAStatus status) throws Exception {
        SLASummaryBean sla = new SLASummaryBean();
        Date today = new Date();
        sla.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.COORDINATOR));
        sla.setAppName(appName);
        sla.setAppType(AppType.COORDINATOR_JOB);
        sla.setCreatedTime(today);
        sla.setNominalTime(today);
        sla.setExpectedStart(today);
        sla.setExpectedEnd(today);
        sla.setExpectedDuration(100L);
        sla.setJobStatus("RUNNING");
        sla.setSLAStatus(status);
        sla.setEventStatus(SLAEvent.EventStatus.START_MET);
        sla.setLastModifiedTime(today);
        sla.setUser("oozie");
        sla.setParentId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.BUNDLE));
        sla.setEventProcessed(1);
        sla.setActualStart(today);
        sla.setActualEnd(today);
        sla.setActualDuration(100L);
        try {
            SLASummaryQueryExecutor.getInstance().insert((JsonBean)sla);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test sla event record to table");
            throw je;
        }
        return sla;
    }

    protected SLARegistrationBean addRecordToSLARegistrationTable(String appName, SLAEvent.SLAStatus status) throws Exception {
        SLARegistrationBean sla = new SLARegistrationBean();
        Date today = new Date();
        sla.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.COORDINATOR));
        sla.setAppName(appName);
        sla.setAppType(AppType.COORDINATOR_JOB);
        sla.setExpectedDuration(100L);
        sla.setExpectedEnd(today);
        sla.setExpectedStart(today);
        sla.setJobData("test-job-data");
        sla.setCreatedTime(today);
        sla.setNominalTime(today);
        sla.setNotificationMsg("test-sla-notification-msg");
        sla.setParentId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.BUNDLE));
        sla.setSlaConfig("alert-events");
        sla.setUpstreamApps("test-upstream-apps");
        sla.setUser("oozie");
        try {
            SLARegistrationQueryExecutor.getInstance().insert((JsonBean)sla);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test sla registration record to table");
            throw je;
        }
        return sla;
    }

    public BundleJobBean addRecordToBundleJobTable(Job.Status jobStatus, boolean pending) throws Exception {
        BundleJobBean bundle = this.createBundleJob(jobStatus, pending);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test bundle job record to table");
            throw ce;
        }
        return bundle;
    }

    protected BundleJobBean addRecordToBundleJobTableNegative(Job.Status jobStatus) throws Exception {
        BundleJobBean bundle = this.createBundleJobNegative(jobStatus);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test bundle job record to table");
            throw ce;
        }
        return bundle;
    }

    protected BundleJobBean addRecordToBundleJobTableDisabledCoord(Job.Status jobStatus) throws Exception {
        BundleJobBean bundle = this.createBundleJobCoordDisabled(jobStatus);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test bundle job record to table");
            throw ce;
        }
        return bundle;
    }

    protected BundleJobBean createBundleJobCoordDisabled(Job.Status jobStatus) throws Exception {
        return this.createBundleJobCoordDisabled(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.BUNDLE), jobStatus);
    }

    protected BundleJobBean createBundleJobCoordDisabled(String jobID, Job.Status jobStatus) throws Exception {
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        Path coordPath2 = new Path(this.getFsTestCaseDir(), "coord2");
        this.writeCoordXml(coordPath1, "coord-job-bundle.xml");
        this.writeCoordXml(coordPath2, "coord-job-bundle.xml");
        Path bundleAppPath = new Path(this.getFsTestCaseDir(), "bundle");
        String bundleAppXml = this.getBundleXml("bundle-submit-job.xml");
        XDataTestCase.assertNotNull((Object)bundleAppXml);
        XDataTestCase.assertTrue((bundleAppXml.length() > 0 ? 1 : 0) != 0);
        bundleAppXml = bundleAppXml.replaceAll("#app_path1", Matcher.quoteReplacement(new Path(coordPath1.toString(), "coordinator.xml").toString()));
        bundleAppXml = bundleAppXml.replaceAll("#app_path2", Matcher.quoteReplacement(new Path(coordPath2.toString(), "coordinator.xml").toString()));
        this.writeToFile(bundleAppXml, bundleAppPath, "bundle.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.bundle.application.path", bundleAppPath.toString());
        conf.set("user.name", XDataTestCase.getTestUser());
        conf.set("jobTracker", this.getJobTrackerUri());
        conf.set("nameNode", this.getNameNodeUri());
        conf.set("appName", "bundle-app-name");
        conf.set("coordName1", "coord1");
        conf.set("coordName2", "coord2");
        conf.set("isEnabled", "false");
        BundleJobBean bundle = new BundleJobBean();
        bundle.setId(jobID);
        bundle.setAppName("BUNDLE-TEST");
        bundle.setAppPath(bundleAppPath.toString());
        bundle.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        bundle.setConsoleUrl("consoleUrl");
        bundle.setCreatedTime(new Date());
        bundle.setJobXml(bundleAppXml);
        bundle.setLastModifiedTime(new Date());
        bundle.setOrigJobXml(bundleAppXml);
        bundle.resetPending();
        bundle.setStatus(jobStatus);
        bundle.setUser(conf.get("user.name"));
        bundle.setGroup(conf.get("group.name"));
        return bundle;
    }

    protected BundleActionBean addRecordToBundleActionTable(String jobId, String coordName, int pending, Job.Status status) throws Exception {
        BundleActionBean action = this.createBundleAction(jobId, null, coordName, pending, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            BundleActionInsertJPAExecutor bundleActionJPAExecutor = new BundleActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)bundleActionJPAExecutor);
        }
        catch (JPAExecutorException ex) {
            ex.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test bundle action record to table");
            throw ex;
        }
        return action;
    }

    protected BundleActionBean addRecordToBundleActionTable(String jobId, String coordId, String coordName, int pending, Job.Status status) throws Exception {
        BundleActionBean action = this.createBundleAction(jobId, coordId, coordName, pending, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            BundleActionInsertJPAExecutor bundleActionJPAExecutor = new BundleActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)bundleActionJPAExecutor);
            CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordId));
            coordJob.setBundleId(jobId);
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID, coordJob);
        }
        catch (JPAExecutorException ex) {
            ex.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test bundle action record to table");
            throw ex;
        }
        return action;
    }

    protected BundleActionBean createBundleAction(String jobId, String coordId, String coordName, int pending, Job.Status status) throws Exception {
        BundleActionBean action = new BundleActionBean();
        action.setBundleId(jobId);
        action.setBundleActionId(jobId + "_" + coordName);
        action.setPending(pending);
        action.setCoordId(coordId);
        action.setCoordName(coordName);
        action.setStatus(status);
        action.setLastModifiedTime(new Date());
        return action;
    }

    protected String getCoordJobXml(Path appPath) {
        String inputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)"coord-rerun-job.xml", (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get coord-rerun-job.xml", (Object[])new Object[]{ioe}));
        }
    }

    protected String getCoordJobXml(Path appPath, Date start, Date end) {
        String startDateStr = null;
        String endDateStr = null;
        try {
            startDateStr = DateUtils.formatDateOozieTZ((Date)start);
            endDateStr = DateUtils.formatDateOozieTZ((Date)end);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XDataTestCase.fail((String)"Could not format dates");
        }
        try {
            Reader reader = IOUtils.getResourceAsReader((String)"coord-matd-job.xml", (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#start", startDateStr);
            appXml = appXml.replaceAll("#end", endDateStr);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get coord-matd-job.xml", (Object[])new Object[]{ioe}));
        }
    }

    protected String getCoordJobXml(String testFileName) {
        try {
            Reader reader = IOUtils.getResourceAsReader((String)testFileName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get [{0}]", (Object[])new Object[]{testFileName, ioe}));
        }
    }

    protected String getCoordActionXml(Path appPath, String resourceXmlName) {
        String inputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        String inputDir = appPath + "/coord-input/2010/07/05/01/00";
        inputDir = Matcher.quoteReplacement(inputDir);
        String outputDir = appPath + "/coord-input/2009/12/14/11/00";
        outputDir = Matcher.quoteReplacement(outputDir);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)resourceXmlName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            appXml = appXml.replaceAll("#inputDir", inputDir);
            appXml = appXml.replaceAll("#outputDir", outputDir);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)("Could not get " + resourceXmlName), (Object[])new Object[]{ioe}));
        }
    }

    protected Configuration getCoordConf(Path appPath) throws IOException {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "coord");
        XConfiguration jobConf = new XConfiguration();
        jobConf.set("oozie.coord.application.path", appPath.toString());
        jobConf.set("user.name", XDataTestCase.getTestUser());
        jobConf.set("jobTracker", this.getJobTrackerUri());
        jobConf.set("nameNode", this.getNameNodeUri());
        jobConf.set("wfAppPath", wfAppPath.toString());
        String content = "<workflow-app xmlns='uri:oozie:workflow:0.1'  xmlns:sla='uri:oozie:sla:0.1' name='no-op-wf'>";
        content = content + "<start to='end' />";
        content = content + "<end name='end' /></workflow-app>";
        this.writeToFile(content, wfAppPath, "workflow.xml");
        return jobConf;
    }

    protected void writeToFile(String content, Path appPath, String fileName) throws IOException {
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, fileName), true));
        writer.write(content);
        ((Writer)writer).close();
    }

    protected String getActionNominalTime(String actionXml) {
        Element eAction;
        try {
            eAction = XmlUtils.parseXml((String)actionXml);
        }
        catch (JDOMException je) {
            throw new RuntimeException(XLog.format((String)("Could not parse actionXml :" + actionXml), (Object[])new Object[]{je}));
        }
        String actionNomialTime = eAction.getAttributeValue("action-nominal-time");
        return actionNomialTime;
    }

    protected WorkflowJobBean createWorkflow(WorkflowApp app, Configuration conf, WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        XConfiguration protoActionConf = wps.createProtoActionConf(conf, true);
        WorkflowLib workflowLib = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).getWorkflowLibWithNoDB();
        WorkflowInstance wfInstance = workflowLib.createInstance(app, conf);
        ((LiteWorkflowInstance)wfInstance).setStatus(instanceStatus);
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(wfInstance.getId());
        workflow.setExternalId("extid");
        workflow.setAppName(app.getName());
        workflow.setAppPath(conf.get("oozie.wf.application.path"));
        workflow.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        workflow.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoActionConf).toString());
        workflow.setCreatedTime(new Date());
        workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
        workflow.setStatus(jobStatus);
        workflow.setRun(0);
        workflow.setUser(conf.get("user.name"));
        workflow.setGroup(conf.get("group.name"));
        workflow.setWorkflowInstance(wfInstance);
        workflow.setSlaXml("<sla></sla>");
        return workflow;
    }

    protected WorkflowActionBean createWorkflowAction(String wfId, String actionName, WorkflowAction.Status status, boolean pending) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        action.setName(actionName);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionName));
        action.setJobId(wfId);
        action.setType("map-reduce");
        action.setTransition("transition");
        action.setStatus(status);
        Date currDate = new Date();
        action.setCreatedTime(currDate);
        action.setStartTime(currDate);
        action.setEndTime(currDate);
        action.setLastCheckTime(currDate);
        action.setStats("dummyStats");
        if (pending) {
            action.setPending();
        } else {
            action.resetPending();
        }
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>" + inputDir.toString() + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir.toString() + "</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        action.setSlaXml("<sla></sla>");
        action.setData("dummy data");
        action.setStats("dummy stats");
        action.setExternalChildIDs("job_201601011800_0001");
        action.setRetries(2);
        action.setUserRetryCount(1);
        action.setUserRetryMax(2);
        action.setUserRetryInterval(1);
        action.setErrorInfo("dummyErrorCode", "dummyErrorMessage");
        action.setExternalId("dummy external id");
        action.setExternalStatus("RUNNING");
        return action;
    }

    protected WorkflowActionBean createWorkflowAction(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        return this.createWorkflowAction(wfId, actionName, status, false);
    }

    protected BundleJobBean createBundleJob(String jobID, Job.Status jobStatus, boolean pending) throws Exception {
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        Path coordPath2 = new Path(this.getFsTestCaseDir(), "coord2");
        this.writeCoordXml(coordPath1, "coord-job-bundle.xml");
        this.writeCoordXml(coordPath2, "coord-job-bundle.xml");
        Path bundleAppPath = new Path(this.getFsTestCaseDir(), "bundle");
        String bundleAppXml = this.getBundleXml("bundle-submit-job.xml");
        XDataTestCase.assertNotNull((Object)bundleAppXml);
        XDataTestCase.assertTrue((bundleAppXml.length() > 0 ? 1 : 0) != 0);
        bundleAppXml = bundleAppXml.replaceAll("#app_path1", Matcher.quoteReplacement(new Path(coordPath1.toString(), "coordinator.xml").toString()));
        bundleAppXml = bundleAppXml.replaceAll("#app_path2", Matcher.quoteReplacement(new Path(coordPath2.toString(), "coordinator.xml").toString()));
        this.writeToFile(bundleAppXml, bundleAppPath, "bundle.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.bundle.application.path", bundleAppPath.toString());
        conf.set("user.name", XDataTestCase.getTestUser());
        conf.set("jobTracker", this.getJobTrackerUri());
        conf.set("nameNode", this.getNameNodeUri());
        conf.set("appName", "bundle-app-name");
        conf.set("coordName1", "coord1");
        conf.set("coordName2", "coord2");
        conf.set("isEnabled", "true");
        BundleJobBean bundle = new BundleJobBean();
        bundle.setId(jobID);
        bundle.setAppName("BUNDLE-TEST");
        bundle.setAppPath(bundleAppPath.toString());
        bundle.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        bundle.setConsoleUrl("consoleUrl");
        bundle.setCreatedTime(new Date());
        bundle.setJobXml(bundleAppXml);
        bundle.setLastModifiedTime(new Date());
        bundle.setOrigJobXml(bundleAppXml);
        if (pending) {
            bundle.setPending();
        } else {
            bundle.resetPending();
        }
        bundle.setStatus(jobStatus);
        bundle.setUser(conf.get("user.name"));
        bundle.setGroup(conf.get("group.name"));
        return bundle;
    }

    protected BundleJobBean createBundleJob(Job.Status jobStatus, boolean pending) throws Exception {
        return this.createBundleJob(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.BUNDLE), jobStatus, pending);
    }

    protected BundleJobBean createBundleJobNegative(Job.Status jobStatus) throws Exception {
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        Path coordPath2 = new Path(this.getFsTestCaseDir(), "coord2");
        this.writeCoordXml(coordPath1, "coord-job-bundle-negative.xml");
        this.writeCoordXml(coordPath2, "coord-job-bundle-negative.xml");
        Path bundleAppPath = new Path(this.getFsTestCaseDir(), "bundle");
        String bundleAppXml = this.getBundleXml("bundle-submit-job.xml");
        bundleAppXml = bundleAppXml.replaceAll("#app_path1", new Path(coordPath1.toString(), "coordinator.xml").toString());
        bundleAppXml = bundleAppXml.replaceAll("#app_path2", new Path(coordPath1.toString(), "coordinator.xml").toString());
        this.writeToFile(bundleAppXml, bundleAppPath, "bundle.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.bundle.application.path", bundleAppPath.toString());
        conf.set("user.name", XDataTestCase.getTestUser());
        conf.set("jobTracker", this.getJobTrackerUri());
        conf.set("nameNode", this.getNameNodeUri());
        conf.set("coordName1", "coord1");
        conf.set("coordName2", "coord2");
        conf.set("coord1.starttime", "2009-02-01T00:00Z");
        conf.set("isEnabled", "true");
        BundleJobBean bundle = new BundleJobBean();
        bundle.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.BUNDLE));
        bundle.setAppName("BUNDLE-TEST");
        bundle.setAppPath(bundleAppPath.toString());
        bundle.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        bundle.setConsoleUrl("consoleUrl");
        bundle.setCreatedTime(new Date());
        bundle.setJobXml(bundleAppXml);
        bundle.setLastModifiedTime(new Date());
        bundle.setOrigJobXml(bundleAppXml);
        bundle.resetPending();
        bundle.setStatus(jobStatus);
        bundle.setUser(conf.get("user.name"));
        bundle.setGroup(conf.get("group.name"));
        return bundle;
    }

    protected String getBundleXml(String resourceXmlName) {
        try {
            Reader reader = IOUtils.getResourceAsReader((String)resourceXmlName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)("Could not get " + resourceXmlName), (Object[])new Object[]{ioe}));
        }
    }

    protected void insertRecordCoordAction(CoordinatorActionBean action) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertCmd = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
    }

    protected void setClassesToBeExcluded(Configuration conf, String[] excludedServices) {
        String classes = conf.get("oozie.services");
        StringBuilder builder = new StringBuilder(classes);
        for (String s : excludedServices) {
            int index = builder.indexOf(s);
            if (index == -1) continue;
            builder.replace(index, index + s.length() + 1, "");
        }
        conf.set("oozie.services", new String(builder));
    }

    protected void addServiceToRun(Configuration conf, String serviceName) {
        String classes = conf.get("oozie.services");
        StringBuilder builder = new StringBuilder(classes);
        builder.append("," + serviceName);
        conf.set("oozie.services", new String(builder));
    }

    protected void addRecordsForBulkMonitor() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        XDataTestCase.assertNotNull((Object)jpaService);
        BundleJobBean bundle = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        this.bundleId = bundle.getId();
        this.bundleName = bundle.getAppName();
        this.addCoordForBulkMonitor(this.bundleId);
    }

    protected void addCoordForBulkMonitor(String bundleId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        XDataTestCase.assertNotNull((Object)jpaService);
        this.addRecordToCoordJobTableWithBundle(bundleId, "Coord1", Job.Status.RUNNING, true, true, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "Coord2", Job.Status.RUNNING, true, true, 1);
        this.addRecordToCoordJobTableWithBundle(bundleId, "Coord3", Job.Status.RUNNING, true, true, 1);
        CoordinatorActionBean action1 = new CoordinatorActionBean();
        action1.setId("Coord1@1");
        action1.setStatus(CoordinatorAction.Status.FAILED);
        action1.setCreatedTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        action1.setJobId("Coord1");
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        cal.add(5, -1);
        action1.setNominalTime(cal.getTime());
        CoordActionInsertJPAExecutor actionInsert = new CoordActionInsertJPAExecutor(action1);
        jpaService.execute((JPAExecutor)actionInsert);
        CoordinatorActionBean action2 = new CoordinatorActionBean();
        action2.setId("Coord1@2");
        action2.setStatus(CoordinatorAction.Status.KILLED);
        action2.setCreatedTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        action2.setJobId("Coord1");
        cal.setTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        cal.add(5, -1);
        action2.setNominalTime(cal.getTime());
        actionInsert = new CoordActionInsertJPAExecutor(action2);
        jpaService.execute((JPAExecutor)actionInsert);
        CoordinatorActionBean action3 = new CoordinatorActionBean();
        action3.setId("Coord2@1");
        action3.setStatus(CoordinatorAction.Status.KILLED);
        action3.setCreatedTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        action3.setJobId("Coord2");
        cal.setTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        cal.add(5, -1);
        action3.setNominalTime(cal.getTime());
        actionInsert = new CoordActionInsertJPAExecutor(action3);
        jpaService.execute((JPAExecutor)actionInsert);
    }

    protected static String getCurrentDateafterIncrementingInMonths(int incrementMonth) {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(2, currentDate.get(2) + incrementMonth);
        return DateUtils.formatDateOozieTZ((Calendar)currentDate);
    }

    protected String addInitRecords(String pushMissingDependencies) throws Exception {
        return this.addInitRecords(null, pushMissingDependencies, "Z");
    }

    protected String addInitRecords(String missingDependencies, String pushMissingDependencies, String oozieTimeZoneMask) throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
        return this.addInitRecords(missingDependencies, pushMissingDependencies, oozieTimeZoneMask, job, 1);
    }

    protected String addInitRecords(String missingDependencies, String pushMissingDependencies, String oozieTimeZoneMask, CoordinatorJobBean job, int actionNum) throws Exception {
        CoordinatorActionBean action = this.addRecordToCoordActionTableForWaiting(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml", missingDependencies, pushMissingDependencies, oozieTimeZoneMask);
        return action.getId();
    }

    protected CoordinatorActionBean addRecordToCoordActionTableForWaiting(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName, String missingDependencies, String pushMissingDependencies, String oozieTimeZoneMask) throws Exception {
        CoordinatorActionBean action = this.createCoordAction(jobId, actionNum, status, resourceXmlName, 0, oozieTimeZoneMask, null);
        action.setMissingDependencies(missingDependencies);
        action.setPushMissingDependencies(pushMissingDependencies);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertCmd = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
        return action;
    }

    protected CoordinatorJobBean addRecordToCoordJobTableForWaiting(String testFileName, Job.Status status, boolean pending, boolean doneMatd) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, pending, doneMatd);
        return this.addRecordToCoordJobTableForWaiting(testFileName, coordJob);
    }

    protected CoordinatorJobBean addRecordToCoordJobTableForWaiting(String testFileName, Job.Status status, Date start, Date end, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(testFileName, status, start, end, pending, doneMatd, lastActionNum);
        return this.addRecordToCoordJobTableForWaiting(testFileName, coordJob);
    }

    protected CoordinatorJobBean addRecordToCoordJobTableForWaiting(String testFileName, CoordinatorJobBean coordJob) throws Exception {
        String testDir = this.getTestCaseDir();
        String appXml = this.getCoordJobXmlForWaiting(testFileName, testDir);
        coordJob.setJobXml(appXml);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            XDataTestCase.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            XDataTestCase.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected String getCoordJobXmlForWaiting(String testFileName, String testDir) {
        try {
            Reader reader = IOUtils.getResourceAsReader((String)testFileName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#testDir", testDir);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)("Could not get " + testFileName), (Object[])new Object[]{ioe}));
        }
    }

    protected void setCoordActionCreationTime(String actionId, long actionCreationTime) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        action.setCreatedTime(new Date(actionCreationTime));
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
    }

    protected void setCoordActionNominalTime(String actionId, long actionNominalTime) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        action.setNominalTime(new Date(actionNominalTime));
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
    }

    protected void setCoordActionStatus(String actionId, CoordinatorAction.Status status) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        action.setStatus(status);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
    }

    protected void setMissingDependencies(String actionId, String missingDependencies) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        action.setMissingDependencies(missingDependencies);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
    }

    protected void modifyCoordForRunning(CoordinatorJobBean coord) throws Exception {
        String wfXml = IOUtils.getResourceAsString((String)"wf-credentials.xml", (int)-1);
        this.writeToFile(wfXml, this.getFsTestCaseDir(), "workflow.xml");
        String coordXml = coord.getJobXml();
        coord.setJobXml(coordXml.replace("hdfs:///tmp/workflows/", this.getFsTestCaseDir() + "/workflow.xml"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coord);
    }

    protected void writeToFile(String appXml, File appPathFile) throws Exception {
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(appPathFile));
            out.println(appXml);
        }
    }

    protected CoordinatorActionBean checkCoordActionStatus(final String actionId, final CoordinatorAction.Status stat) throws Exception {
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
                    return stat.equals((Object)action.getStatus());
                }
                catch (JPAExecutorException se) {
                    throw new Exception("Action ID " + actionId + " was not stored properly in db");
                }
            }
        });
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        XDataTestCase.assertEquals((Object)stat, (Object)action.getStatus());
        return action;
    }
}

