/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.FixedJsonInstanceSerializer;
import org.apache.oozie.util.ZKUtils;

public abstract class ZKXTestCase
extends XDataTestCase {
    private TestingServer zkServer;
    private CuratorFramework client = null;
    private ServiceDiscovery<Map> sDiscovery = null;
    protected static final String ZK_ID = "1234";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
        this.setUpZK();
    }

    protected void setUp(Configuration conf) throws Exception {
        super.setUp();
        Services services = new Services();
        if (conf != null && conf.size() > 0) {
            for (Map.Entry entry : conf) {
                services.getConf().set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        services.init();
        this.setUpZK();
    }

    private void setUpZK() throws Exception {
        this.zkServer = this.setupZKServer();
        Services.get().getConf().set("oozie.zookeeper.connection.string", this.zkServer.getConnectString());
        Services.get().getConf().set("oozie.instance.id", ZK_ID);
        Services.get().getConf().setBoolean("oozie.zookeeper.server.shutdown.ontimeout", false);
        this.createClient();
        this.createServiceDiscovery();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Services.get().destroy();
        this.sDiscovery.close();
        this.sDiscovery = null;
        this.client.close();
        this.client = null;
        this.zkServer.stop();
        this.zkServer.close();
    }

    protected TestingServer setupZKServer() throws Exception {
        return new TestingServer();
    }

    protected String getConnectString() {
        return this.zkServer.getConnectString();
    }

    protected CuratorFramework getClient() {
        return this.client;
    }

    protected ServiceDiscovery<Map> getServiceDiscovery() {
        return this.sDiscovery;
    }

    private void createClient() throws Exception {
        RetryPolicy retryPolicy = ZKUtils.getRetryPolicy();
        String zkConnectionString = Services.get().getConf().get("oozie.zookeeper.connection.string", this.zkServer.getConnectString());
        String zkNamespace = Services.get().getConf().get("oozie.zookeeper.namespace", "oozie");
        this.client = CuratorFrameworkFactory.builder().namespace(zkNamespace).connectString(zkConnectionString).retryPolicy(retryPolicy).build();
        this.client.start();
    }

    private void createServiceDiscovery() throws Exception {
        FixedJsonInstanceSerializer instanceSerializer = new FixedJsonInstanceSerializer(Map.class);
        this.sDiscovery = ServiceDiscoveryBuilder.builder(Map.class).basePath("/services").client(this.client).serializer((InstanceSerializer)instanceSerializer).build();
        this.sDiscovery.start();
    }

    protected class DummyUser {
        private ZKUtils zk = null;

        public void register() throws Exception {
            this.zk = ZKUtils.register((Object)this);
            ZKXTestCase.this.sleep(1000);
        }

        public void unregister() {
            if (this.zk != null) {
                this.zk.unregister((Object)this);
                ZKXTestCase.this.sleep(1000);
            }
            this.zk = null;
        }

        public ZKUtils getZKUtils() {
            return this.zk;
        }
    }

    protected class DummyZKOozie {
        private CuratorFramework client = null;
        private String zkId;
        private ServiceDiscovery<Map> sDiscovery;
        private String metadataUrl;
        private LeaderLatch leaderLatch = null;

        public DummyZKOozie(String zkId, String metadataUrl) throws Exception {
            this(zkId, metadataUrl, false);
        }

        public DummyZKOozie(String zkId, String metadataUrl, boolean joinConcurrencyLeaderElection) throws Exception {
            this.zkId = zkId;
            this.metadataUrl = metadataUrl;
            this.createClient();
            this.advertiseService();
            if (joinConcurrencyLeaderElection) {
                this.joinConcurrencyLeaderElection();
            }
        }

        private void createClient() throws Exception {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
            String zkConnectionString = Services.get().getConf().get("oozie.zookeeper.connection.string", "localhost:2181");
            String zkNamespace = Services.get().getConf().get("oozie.zookeeper.namespace", "Oozie");
            this.client = CuratorFrameworkFactory.builder().namespace(zkNamespace).connectString(zkConnectionString).retryPolicy((RetryPolicy)retryPolicy).build();
            this.client.start();
        }

        private void advertiseService() throws Exception {
            new EnsurePath("/services").ensure(this.client.getZookeeperClient());
            FixedJsonInstanceSerializer instanceSerializer = new FixedJsonInstanceSerializer(Map.class);
            this.sDiscovery = ServiceDiscoveryBuilder.builder(Map.class).basePath("/services").client(this.client).serializer((InstanceSerializer)instanceSerializer).build();
            this.sDiscovery.start();
            this.sDiscovery.registerService(this.getMetadataInstance());
            ZKXTestCase.this.sleep(1000);
        }

        private void unadvertiseService() throws Exception {
            this.sDiscovery.unregisterService(this.getMetadataInstance());
            this.sDiscovery.close();
            ZKXTestCase.this.sleep(1000);
        }

        private void joinConcurrencyLeaderElection() throws Exception {
            this.leaderLatch = new LeaderLatch(this.client, "/services/concurrencyleader", this.zkId);
            this.leaderLatch.start();
        }

        public boolean isLeader() {
            if (this.leaderLatch != null) {
                return this.leaderLatch.hasLeadership();
            }
            throw new RuntimeException("Must join concurrency leader election");
        }

        public void teardown() {
            if (this.leaderLatch != null) {
                try {
                    this.leaderLatch.close();
                }
                catch (IOException ioe) {
                    ZKXTestCase.this.log.warn((Object)"Exception occured while leaving leader latch", (Throwable)ioe);
                }
            }
            try {
                this.unadvertiseService();
            }
            catch (Exception ex) {
                ZKXTestCase.this.log.warn((Object)("Exception occurred while unadvertising: " + ex.getMessage()), (Throwable)ex);
            }
            this.client.close();
        }

        private ServiceInstance<Map> getMetadataInstance() throws Exception {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("OOZIE_ID", this.zkId);
            map.put("OOZIE_URL", this.metadataUrl);
            return ServiceInstance.builder().name("servers").id(this.zkId).payload(map).build();
        }
    }
}

