/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test.hive;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.hive.service.server.HiveServer2;
import org.apache.oozie.test.hive.AbstractHiveService;
import org.junit.Assert;

public class MiniHS2
extends AbstractHiveService {
    private static final String driverName = "org.apache.hive.jdbc.HiveDriver";
    private HiveServer2 hiveServer2 = null;
    private final File baseDir = Files.createTempDir();
    private final Path baseDfsDir;
    private static final AtomicLong hs2Counter = new AtomicLong();
    private static final String HS2_BINARY_MODE = "binary";
    private static final String HS2_HTTP_MODE = "http";
    private HadoopShims.MiniMrShim mr;
    private HadoopShims.MiniDFSShim dfs;

    public MiniHS2(HiveConf hiveConf, FileSystem fs) throws IOException {
        super(hiveConf, "localhost", MetaStoreUtils.findFreePort(), MetaStoreUtils.findFreePort());
        this.baseDfsDir = new Path(new Path(fs.getUri()), "/base");
        String metaStoreURL = "jdbc:derby:" + this.baseDir.getAbsolutePath() + File.separator + "test_metastore-" + hs2Counter.incrementAndGet() + ";create=true";
        fs.mkdirs(this.baseDfsDir);
        Path wareHouseDir = new Path(this.baseDfsDir, "warehouse");
        fs.mkdirs(wareHouseDir);
        this.setWareHouseDir(wareHouseDir.toString());
        System.setProperty(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, metaStoreURL);
        hiveConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, metaStoreURL);
        this.setBinaryPort(MetaStoreUtils.findFreePort());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE, HS2_BINARY_MODE);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, this.getHost());
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, this.getBinaryPort());
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT, this.getHttpPort());
        Path scratchDir = new Path(this.baseDfsDir, "scratch");
        fs.mkdirs(scratchDir);
        System.setProperty(HiveConf.ConfVars.SCRATCHDIR.varname, scratchDir.toString());
        System.setProperty(HiveConf.ConfVars.LOCALSCRATCHDIR.varname, this.baseDir.getPath() + File.separator + "scratch");
    }

    public void start(Map<String, String> confOverlay) throws Exception {
        this.hiveServer2 = new HiveServer2();
        for (Map.Entry<String, String> entry : confOverlay.entrySet()) {
            this.setConfProperty(entry.getKey(), entry.getValue());
        }
        this.hiveServer2.init(this.getHiveConf());
        this.hiveServer2.start();
        this.waitForStartup();
        this.setStarted(true);
    }

    public void stop() {
        this.verifyStarted();
        this.hiveServer2.stop();
        this.setStarted(false);
        try {
            if (this.mr != null) {
                this.mr.shutdown();
                this.mr = null;
            }
            if (this.dfs != null) {
                this.dfs.shutdown();
                this.dfs = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.deleteQuietly((File)this.baseDir);
    }

    public CLIServiceClient getServiceClient() {
        this.verifyStarted();
        return this.getServiceClientInternal();
    }

    public CLIServiceClient getServiceClientInternal() {
        for (Service service : this.hiveServer2.getServices()) {
            if (service instanceof ThriftBinaryCLIService) {
                return new ThriftCLIServiceClient((TCLIService.Iface)((ThriftBinaryCLIService)service));
            }
            if (!(service instanceof ThriftHttpCLIService)) continue;
            return new ThriftCLIServiceClient((TCLIService.Iface)((ThriftHttpCLIService)service));
        }
        throw new IllegalStateException("HiveServer2 not running Thrift service");
    }

    public String getJdbcURL() {
        return this.getJdbcURL("default");
    }

    public String getJdbcURL(String dbName) {
        return this.getJdbcURL(dbName, "");
    }

    public String getJdbcURL(String dbName, String urlExtension) {
        Assert.assertNotNull((String)"URL extension shouldn't be null", (Object)urlExtension);
        String transportMode = this.getConfProperty(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname);
        if (transportMode != null && transportMode.equalsIgnoreCase(HS2_HTTP_MODE)) {
            return "jdbc:hive2://" + this.getHost() + ":" + this.getHttpPort() + "/" + dbName;
        }
        return "jdbc:hive2://" + this.getHost() + ":" + this.getBinaryPort() + "/" + dbName + urlExtension;
    }

    public static String getJdbcDriverName() {
        return driverName;
    }

    public HadoopShims.MiniMrShim getMR() {
        return this.mr;
    }

    public HadoopShims.MiniDFSShim getDFS() {
        return this.dfs;
    }

    private void waitForStartup() throws Exception {
        int waitTime = 0;
        long startupTimeout = 1000000000000L;
        CLIServiceClient hs2Client = this.getServiceClientInternal();
        SessionHandle sessionHandle = null;
        while (true) {
            Thread.sleep(500L);
            waitTime = (int)((long)waitTime + 500L);
            if ((long)waitTime > startupTimeout) {
                throw new TimeoutException("Couldn't access new HiveServer2: " + this.getJdbcURL());
            }
            try {
                sessionHandle = hs2Client.openSession("foo", "bar");
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
        hs2Client.closeSession(sessionHandle);
    }
}

