/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.CoordActionsInDateRange;
import org.apache.oozie.util.DateUtils;

public class TestCoordActionsInDateRange
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionsInDateRange() {
        try {
            int actionNum = 1;
            CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
            CoordinatorActionBean actionId1 = this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
            Date nominalTime = actionId1.getNominalTime();
            long nominalTimeMilliseconds = nominalTime.getTime();
            long noOfMillisecondsinOneHour = 3600000L;
            String date1 = DateUtils.formatDateOozieTZ((Date)new Date(nominalTimeMilliseconds - noOfMillisecondsinOneHour / 2L));
            String date2 = DateUtils.formatDateOozieTZ((Date)new Date(nominalTimeMilliseconds + noOfMillisecondsinOneHour));
            try {
                String badDate = "bad" + date1;
                CoordActionsInDateRange.getCoordActionIdsFromDates((String)job.getId().toString(), (String)(badDate + "::" + date2));
                TestCoordActionsInDateRange.fail((String)("Accepted badly formatted date: " + badDate));
            }
            catch (XException e) {
                TestCoordActionsInDateRange.assertEquals((Object)ErrorCode.E0308, (Object)e.getErrorCode());
            }
            try {
                String badScope = date1 + "0xbad5c09e" + date2;
                CoordActionsInDateRange.getCoordActionIdsFromDates((String)job.getId().toString(), (String)badScope);
                TestCoordActionsInDateRange.fail((String)("Accepted bad range scope: " + badScope));
            }
            catch (XException e) {
                TestCoordActionsInDateRange.assertEquals((Object)ErrorCode.E0308, (Object)e.getErrorCode());
            }
            try {
                CoordActionsInDateRange.getCoordActionIdsFromDates((String)job.getId().toString(), (String)(date2 + "::" + date1));
                TestCoordActionsInDateRange.fail((String)("Accepted inverted dates: [Start::End] = " + date2 + "::" + date1));
            }
            catch (XException e) {
                TestCoordActionsInDateRange.assertEquals((Object)ErrorCode.E0308, (Object)e.getErrorCode());
            }
            try {
                String lenientDate = date2.replaceAll("[^-]*T", "50T");
                CoordActionsInDateRange.getCoordActionIdsFromDates((String)job.getId().toString(), (String)(date1 + "::" + lenientDate));
                TestCoordActionsInDateRange.fail((String)("Accepted lenient date: " + lenientDate));
            }
            catch (XException e) {
                TestCoordActionsInDateRange.assertEquals((Object)ErrorCode.E0308, (Object)e.getErrorCode());
            }
            int noOfActions = CoordActionsInDateRange.getCoordActionIdsFromDates((String)job.getId().toString(), (String)(date1 + "::" + date2)).size();
            TestCoordActionsInDateRange.assertEquals((int)1, (int)noOfActions);
            date1 = DateUtils.formatDateOozieTZ((Date)new Date(nominalTimeMilliseconds + noOfMillisecondsinOneHour / 2L));
            noOfActions = CoordActionsInDateRange.getCoordActionIdsFromDates((String)job.getId().toString(), (String)(date1 + "::" + date2)).size();
            TestCoordActionsInDateRange.assertEquals((int)0, (int)noOfActions);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordActionsInDateRange.fail();
        }
    }
}

