/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.jsp.el.ELException;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.ELEvaluator;

public class TestELEvaluator
extends XTestCase {
    private static Method functionA;
    private static Method functionB;
    private static Method functionC;
    private static Method functionD;
    private static Method functionError;

    public static String functionA() {
        TestELEvaluator.assertEquals((Object)"A", (Object)ELEvaluator.getCurrent().getVariable("a"));
        return "a";
    }

    public String functionB() {
        return "b";
    }

    private static String functionC() {
        return "c";
    }

    public static String functionD(String in1, String in2) {
        return in1 + "::" + in2;
    }

    public static String functionError() throws ELEvaluationException {
        throw new ELEvaluationException("m", null);
    }

    public void testContextVars() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        TestELEvaluator.assertNull((Object)support.getVariable("a"));
        support.setVariable("a", (Object)"A");
        TestELEvaluator.assertEquals((Object)"A", (Object)support.getVariable("a"));
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("a", "AA");
        vars.put("b", "BB");
        support.setVariables(vars);
        TestELEvaluator.assertEquals((Object)"AA", (Object)support.getVariable("a"));
        TestELEvaluator.assertEquals((Object)"BB", (Object)support.getVariable("b"));
        try {
            support.resolveVariable("c");
            TestELEvaluator.fail();
        }
        catch (ELException eLException) {
            // empty catch block
        }
    }

    public void testContextFunctions() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        support.addFunction("a", "a", functionA);
        try {
            support.addFunction("b", "b", functionB);
            TestELEvaluator.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            support.addFunction("c", "c", functionC);
            TestELEvaluator.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestELEvaluator.assertEquals((Object)functionA, (Object)support.resolveFunction("a", "a"));
    }

    public void testVars() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        support.setVariable("a", (Object)"A");
        ELEvaluator evaluator = new ELEvaluator(support);
        TestELEvaluator.assertEquals((Object)"A", (Object)evaluator.getVariable("a"));
        TestELEvaluator.assertEquals((Object)"A", (Object)evaluator.getContext().getVariable("a"));
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("a", "AA");
        vars.put("b", "BB");
        support.setVariables(vars);
        TestELEvaluator.assertEquals((Object)"AA", (Object)support.getVariable("a"));
        TestELEvaluator.assertEquals((Object)"BB", (Object)support.getVariable("b"));
        try {
            support.resolveVariable("c");
            TestELEvaluator.fail();
        }
        catch (ELException eLException) {
            // empty catch block
        }
    }

    public void testFunctions() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        support.addFunction("a", "a", functionA);
        ELEvaluator evaluator = new ELEvaluator(support);
        TestELEvaluator.assertEquals((Object)functionA, (Object)evaluator.getContext().resolveFunction("a", "a"));
    }

    public void testEval() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        support.setVariable("a", (Object)"A");
        support.addFunction("a", "a", functionA);
        ELEvaluator evaluator = new ELEvaluator(support);
        TestELEvaluator.assertEquals((String)"Aa", (String)((String)evaluator.evaluate("${a}${a:a()}", String.class)));
    }

    public void testCurrent() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        support.setVariable("a", (Object)"A");
        support.addFunction("a", "a", functionA);
        ELEvaluator evaluator = new ELEvaluator(support);
        TestELEvaluator.assertNull((Object)ELEvaluator.getCurrent());
        TestELEvaluator.assertEquals((String)"a", (String)((String)evaluator.evaluate("${a:a()}", String.class)));
        TestELEvaluator.assertNull((Object)ELEvaluator.getCurrent());
    }

    public void testFunctionELEvaluationError() throws Exception {
        try {
            ELEvaluator.Context support = new ELEvaluator.Context();
            support.addFunction("a", "a", functionError);
            ELEvaluator evaluator = new ELEvaluator(support);
            evaluator.evaluate("${a:a()}", String.class);
            TestELEvaluator.fail();
        }
        catch (ELEvaluationException support) {
        }
        catch (ELException ex) {
            TestELEvaluator.fail();
        }
    }

    public void testCheckForExistence() throws Exception {
        ELEvaluator.Context support = new ELEvaluator.Context();
        support.setVariable("a", (Object)"A");
        support.addFunction("a", "a", functionA);
        support.addFunction("a", "d", functionD);
        ELEvaluator evaluator = new ELEvaluator(support);
        TestELEvaluator.assertNull((Object)ELEvaluator.getCurrent());
        TestELEvaluator.assertEquals((String)"a", (String)((String)evaluator.evaluate("${a:a()}", String.class)));
        TestELEvaluator.assertEquals((String)"a,a", (String)((String)evaluator.evaluate("${a:a()},${a:a()}", String.class)));
        try {
            evaluator.evaluate("${a:a(), a:a()}", String.class);
            TestELEvaluator.fail((String)"Evaluated bad expression");
        }
        catch (ELException eLException) {
            // empty catch block
        }
        TestELEvaluator.assertTrue((boolean)evaluator.checkForExistence("${a:a()}${a:a()}!", "!"));
        TestELEvaluator.assertTrue((boolean)evaluator.checkForExistence("${a:a()},${a:a()}", ","));
        TestELEvaluator.assertFalse((boolean)evaluator.checkForExistence("${a:d('foo', 'bar')}", ","));
        try {
            evaluator.checkForExistence("${a:a(), a:a()}", ",");
            TestELEvaluator.fail((String)"Parsed bad expression");
        }
        catch (ELException eLException) {
            // empty catch block
        }
        TestELEvaluator.assertNull((Object)ELEvaluator.getCurrent());
    }

    static {
        try {
            functionA = TestELEvaluator.class.getMethod("functionA", new Class[0]);
            functionB = TestELEvaluator.class.getMethod("functionB", new Class[0]);
            functionC = TestELEvaluator.class.getDeclaredMethod("functionC", new Class[0]);
            functionD = TestELEvaluator.class.getDeclaredMethod("functionD", String.class, String.class);
            functionError = TestELEvaluator.class.getDeclaredMethod("functionError", new Class[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

