/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ParameterVerifier;
import org.apache.oozie.util.ParameterVerifierException;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestParameterVerifier
extends XTestCase {
    public void testVerifyParametersNull() throws Exception {
        try {
            ParameterVerifier.verifyParameters(null, (Element)XmlUtils.parseXml((String)"<root xmlns=\"uri:oozie:workflow:0.4\"></root>"));
            TestParameterVerifier.fail();
        }
        catch (IllegalArgumentException ex) {
            TestParameterVerifier.assertEquals((String)"conf cannot be null", (String)ex.getMessage());
        }
        Configuration conf = new Configuration(false);
        conf.set("A", "a");
        ParameterVerifier.verifyParameters((Configuration)conf, null);
        TestParameterVerifier.assertEquals((int)1, (int)conf.size());
        TestParameterVerifier.assertEquals((String)"a", (String)conf.get("A"));
        try {
            ParameterVerifier.verifyParameters(null, null);
        }
        catch (IllegalArgumentException ex) {
            TestParameterVerifier.assertEquals((String)"conf cannot be null", (String)ex.getMessage());
        }
    }

    public void testVerifyParametersEmpty() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("A", "a");
        ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)"<root xmlns=\"uri:oozie:workflow:0.4\"></root>"));
        TestParameterVerifier.assertEquals((int)1, (int)conf.size());
        TestParameterVerifier.assertEquals((String)"a", (String)conf.get("A"));
        ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)"<root xmlns=\"uri:oozie:workflow:0.4\"><parameters></parameters></root>"));
        TestParameterVerifier.assertEquals((int)1, (int)conf.size());
        TestParameterVerifier.assertEquals((String)"a", (String)conf.get("A"));
    }

    public void testVerifyParametersMissing() throws Exception {
        Configuration conf = new Configuration(false);
        String str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name>hello</name></property></parameters></root>";
        try {
            ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
            TestParameterVerifier.fail();
        }
        catch (ParameterVerifierException ex) {
            TestParameterVerifier.assertEquals((Object)ErrorCode.E0738, (Object)ex.getErrorCode());
            TestParameterVerifier.assertTrue((boolean)ex.getMessage().endsWith("hello"));
            TestParameterVerifier.assertTrue((boolean)ex.getMessage().contains("1"));
            TestParameterVerifier.assertEquals((int)0, (int)conf.size());
        }
        conf = new Configuration(false);
        str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name>hello</name><value>world</value></property></parameters></root>";
        ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
        TestParameterVerifier.assertEquals((int)1, (int)conf.size());
        TestParameterVerifier.assertEquals((String)"world", (String)conf.get("hello"));
        conf = new Configuration(false);
        str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name>hello</name></property><property><name>foo</name><value>bar</value></property><property><name>meh</name></property></parameters></root>";
        try {
            ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
            TestParameterVerifier.fail();
        }
        catch (ParameterVerifierException ex) {
            TestParameterVerifier.assertEquals((Object)ErrorCode.E0738, (Object)ex.getErrorCode());
            TestParameterVerifier.assertTrue((boolean)ex.getMessage().endsWith("hello, meh"));
            TestParameterVerifier.assertFalse((boolean)ex.getMessage().contains("foo"));
            TestParameterVerifier.assertTrue((boolean)ex.getMessage().contains("2"));
            TestParameterVerifier.assertEquals((int)1, (int)conf.size());
            TestParameterVerifier.assertEquals((String)"bar", (String)conf.get("foo"));
        }
    }

    public void testVerifyParametersDefined() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("hello", "planet");
        String str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name>hello</name></property></parameters></root>";
        ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
        TestParameterVerifier.assertEquals((int)1, (int)conf.size());
        TestParameterVerifier.assertEquals((String)"planet", (String)conf.get("hello"));
        str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name>hello</name><value>world</value></property></parameters></root>";
        ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
        TestParameterVerifier.assertEquals((int)1, (int)conf.size());
        TestParameterVerifier.assertEquals((String)"planet", (String)conf.get("hello"));
    }

    public void testVerifyParametersEmptyName() throws Exception {
        Configuration conf = new Configuration(false);
        String str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name></name></property></parameters></root>";
        try {
            ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
            TestParameterVerifier.fail();
        }
        catch (ParameterVerifierException ex) {
            TestParameterVerifier.assertEquals((Object)ErrorCode.E0739, (Object)ex.getErrorCode());
        }
        str = "<root xmlns=\"uri:oozie:workflow:0.4\"><parameters><property><name>hello</name></property><property><name></name></property></parameters></root>";
        try {
            ParameterVerifier.verifyParameters((Configuration)conf, (Element)XmlUtils.parseXml((String)str));
            TestParameterVerifier.fail();
        }
        catch (ParameterVerifierException ex) {
            TestParameterVerifier.assertEquals((Object)ErrorCode.E0739, (Object)ex.getErrorCode());
        }
    }

    public void testSupportsParameters() throws Exception {
        TestParameterVerifier.assertFalse((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:workflow:0.3"));
        TestParameterVerifier.assertTrue((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:workflow:0.4"));
        TestParameterVerifier.assertTrue((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:workflow:0.5"));
        TestParameterVerifier.assertFalse((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:coordinator:0.3"));
        TestParameterVerifier.assertTrue((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:coordinator:0.4"));
        TestParameterVerifier.assertTrue((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:coordinator:0.5"));
        TestParameterVerifier.assertFalse((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:bundle:0.1"));
        TestParameterVerifier.assertTrue((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:bundle:0.2"));
        TestParameterVerifier.assertTrue((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:bundle:0.3"));
        TestParameterVerifier.assertFalse((boolean)ParameterVerifier.supportsParameters((String)"uri:oozie:foo:0.4"));
        TestParameterVerifier.assertFalse((boolean)ParameterVerifier.supportsParameters((String)"foo"));
    }
}

