/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PriorityDelayQueue;
import org.apache.oozie.util.XCallable;

public class TestPriorityDelayQueue
extends TestCase {
    public void testQueueElement() throws Exception {
        Object obj = new Object();
        try {
            new TestQueueElement<Object>(null);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new TestQueueElement<Object>(null, 0, 0L, TimeUnit.MILLISECONDS);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new TestQueueElement<Object>(obj, -1, 0L, TimeUnit.MILLISECONDS);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new TestQueueElement<Object>(obj, 0, -1L, TimeUnit.MILLISECONDS);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestQueueElement<Object> e1 = new TestQueueElement<Object>(obj);
        TestPriorityDelayQueue.assertEquals((Object)obj, (Object)e1.getElement().call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)e1.getPriority());
        TestPriorityDelayQueue.assertTrue((e1.getDelay(TimeUnit.MILLISECONDS) <= 0L ? 1 : 0) != 0);
        e1 = new TestQueueElement<Object>(obj, 1, 200L, TimeUnit.MILLISECONDS);
        TestPriorityDelayQueue.assertEquals((Object)obj, (Object)e1.getElement().call());
        TestPriorityDelayQueue.assertEquals((int)1, (int)e1.getPriority());
        TestPriorityDelayQueue.assertTrue((e1.getDelay(TimeUnit.MILLISECONDS) <= 200L ? 1 : 0) != 0);
        TestPriorityDelayQueue.assertTrue((e1.getDelay(TimeUnit.MILLISECONDS) >= 100L ? 1 : 0) != 0);
        Thread.sleep(300L);
        TestPriorityDelayQueue.assertTrue((e1.getDelay(TimeUnit.MILLISECONDS) <= 0L ? 1 : 0) != 0);
        TestQueueElement<Object> e2 = new TestQueueElement<Object>(obj);
        TestPriorityDelayQueue.assertTrue((e1.compareTo((Delayed)((Object)e2)) < 0 ? 1 : 0) != 0);
    }

    public void testQueueConstructor() throws Exception {
        try {
            new PriorityDelayQueue(0, 1000L, TimeUnit.MILLISECONDS, -1);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PriorityDelayQueue(1, 1000L, TimeUnit.MILLISECONDS, 0);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PriorityDelayQueue(1, 1000L, TimeUnit.MILLISECONDS, -2);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PriorityDelayQueue(1, 0L, TimeUnit.MILLISECONDS, 0);
            TestPriorityDelayQueue.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBoundUnboundQueueSize() {
        PriorityDelayQueue q = new PriorityDelayQueue(1, 1000L, TimeUnit.MILLISECONDS, -1);
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.getPriorities());
        TestPriorityDelayQueue.assertEquals((long)-1L, (long)q.getMaxSize());
        TestPriorityDelayQueue.assertEquals((long)1000L, (long)q.getMaxWait(TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        TestPriorityDelayQueue.assertTrue((boolean)q.offer(new TestQueueElement<Integer>(1)));
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.size());
        TestPriorityDelayQueue.assertTrue((boolean)q.offer(new TestQueueElement<Integer>(1)));
        TestPriorityDelayQueue.assertEquals((int)2, (int)q.size());
        TestPriorityDelayQueue.assertTrue((boolean)q.offer(new TestQueueElement<Integer>(1)));
        TestPriorityDelayQueue.assertEquals((int)3, (int)q.size());
        q = new PriorityDelayQueue(1, 1000L, TimeUnit.MILLISECONDS, 1);
        TestPriorityDelayQueue.assertEquals((long)1L, (long)q.getMaxSize());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        TestPriorityDelayQueue.assertTrue((boolean)q.offer(new TestQueueElement<Integer>(1)));
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.size());
        TestPriorityDelayQueue.assertFalse((boolean)q.offer(new TestQueueElement<Integer>(1)));
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.size());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        TestPriorityDelayQueue.assertTrue((boolean)q.offer(new TestQueueElement<Integer>(1)));
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.size());
    }

    public void testPoll() throws Exception {
        PriorityDelayQueue.QueueElement e;
        PriorityDelayQueue q = new PriorityDelayQueue(3, 500L, TimeUnit.MILLISECONDS, -1);
        q.offer(new TestQueueElement<Integer>(1));
        TestPriorityDelayQueue.assertEquals((Object)1, (Object)q.poll().getElement().call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(2, 0, 10L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertNull((Object)q.poll());
        Thread.sleep(11L);
        TestPriorityDelayQueue.assertEquals((Object)2, (Object)q.poll().getElement().call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(10, 0, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(30, 2, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 0L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((Object)30, (Object)q.poll().getElement().call());
        TestPriorityDelayQueue.assertEquals((Object)20, (Object)q.poll().getElement().call());
        TestPriorityDelayQueue.assertEquals((Object)10, (Object)q.poll().getElement().call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(10, 0, 10L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(30, 2, 10L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 10L, TimeUnit.MILLISECONDS));
        Thread.sleep(11L);
        ArrayList<XCallable> list = new ArrayList<XCallable>();
        while (list.size() != 3) {
            e = q.poll();
            if (e == null) continue;
            list.add(e.getElement());
        }
        TestPriorityDelayQueue.assertEquals((Object)30, (Object)((XCallable)list.get(0)).call());
        TestPriorityDelayQueue.assertEquals((Object)20, (Object)((XCallable)list.get(1)).call());
        TestPriorityDelayQueue.assertEquals((Object)10, (Object)((XCallable)list.get(2)).call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(10, 0, 10L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(30, 2, 20L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 0L, TimeUnit.MILLISECONDS));
        Thread.sleep(21L);
        list = new ArrayList();
        while (list.size() != 3) {
            e = q.poll();
            if (e == null) continue;
            list.add(e.getElement());
        }
        TestPriorityDelayQueue.assertEquals((Object)30, (Object)((XCallable)list.get(0)).call());
        TestPriorityDelayQueue.assertEquals((Object)20, (Object)((XCallable)list.get(1)).call());
        TestPriorityDelayQueue.assertEquals((Object)10, (Object)((XCallable)list.get(2)).call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        long start = System.currentTimeMillis();
        q.offer(new TestQueueElement<Integer>(10, 0, 100L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(30, 2, 200L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 0L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((Object)20, (Object)q.poll().getElement().call());
        long delay = System.currentTimeMillis() - start;
        Thread.sleep(101L - delay);
        TestPriorityDelayQueue.assertEquals((Object)10, (Object)q.poll().getElement().call());
        start = System.currentTimeMillis();
        delay = System.currentTimeMillis() - start;
        Thread.sleep(101L - delay);
        TestPriorityDelayQueue.assertEquals((Object)30, (Object)q.poll().getElement().call());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
    }

    public void testPeek() throws Exception {
        PriorityDelayQueue q = new PriorityDelayQueue(3, 500L, TimeUnit.MILLISECONDS, -1);
        q.offer(new TestQueueElement<Integer>(1));
        TestPriorityDelayQueue.assertEquals((Object)1, (Object)q.peek().getElement().call());
        q.poll();
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(1, 1, 10L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((Object)1, (Object)q.peek().getElement().call());
        Thread.sleep(11L);
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(10, 0, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(30, 2, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 0L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((Object)30, (Object)q.peek().getElement().call());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((Object)20, (Object)q.peek().getElement().call());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((Object)10, (Object)q.peek().getElement().call());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
        q.offer(new TestQueueElement<Integer>(30, 2, 200L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(10, 0, 100L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 150L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((Object)10, (Object)q.peek().getElement().call());
        Thread.sleep(100L);
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((Object)20, (Object)q.peek().getElement().call());
        Thread.sleep(50L);
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((Object)30, (Object)q.peek().getElement().call());
        Thread.sleep(50L);
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
    }

    public void testAntiStarvation() throws Exception {
        PriorityDelayQueue q = new PriorityDelayQueue(3, 500L, TimeUnit.MILLISECONDS, -1);
        q.offer(new TestQueueElement<Integer>(1));
        q.peek();
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.sizes()[0]);
        Thread.sleep(600L);
        q.peek();
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.sizes()[1]);
        Thread.sleep(600L);
        q.peek();
        TestPriorityDelayQueue.assertEquals((int)1, (int)q.sizes()[2]);
    }

    public void testConcurrency() throws Exception {
        int threads = 5;
        final AtomicInteger counter = new AtomicInteger(5);
        int priorities = 5;
        final PriorityDelayQueue queue = new PriorityDelayQueue(5, 100L, TimeUnit.MILLISECONDS, -1);
        int i = 0;
        while (i < 5) {
            final int count = i++;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 10; ++j) {
                        String msg = count + " - " + j;
                        try {
                            queue.offer(new TestQueueElement<String>(msg, (int)(Math.random() * 5.0), (int)(Math.random() * 500.0), TimeUnit.MILLISECONDS));
                            Thread.sleep((int)(Math.random() * 50.0));
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        counter.decrementAndGet();
                    }
                }
            }).start();
        }
        while (counter.get() > 0) {
            while (queue.poll() != null) {
            }
            Thread.sleep(10L);
        }
        while (queue.size() > 0) {
            while (queue.poll() != null) {
            }
            Thread.sleep(10L);
        }
    }

    public void testIterator() throws Exception {
        PriorityDelayQueue q = new PriorityDelayQueue(3, 500L, TimeUnit.MILLISECONDS, -1);
        q.offer(new TestQueueElement<Integer>(1, 1, 10L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(10, 0, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(30, 2, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(20, 1, 0L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((int)4, (int)q.size());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        q.offer(new TestQueueElement<Integer>(40, 0, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(50, 2, 0L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(60, 1, 0L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((int)5, (int)q.size());
        TestPriorityDelayQueue.assertNotNull((Object)q.poll());
        TestPriorityDelayQueue.assertEquals((int)4, (int)q.size());
    }

    public void testClear() {
        PriorityDelayQueue q = new PriorityDelayQueue(3, 500L, TimeUnit.MILLISECONDS, -1);
        q.offer(new TestQueueElement<Integer>(1, 1, 10L, TimeUnit.MILLISECONDS));
        q.offer(new TestQueueElement<Integer>(10, 0, 0L, TimeUnit.MILLISECONDS));
        TestPriorityDelayQueue.assertEquals((int)2, (int)q.size());
        q.clear();
        TestPriorityDelayQueue.assertEquals((int)0, (int)q.size());
    }

    public static class TestQueueElement<E>
    extends PriorityDelayQueue.QueueElement<E> {
        public TestQueueElement(final E element, int priority, long delay, TimeUnit unit) {
            super(new XCallable<E>(){

                public E call() throws Exception {
                    return element;
                }

                public String getName() {
                    return null;
                }

                public int getPriority() {
                    return 0;
                }

                public String getType() {
                    return null;
                }

                public long getCreatedTime() {
                    return 0L;
                }

                public String getKey() {
                    return null;
                }

                public String getEntityKey() {
                    return null;
                }

                public void setInterruptMode(boolean mode) {
                }

                public boolean inInterruptMode() {
                    return false;
                }
            }, priority, delay, unit);
            ParamChecker.notNull(element, (String)"element can't be null");
        }

        public TestQueueElement(E element) {
            this(element, 0, 0L, TimeUnit.MILLISECONDS);
        }

        protected void debug(String template, Object ... args) {
            System.out.println(MessageFormat.format(template, args));
        }
    }

    public static class DPriorityDelayQueue<E>
    extends PriorityDelayQueue<E> {
        public DPriorityDelayQueue(int priorities, long maxWait, TimeUnit unit, int maxSize) {
            super(priorities, maxWait, unit, maxSize);
        }

        protected void debug(String template, Object ... args) {
            System.out.println(MessageFormat.format(template, args));
        }
    }
}

