/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.SimpleTimestampedMessageParser;
import org.apache.oozie.util.TestTimestampedMessageParser;
import org.apache.oozie.util.XLogFilter;

public class TestSimplifiedTimestampedMessageParser
extends XTestCase {
    public void testProcessRemainingLog() throws IOException {
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        xf.setLogLevel("DEBUG|WARN");
        File file = TestTimestampedMessageParser.prepareFile1(this.getTestCaseDir());
        StringWriter sw = new StringWriter();
        new SimpleTimestampedMessageParser(new BufferedReader(new FileReader(file)), xf).processRemaining((Writer)sw, 4096);
        String[] out = sw.toString().split("\n");
        TestSimplifiedTimestampedMessageParser.assertEquals((int)19, (int)out.length);
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[0].contains("_L1_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[1].contains("_L2_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[2].contains("_L3_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[3].contains("_L3A_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[4].contains("_L3B_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[5].contains("_L4_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[6].contains("_L5_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[7].contains("_L6_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[8].contains("_L7_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[9].contains("_L8_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[10].contains("_L9_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[11].contains("_L10_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[12].contains("_L11_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[13].contains("_L12_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[14].contains("_L13_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[15].contains("_L14_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[16].contains("_L15_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[17].contains("_L16_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)out[18].contains("_L17_"));
    }

    public void testProcessRemainingCoordinatorLogForActions() throws IOException {
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-C");
        xf.setParameter("ACTION", "14-200904160239--example-C@1");
        File file = TestTimestampedMessageParser.prepareFile2(this.getTestCaseDir());
        StringWriter sw = new StringWriter();
        new SimpleTimestampedMessageParser(new BufferedReader(new FileReader(file)), xf).processRemaining((Writer)sw, 4096);
        String[] matches = sw.toString().split("\n");
        TestSimplifiedTimestampedMessageParser.assertEquals((int)9, (int)matches.length);
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[0].contains("_L1_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[1].contains("_L2_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[2].contains("_L3_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[3].contains("_L3A_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[4].contains("_L3B_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[5].contains("_L4_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[6].contains("_L5_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[7].contains("_L6_"));
        TestSimplifiedTimestampedMessageParser.assertTrue((boolean)matches[8].contains("_L7_"));
    }
}

