/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.db.Schema;

public class TestSchema
extends XTestCase {
    public static Map<Schema.Table, List<Schema.Column>> TABLE_COLUMNS = new HashMap<Schema.Table, List<Schema.Column>>();
    private static final String DB_NAME = "testdb";

    public static void prepareDB(Connection conn) throws SQLException {
        Schema.DBType type = Schema.DBType.ORACLE;
        if (Schema.isHsqlConnection((Connection)conn)) {
            type = Schema.DBType.HSQL;
        } else if (Schema.isMySqlConnection((Connection)conn)) {
            type = Schema.DBType.MySQL;
        }
        if (!type.equals((Object)Schema.DBType.ORACLE)) {
            conn.prepareStatement("CREATE " + (type.equals((Object)Schema.DBType.MySQL) ? "DATABASE " : "SCHEMA ") + DB_NAME + (type.equals((Object)Schema.DBType.HSQL) ? " AUTHORIZATION DBA" : "")).execute();
        }
        for (Schema.Table table : TABLE_COLUMNS.keySet()) {
            String createStmt = Schema.generateCreateTableScript((Schema.Table)table, (Schema.DBType)type, TABLE_COLUMNS.get(table));
            conn.prepareStatement(createStmt).execute();
        }
    }

    public static void dropSchema(Connection conn) throws SQLException {
        Schema.DBType type = Schema.DBType.ORACLE;
        if (Schema.isHsqlConnection((Connection)conn)) {
            type = Schema.DBType.HSQL;
        } else if (Schema.isMySqlConnection((Connection)conn)) {
            type = Schema.DBType.MySQL;
        } else {
            TestSchema.dropTables(conn);
            return;
        }
        conn.prepareStatement("DROP " + (type.equals((Object)Schema.DBType.MySQL) || type.equals((Object)Schema.DBType.ORACLE) ? "DATABASE " : "SCHEMA ") + (type.equals((Object)Schema.DBType.MySQL) || type.equals((Object)Schema.DBType.HSQL) ? DB_NAME : "") + (type.equals((Object)Schema.DBType.HSQL) ? " CASCADE" : "")).execute();
    }

    public static void dropTables(Connection conn) throws SQLException {
        Schema.DBType type = Schema.DBType.ORACLE;
        if (Schema.isHsqlConnection((Connection)conn)) {
            type = Schema.DBType.HSQL;
        } else if (Schema.isMySqlConnection((Connection)conn)) {
            type = Schema.DBType.MySQL;
        }
        for (Schema.Table table : TABLE_COLUMNS.keySet()) {
            String dropStmt = Schema.generateDropTableScript((Schema.Table)table, (Schema.DBType)type);
            conn.prepareStatement(dropStmt).execute();
        }
    }

    public void testGenerateCreateScript() throws SQLException {
        Connection conn = TestSchema.getDirectConnection();
        TestSchema.prepareDB(conn);
        ResultSet rs = conn.prepareStatement("SELECT COUNT(*) FROM " + (Object)((Object)TestTable.TEST_TABLE)).executeQuery();
        rs.next();
        TestSchema.assertEquals((int)0, (int)rs.getInt(1));
        rs.close();
        conn.prepareStatement("INSERT INTO " + (Object)((Object)TestTable.TEST_TABLE) + "(" + (Object)((Object)TestColumns.TEST_LONG) + ", " + (Object)((Object)TestColumns.TEST_STRING) + ") VALUES(1, 'abcd')").executeUpdate();
        rs = conn.prepareStatement("SELECT COUNT(*) FROM " + (Object)((Object)TestTable.TEST_TABLE)).executeQuery();
        rs.next();
        TestSchema.assertEquals((int)1, (int)rs.getInt(1));
        rs.close();
        boolean pkeyTest = false;
        try {
            conn.prepareStatement("INSERT INTO " + (Object)((Object)TestTable.TEST_TABLE) + "(" + (Object)((Object)TestColumns.TEST_LONG) + ", " + (Object)((Object)TestColumns.TEST_STRING) + ") VALUES(1, 'abcd')").executeUpdate();
        }
        catch (SQLException e) {
            pkeyTest = true;
        }
        TestSchema.assertEquals((boolean)true, (boolean)pkeyTest);
        String indexStmt = Schema.generateCreateIndexScript((Schema.Index)TestIndex.TEST_INDEX, (Schema.DBType)Schema.DBType.HSQL);
        conn.prepareStatement(indexStmt).execute();
        conn.prepareStatement("DROP TABLE " + (Object)((Object)TestTable.TEST_TABLE)).execute();
        TestSchema.dropSchema(conn);
        conn.close();
    }

    public static Connection getDirectConnection() throws SQLException {
        String driver = "org.hsqldb.jdbcDriver";
        String url = "jdbc:hsqldb:mem:testdb";
        String user = "sa";
        String password = "";
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Connection conn = DriverManager.getConnection(url, user, password);
        conn.setAutoCommit(true);
        conn.setTransactionIsolation(2);
        return conn;
    }

    static {
        for (TestColumns column : TestColumns.values()) {
            List<Schema.Column> tColumns = TABLE_COLUMNS.get(column.table());
            if (tColumns == null) {
                tColumns = new ArrayList<Schema.Column>();
                TABLE_COLUMNS.put(column.table(), tColumns);
            }
            tColumns.add(column);
        }
    }

    public static enum TestIndex implements Schema.Index
    {
        TEST_INDEX(TestColumns.TEST_LONG);

        private Schema.Column idxCol;

        private TestIndex(Schema.Column idxCol) {
            this.idxCol = idxCol;
        }

        public Schema.Column column() {
            return this.idxCol;
        }
    }

    public static enum TestColumns implements Schema.Column
    {
        TEST_LONG(TestTable.TEST_TABLE, Long.class, true),
        TEST_STRING(TestTable.TEST_TABLE, String.class, false, 100),
        TEST_TIMESTAMP(TestTable.TEST_TABLE, Timestamp.class, false),
        TEST_BOOLEAN(TestTable.TEST_TABLE, Boolean.class, false),
        TEST_BLOB(TestTable.TEST_TABLE, Blob.class, false);

        final Schema.Table table;
        final Class<?> type;
        int length = -1;
        final boolean isPrimaryKey;

        private TestColumns(Schema.Table table, Class<?> type, boolean isPrimaryKey) {
            this(table, type, isPrimaryKey, -1);
        }

        private TestColumns(Schema.Table table, Class<?> type, boolean isPrimaryKey, int length) {
            this.table = table;
            this.type = type;
            this.isPrimaryKey = isPrimaryKey;
            this.length = length;
        }

        public String asLabel() {
            return this.columnName();
        }

        public String columnName() {
            return this.name();
        }

        public int getLength() {
            return this.length;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isPrimaryKey() {
            return this.isPrimaryKey;
        }

        public Schema.Table table() {
            return this.table;
        }
    }

    public static enum TestTable implements Schema.Table
    {
        TEST_TABLE;


        public String toString() {
            return "testdb." + this.name();
        }
    }
}

