/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.db.Schema;
import org.apache.oozie.util.db.SqlStatement;
import org.apache.oozie.util.db.TestSchema;

public class TestSqlStatement
extends XTestCase {
    private Connection conn;
    private final String[] names = new String[]{"a", "b", "c", "d", "e"};
    private Timestamp currTime;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.init();
        this.conn = TestSchema.getDirectConnection();
        TestSchema.prepareDB(this.conn);
    }

    @Override
    protected void tearDown() throws Exception {
        TestSchema.dropSchema(this.conn);
        this.conn.close();
        Services.get().destroy();
        super.tearDown();
    }

    public void testSQLStatements() throws SQLException {
        this._testInsertAndGetCountAndprepare();
        this._testParser();
        this._testSelect();
        this._testUpdate();
        this._testDelete();
    }

    private void _testDelete() throws SQLException {
        ResultSet rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        TestSqlStatement.assertEquals((int)1, (int)rs.getInt(1));
        SqlStatement.deleteFrom((Schema.Table)TestSchema.TestTable.TEST_TABLE).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeUpdate();
        rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        TestSqlStatement.assertEquals((int)0, (int)rs.getInt(1));
    }

    private void _testUpdate() throws SQLException {
        SqlStatement.update((Schema.Table)TestSchema.TestTable.TEST_TABLE).set((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)"test").where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeUpdate();
        SqlStatement.ResultSetReader rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeQuery());
        rsReader.next();
        TestSqlStatement.assertEquals((String)"test", (String)rsReader.getString((Schema.Column)TestSchema.TestColumns.TEST_STRING));
        rsReader.close();
        SqlStatement.update((Schema.Table)TestSchema.TestTable.TEST_TABLE).set((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)"a").where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeUpdate();
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).prepareAndSetValues(this.conn).executeQuery());
        rsReader.next();
        TestSqlStatement.assertEquals((String)"a", (String)rsReader.getString((Schema.Column)TestSchema.TestColumns.TEST_STRING));
        rsReader.close();
    }

    private void _testSelect() throws SQLException {
        SqlStatement.ResultSetReader rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectAllFrom((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)5, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectAllFrom((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).limit(0, 3).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)3, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)5, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.isLike((Schema.Column)TestSchema.TestColumns.TEST_STRING, (String)this.names[0])).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)1, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.isNotLike((Schema.Column)TestSchema.TestColumns.TEST_STRING, (String)this.names[4])).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)4, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0)).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)1, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.isNotEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)4)).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)4, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.lessThan((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)3)).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)3, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.lessThanOrEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)3)).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)4, (int)this.checkIdAndName(rsReader));
        ResultSet rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.greaterThan((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)3)).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        TestSqlStatement.assertEquals((int)1, (int)rs.getInt(1));
        rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.greaterThanOrEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)3)).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        TestSqlStatement.assertEquals((int)2, (int)rs.getInt(1));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.in((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object[])new Object[]{0, 1, 2})).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)3, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.notIn((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object[])new Object[]{3, 4})).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)3, (int)this.checkIdAndName(rsReader));
        rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.between((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)1, (Object)3)).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        TestSqlStatement.assertEquals((int)3, (int)rs.getInt(1));
        rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.notBetween((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)1, (Object)3)).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        TestSqlStatement.assertEquals((int)2, (int)rs.getInt(1));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.and((SqlStatement.Condition[])new SqlStatement.Condition[]{SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0), SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)this.names[1])})).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)0, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.and((SqlStatement.Condition[])new SqlStatement.Condition[]{SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0), SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)this.names[0]), SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN, (Object)false)})).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)1, (int)this.checkIdAndName(rsReader));
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectColumns((Schema.Column[])new Schema.Column[]{TestSchema.TestColumns.TEST_STRING, TestSchema.TestColumns.TEST_LONG}).where(SqlStatement.or((SqlStatement.Condition[])new SqlStatement.Condition[]{SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)0), SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)this.names[1])})).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)2, (int)this.checkIdAndName(rsReader));
    }

    private void _testInsertAndGetCountAndprepare() throws SQLException {
        int i;
        ArrayList maps = new ArrayList();
        SqlStatement.Insert insert = SqlStatement.insertInto((Schema.Table)TestSchema.TestTable.TEST_TABLE).value((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)"1").value((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)"2").value((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN, (Object)true);
        SqlStatement.Update update = SqlStatement.update((Schema.Table)TestSchema.TestTable.TEST_TABLE).set((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN, (Object)false).where(SqlStatement.and((SqlStatement.Condition[])new SqlStatement.Condition[]{SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)"1"), SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)"2")}));
        PreparedStatement pUpdate = update.prepare(this.conn);
        PreparedStatement pInsert = insert.prepare(this.conn);
        for (i = 0; i < 4; ++i) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("1", i);
            values.put("2", this.names[i]);
            insert.getNewStatementWithValues(values).prepare(pInsert).execute();
            maps.add(values);
        }
        ResultSet rs = SqlStatement.getCount((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).prepareAndSetValues(this.conn).executeQuery();
        rs.next();
        int cnt = this.myGetCount(TestSchema.TestTable.TEST_TABLE);
        TestSqlStatement.assertEquals((int)4, (int)cnt);
        TestSqlStatement.assertEquals((int)rs.getInt(1), (int)cnt);
        SqlStatement.ResultSetReader rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectAllFrom((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN, (Object)true)).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)4, (int)this.checkIdAndName(rsReader));
        update.prepareForBatch(this.conn, maps, pUpdate).executeBatch();
        rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectAllFrom((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN, (Object)false)).orderBy((Schema.Column)TestSchema.TestColumns.TEST_LONG, true).prepareAndSetValues(this.conn).executeQuery());
        TestSqlStatement.assertEquals((int)4, (int)this.checkIdAndName(rsReader));
        this.currTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        SqlStatement.Insert stmt = SqlStatement.insertInto((Schema.Table)TestSchema.TestTable.TEST_TABLE).value((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)"1").value((Schema.Column)TestSchema.TestColumns.TEST_STRING, (Object)"2").value((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN, (Object)"3").value((Schema.Column)TestSchema.TestColumns.TEST_TIMESTAMP, (Object)"4").value((Schema.Column)TestSchema.TestColumns.TEST_BLOB, (Object)"5");
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("1", i);
        values.put("2", this.names[i]);
        values.put("3", true);
        values.put("4", this.currTime);
        values.put("5", this.names[i].getBytes());
        PreparedStatement pstmt = stmt.prepare(this.conn);
        stmt.getNewStatementWithValues(values).prepare(pstmt).executeUpdate();
        TestSqlStatement.assertEquals((int)5, (int)this.myGetCount(TestSchema.TestTable.TEST_TABLE));
    }

    private void _testParser() throws SQLException {
        SqlStatement.ResultSetReader rsReader = SqlStatement.parse((ResultSet)SqlStatement.selectAllFrom((Schema.Table[])new Schema.Table[]{TestSchema.TestTable.TEST_TABLE}).where(SqlStatement.isEqual((Schema.Column)TestSchema.TestColumns.TEST_LONG, (Object)4)).prepareAndSetValues(this.conn).executeQuery());
        rsReader.next();
        TestSqlStatement.assertEquals((long)4L, (long)rsReader.getLong((Schema.Column)TestSchema.TestColumns.TEST_LONG));
        TestSqlStatement.assertEquals((String)this.names[4], (String)rsReader.getString((Schema.Column)TestSchema.TestColumns.TEST_STRING));
        TestSqlStatement.assertEquals((String)String.format("yyyyy-mm-dd hh:mm", this.currTime), (String)String.format("yyyyy-mm-dd hh:mm", rsReader.getTimestamp((Schema.Column)TestSchema.TestColumns.TEST_TIMESTAMP)));
        TestSqlStatement.assertEquals((boolean)true, (boolean)rsReader.getBoolean((Schema.Column)TestSchema.TestColumns.TEST_BOOLEAN));
        TestSqlStatement.assertEquals((String)this.names[4], (String)new String(rsReader.getByteArray((Schema.Column)TestSchema.TestColumns.TEST_BLOB)));
        rsReader.close();
    }

    private int myGetCount(Schema.Table table) throws SQLException {
        ResultSet rs = this.conn.prepareStatement("SELECT count(*) FROM " + table).executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private int checkIdAndName(SqlStatement.ResultSetReader rsReader) throws SQLException {
        int cnt = 0;
        while (rsReader.next()) {
            TestSqlStatement.assertEquals((long)cnt, (long)rsReader.getLong((Schema.Column)TestSchema.TestColumns.TEST_LONG));
            TestSqlStatement.assertEquals((String)this.names[cnt], (String)rsReader.getString((Schema.Column)TestSchema.TestColumns.TEST_STRING));
            ++cnt;
        }
        rsReader.close();
        return cnt;
    }
}

