/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.service.UserGroupInformationService;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class FsActionExecutor
extends ActionExecutor {
    public static final String ACTION_TYPE = "fs";
    private final int maxGlobCount;
    private final XLog LOG = XLog.getLog(this.getClass());

    public FsActionExecutor() {
        super(ACTION_TYPE);
        this.maxGlobCount = ConfigurationService.getInt("oozie.action.fs.glob.max");
    }

    @Override
    public void initActionType() {
        super.initActionType();
        this.registerError(AccessControlException.class.getName(), ActionExecutorException.ErrorType.ERROR, "FS014");
    }

    Path getPath(Element element, String attribute) {
        String str = element.getAttributeValue(attribute).trim();
        return new Path(str);
    }

    void validatePath(Path path, boolean withScheme) throws ActionExecutorException {
        try {
            String scheme = path.toUri().getScheme();
            if (withScheme) {
                if (scheme == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS001", "Missing scheme in path [{0}]", path);
                }
                Services.get().get(HadoopAccessorService.class).checkSupportedFilesystem(path.toUri());
            } else if (scheme != null) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS002", "Scheme [{0}] not allowed in path [{1}]", scheme, path);
            }
        }
        catch (HadoopAccessorException hex) {
            throw this.convertException(hex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Path resolveToFullPath(Path nameNode, Path path, boolean withScheme) throws ActionExecutorException {
        if (nameNode == null) {
            this.validatePath(path, withScheme);
            return path;
        }
        String pathScheme = path.toUri().getScheme();
        String pathAuthority = path.toUri().getAuthority();
        if (pathScheme == null || pathAuthority == null) {
            if (!path.isAbsolute()) throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS011", "Path [{0}] cannot be relative", path);
            String nameNodeSchemeAuthority = nameNode.toUri().getScheme() + "://" + nameNode.toUri().getAuthority();
            return new Path(nameNodeSchemeAuthority + path.toString());
        }
        if (nameNode.toUri().getScheme().equals(pathScheme)) {
            if (nameNode.toUri().getAuthority().equals(pathAuthority)) return path;
        }
        this.validatePath(path, withScheme);
        return path;
    }

    void validateSameNN(Path source, Path dest) throws ActionExecutorException {
        String s;
        Path destPath = new Path(source, dest);
        String t = destPath.toUri().getScheme() + destPath.toUri().getAuthority();
        if (!t.equals(s = source.toUri().getScheme() + source.toUri().getAuthority())) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS007", "move, target NN URI different from that of source", dest);
        }
    }

    void doOperations(ActionExecutor.Context context, Element element) throws ActionExecutorException {
        try {
            String nameNode;
            FileSystem fs = context.getAppFileSystem();
            boolean recovery = fs.exists(this.getRecoveryPath(context));
            if (!recovery) {
                fs.mkdirs(this.getRecoveryPath(context));
            }
            Path nameNodePath = null;
            Element nameNodeElement = element.getChild("name-node", element.getNamespace());
            if (nameNodeElement != null && (nameNode = nameNodeElement.getTextTrim()) != null) {
                nameNodePath = new Path(nameNode);
                this.validatePath(nameNodePath, true);
            }
            XConfiguration fsConf = new XConfiguration();
            Path appPath = new Path(context.getWorkflow().getAppPath());
            if (fs.isFile(appPath)) {
                appPath = appPath.getParent();
            }
            JavaActionExecutor.parseJobXmlAndConfiguration(context, element, appPath, fsConf);
            for (Element commandElement : element.getChildren()) {
                Path path;
                String command = commandElement.getName();
                if (command.equals("mkdir")) {
                    path = this.getPath(commandElement, "path");
                    this.mkdir(context, fsConf, nameNodePath, path);
                    continue;
                }
                if (command.equals("delete")) {
                    path = this.getPath(commandElement, "path");
                    boolean skipTrash = true;
                    if (commandElement.getAttributeValue("skip-trash") != null && commandElement.getAttributeValue("skip-trash").equals("false")) {
                        skipTrash = false;
                    }
                    this.delete(context, fsConf, nameNodePath, path, skipTrash);
                    continue;
                }
                if (command.equals("move")) {
                    Path source = this.getPath(commandElement, "source");
                    Path target = this.getPath(commandElement, "target");
                    this.move(context, fsConf, nameNodePath, source, target, recovery);
                    continue;
                }
                if (command.equals("chmod")) {
                    path = this.getPath(commandElement, "path");
                    boolean recursive = commandElement.getChild("recursive", commandElement.getNamespace()) != null;
                    String str = commandElement.getAttributeValue("dir-files");
                    boolean dirFiles = str == null || Boolean.parseBoolean(str);
                    String permissionsMask = commandElement.getAttributeValue("permissions").trim();
                    this.chmod(context, fsConf, nameNodePath, path, permissionsMask, dirFiles, recursive);
                    continue;
                }
                if (command.equals("touchz")) {
                    path = this.getPath(commandElement, "path");
                    this.touchz(context, fsConf, nameNodePath, path);
                    continue;
                }
                if (command.equals("chgrp")) {
                    path = this.getPath(commandElement, "path");
                    boolean recursive = commandElement.getChild("recursive", commandElement.getNamespace()) != null;
                    String group = commandElement.getAttributeValue("group");
                    String str = commandElement.getAttributeValue("dir-files");
                    boolean dirFiles = str == null || Boolean.parseBoolean(str);
                    this.chgrp(context, fsConf, nameNodePath, path, context.getWorkflow().getUser(), group, dirFiles, recursive);
                    continue;
                }
                if (!command.equals("setrep")) continue;
                path = this.getPath(commandElement, "path");
                String replicationFactor = commandElement.getAttributeValue("replication-factor");
                if (commandElement.getAttributeValue("replication-factor") == null) continue;
                this.setrep(context, path, Short.parseShort(replicationFactor));
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void chgrp(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path, String user, String group, boolean dirFiles, boolean recursive) throws ActionExecutorException {
        this.LOG.info("Setting ownership for [{0}] to group: [{1}], user: [{2}]. Recursive mode: [{3}]", path, group, user, recursive);
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("user", user);
        argsMap.put("group", group);
        try {
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            path = this.resolveToFullPath(nameNodePath, path, true);
            Path[] pathArr = FileUtil.stat2Paths((FileStatus[])fs.globStatus(path));
            if (pathArr == null || pathArr.length == 0) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS009", "chgrp, path(s) that matches [{0}] does not exist", path);
            }
            this.checkGlobMax(pathArr);
            for (Path p : pathArr) {
                this.recursiveFsOperation("chgrp", fs, nameNodePath, p, argsMap, dirFiles, recursive, true);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void recursiveFsOperation(String op, FileSystem fs, Path nameNodePath, Path path, Map<String, String> argsMap, boolean dirFiles, boolean recursive, boolean isRoot) throws ActionExecutorException {
        try {
            FileStatus pathStatus = fs.getFileStatus(path);
            ArrayList<Path> paths = new ArrayList<Path>();
            if (dirFiles && pathStatus.isDirectory()) {
                if (isRoot) {
                    paths.add(path);
                }
                FileStatus[] filesStatus = fs.listStatus(path);
                for (int i = 0; i < filesStatus.length; ++i) {
                    Path p = filesStatus[i].getPath();
                    paths.add(p);
                    if (!recursive || !filesStatus[i].isDirectory()) continue;
                    this.recursiveFsOperation(op, fs, null, p, argsMap, dirFiles, recursive, false);
                }
            } else {
                paths.add(path);
            }
            for (Path p : paths) {
                this.doFsOperation(op, fs, p, argsMap);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void doFsOperation(String op, FileSystem fs, Path p, Map<String, String> argsMap) throws ActionExecutorException, IOException {
        if (op.equals("chmod")) {
            String permissions = argsMap.get("permissions");
            FsPermission newFsPermission = this.createShortPermission(permissions, p);
            fs.setPermission(p, newFsPermission);
        } else if (op.equals("chgrp")) {
            String user = argsMap.get("user");
            String group = argsMap.get("group");
            fs.setOwner(p, user, group);
        }
    }

    private FileSystem getFileSystemFor(Path path, ActionExecutor.Context context, XConfiguration fsConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        Configuration conf = has.createConfiguration(path.toUri().getAuthority());
        XConfiguration.copy(context.getProtoActionConf(), conf);
        if (fsConf != null) {
            XConfiguration.copy(fsConf, conf);
        }
        return has.createFileSystem(user, path.toUri(), conf);
    }

    private FileSystem getFileSystemFor(Path path, String user) throws HadoopAccessorException {
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        Configuration jobConf = has.createConfiguration(path.toUri().getAuthority());
        return has.createFileSystem(user, path.toUri(), jobConf);
    }

    void mkdir(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        this.mkdir(context, null, null, path);
    }

    void mkdir(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path) throws ActionExecutorException {
        this.LOG.info("Creating directory [{0}]", path);
        try {
            path = this.resolveToFullPath(nameNodePath, path, true);
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            if (!fs.exists(path)) {
                if (!fs.mkdirs(path)) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS004", "mkdir, path [{0}] could not create directory", path);
                }
            } else {
                this.LOG.info("[{0}] already exist, no need for creation", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void delete(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        this.delete(context, null, null, path, true);
    }

    public void delete(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path, boolean skipTrash) throws ActionExecutorException {
        this.LOG.info("Deleting [{0}]. Skipping trash: [{1}]", path, skipTrash);
        URI uri = path.toUri();
        URIHandler.Context hcatContext = null;
        try {
            URIHandler handler = Services.get().get(URIHandlerService.class).getURIHandler(uri);
            if (handler instanceof FSURIHandler) {
                final FileSystem fs = this.getFileSystemFor(path = this.resolveToFullPath(nameNodePath, path, true), context, fsConf);
                Path[] pathArr = FileUtil.stat2Paths((FileStatus[])fs.globStatus(path));
                if (pathArr != null && pathArr.length > 0) {
                    this.checkGlobMax(pathArr);
                    for (final Path p : pathArr) {
                        if (!fs.exists(p)) continue;
                        if (!skipTrash) {
                            UserGroupInformationService ugiService = Services.get().get(UserGroupInformationService.class);
                            UserGroupInformation ugi = ugiService.getProxyUser(fs.getConf().get("user.name"));
                            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                                @Override
                                public FileSystem run() throws Exception {
                                    Trash trash = new Trash(fs.getConf());
                                    if (!trash.moveToTrash(p)) {
                                        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "Could not move path [{0}] to trash on delete", p);
                                    }
                                    return null;
                                }
                            });
                            continue;
                        }
                        if (fs.delete(p, true)) continue;
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "delete, path [{0}] could not delete path", p);
                    }
                }
            } else {
                hcatContext = handler.getContext(uri, fsConf, context.getWorkflow().getUser(), false);
                handler.delete(uri, hcatContext);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        finally {
            if (hcatContext != null) {
                hcatContext.destroy();
            }
        }
    }

    public void delete(String user, String group, Path path) throws ActionExecutorException {
        try {
            this.validatePath(path, true);
            FileSystem fs = this.getFileSystemFor(path, user);
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "delete, path [{0}] could not delete path", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void move(ActionExecutor.Context context, Path source, Path target, boolean recovery) throws ActionExecutorException {
        this.move(context, null, null, source, target, recovery);
    }

    public void move(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path source, Path target, boolean recovery) throws ActionExecutorException {
        this.LOG.info("Moving [{0}] to [{1}]", source, target);
        try {
            source = this.resolveToFullPath(nameNodePath, source, true);
            this.validateSameNN(source, target);
            FileSystem fs = this.getFileSystemFor(source, context, fsConf);
            Path[] pathArr = FileUtil.stat2Paths((FileStatus[])fs.globStatus(source));
            if (pathArr == null || pathArr.length == 0) {
                if (!recovery) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS006", "move, source path [{0}] does not exist", source);
                }
                return;
            }
            if (pathArr.length > 1 && (!fs.exists(target) || fs.isFile(target))) {
                if (!recovery) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS012", "move, could not rename multiple sources to the same target name");
                }
                return;
            }
            this.checkGlobMax(pathArr);
            for (Path p : pathArr) {
                if (fs.rename(p, target) || recovery) continue;
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS008", "move, could not move [{0}] to [{1}]", p, target);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void chmod(ActionExecutor.Context context, Path path, String permissions, boolean dirFiles, boolean recursive) throws ActionExecutorException {
        this.chmod(context, null, null, path, permissions, dirFiles, recursive);
    }

    void chmod(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path, String permissions, boolean dirFiles, boolean recursive) throws ActionExecutorException {
        this.LOG.info("Setting permissions [{0}] on [{1}]. Recursive mode: [{2}]", permissions, path, recursive);
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("permissions", permissions);
        try {
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            path = this.resolveToFullPath(nameNodePath, path, true);
            Path[] pathArr = FileUtil.stat2Paths((FileStatus[])fs.globStatus(path));
            if (pathArr == null || pathArr.length == 0) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS009", "chmod, path(s) that matches [{0}] does not exist", path);
            }
            this.checkGlobMax(pathArr);
            for (Path p : pathArr) {
                this.recursiveFsOperation("chmod", fs, nameNodePath, p, argsMap, dirFiles, recursive, true);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void touchz(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        this.touchz(context, null, null, path);
    }

    void touchz(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path) throws ActionExecutorException {
        this.LOG.info("Performing touch on [{0}]", path);
        try {
            path = this.resolveToFullPath(nameNodePath, path, true);
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            if (fs.exists(path)) {
                FileStatus st = fs.getFileStatus(path);
                if (st.isDirectory()) {
                    throw new Exception(path.toString() + " is a directory");
                }
                if (st.getLen() != 0L) {
                    throw new Exception(path.toString() + " must be a zero-length file");
                }
            }
            FSDataOutputStream out = fs.create(path);
            out.close();
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    FsPermission createShortPermission(String permissions, Path path) throws ActionExecutorException {
        if (permissions.length() == 3) {
            char user = permissions.charAt(0);
            char group = permissions.charAt(1);
            char other = permissions.charAt(2);
            int useri = user - 48;
            int groupi = group - 48;
            int otheri = other - 48;
            int mask = useri * 100 + groupi * 10 + otheri;
            short omask = Short.parseShort(Integer.toString(mask), 8);
            return new FsPermission(omask);
        }
        if (permissions.length() == 10) {
            return FsPermission.valueOf((String)permissions);
        }
        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS010", "chmod, path [{0}] invalid permissions mask [{1}]", path, permissions);
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        this.LOG.info("Starting action");
        try {
            context.setStartData("-", "-", "-");
            Element actionXml = XmlUtils.parseXml(action.getConf());
            this.doOperations(context, actionXml);
            context.setExecutionData("OK", null);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        String externalStatus = action.getExternalStatus();
        WorkflowAction.Status status = externalStatus.equals("OK") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
        context.setEndData(status, this.getActionSignal(status));
        if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false)) {
            try {
                FileSystem fs = context.getAppFileSystem();
                fs.delete(context.getActionDir(), true);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
        this.LOG.info("Action ended with external status [{0}]", action.getExternalStatus());
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }

    public Path getRecoveryPath(ActionExecutor.Context context) throws HadoopAccessorException, IOException, URISyntaxException {
        return new Path(context.getActionDir(), "fs-" + context.getRecoveryId());
    }

    private void checkGlobMax(Path[] pathArr) throws ActionExecutorException {
        if (pathArr.length > this.maxGlobCount) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS013", "too many globbed files/dirs to do FS operation");
        }
    }

    void setrep(ActionExecutor.Context context, Path path, short replicationFactor) throws ActionExecutorException, HadoopAccessorException {
        this.LOG.info("Setting replication factor: [{0}] for [{1}]", replicationFactor, path);
        try {
            path = this.resolveToFullPath(null, path, true);
            FileSystem fs = this.getFileSystemFor(path, context, null);
            if (fs.isFile(path)) {
                fs.setReplication(path, replicationFactor);
            }
        }
        catch (IOException ex) {
            this.convertException(ex);
        }
    }

    @Override
    public boolean supportsConfigurationJobXML() {
        return true;
    }
}

