/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.CredentialsProviderFactory;
import org.apache.oozie.util.XLog;

public class HbaseCredentials
implements CredentialsProvider {
    static final String OOZIE_HBASE_CLIENT_SITE_XML = "oozie-hbase-client-site.xml";
    static final String HBASE_USE_DYNAMIC_JARS = "hbase.dynamic.jars.dir";

    @Override
    public void updateCredentials(Credentials credentials, Configuration config, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            this.copyHbaseConfToJobConf(config, props);
            this.obtainToken(credentials, config, context);
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).warn((Object)"Exception in receiving hbase credentials", e);
            throw e;
        }
    }

    void copyHbaseConfToJobConf(Configuration jobConf, CredentialsProperties props) {
        Configuration hbaseConf = new Configuration(false);
        HBaseConfiguration.addHbaseResources((Configuration)hbaseConf);
        this.addPropsConf(props, hbaseConf);
        this.addPropsConf(props, jobConf);
        this.injectConf(hbaseConf, jobConf);
    }

    private void obtainToken(Credentials credentials, final Configuration jobConf, ActionExecutor.Context context) throws IOException, InterruptedException {
        String user = context.getWorkflow().getUser();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        User u = User.create((UserGroupInformation)ugi);
        XLog.getLog(this.getClass()).debug("Getting Hbase token for user {0}", user);
        Token token = (Token)u.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

            @Override
            public Token<AuthenticationTokenIdentifier> run() throws Exception {
                Token newToken = null;
                try (Connection connection = ConnectionFactory.createConnection((Configuration)jobConf);){
                    newToken = TokenUtil.obtainToken((Connection)connection);
                }
                return newToken;
            }
        });
        XLog.getLog(this.getClass()).debug("Got token, adding it to credentials.");
        credentials.addToken(CredentialsProviderFactory.getUniqueAlias(token), token);
    }

    private void addPropsConf(CredentialsProperties props, Configuration destConf) {
        for (Map.Entry<String, String> entry : props.getProperties().entrySet()) {
            destConf.set(entry.getKey(), entry.getValue());
        }
    }

    private void injectConf(Configuration srcConf, Configuration destConf) {
        for (Map.Entry entry : srcConf) {
            String name = (String)entry.getKey();
            if (destConf.get(name) != null) continue;
            String value = (String)entry.getValue();
            destConf.set(name, value);
        }
    }

    static {
        Configuration.addDefaultResource((String)OOZIE_HBASE_CLIENT_SITE_XML);
    }
}

