/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.MRStats;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.PipesMain;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class MapReduceActionExecutor
extends JavaActionExecutor {
    public static final String OOZIE_ACTION_EXTERNAL_STATS_WRITE = "oozie.action.external.stats.write";
    public static final String HADOOP_COUNTERS = "hadoop.counters";
    public static final String OOZIE_MAPREDUCE_UBER_JAR_ENABLE = "oozie.action.mapreduce.uber.jar.enable";
    private static final String STREAMING_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.StreamingMain";
    public static final String JOB_END_NOTIFICATION_URL = "job.end.notification.url";
    private static final String MAPREDUCE_JOB_NAME = "mapreduce.job.name";
    private XLog log = XLog.getLog(this.getClass());

    public MapReduceActionExecutor() {
        super("map-reduce");
    }

    @Override
    public List<Class<?>> getLauncherClasses() {
        ArrayList classes = new ArrayList();
        try {
            classes.add(Class.forName(STREAMING_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected String getActualExternalId(WorkflowAction action) {
        String launcherJobId = action.getExternalId();
        String childId = action.getExternalChildIDs();
        if (childId != null && !childId.isEmpty()) {
            return childId;
        }
        return launcherJobId;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        String mainClass = actionXml.getChild("streaming", ns) != null ? launcherConf.get("oozie.launcher.action.main.class", STREAMING_MAIN_CLASS_NAME) : (actionXml.getChild("pipes", ns) != null ? launcherConf.get("oozie.launcher.action.main.class", PipesMain.class.getName()) : launcherConf.get("oozie.launcher.action.main.class", MapReduceMain.class.getName()));
        return mainClass;
    }

    @Override
    Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        super.setupLauncherConf(conf, actionXml, appPath, context);
        conf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
        return conf;
    }

    private void injectConfigClass(Configuration conf, Element actionXml) {
        Element e = actionXml.getChild("config-class", actionXml.getNamespace());
        if (e != null) {
            conf.set("oozie.action.config.class", e.getTextTrim());
        }
    }

    @Override
    protected Configuration createBaseHadoopConf(ActionExecutor.Context context, Element actionXml, boolean loadResources) {
        Configuration conf = super.createBaseHadoopConf(context, actionXml, loadResources);
        return conf;
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        boolean regularMR = false;
        this.injectConfigClass(actionConf, actionXml);
        Namespace ns = actionXml.getNamespace();
        if (actionXml.getChild("streaming", ns) != null) {
            Element streamingXml = actionXml.getChild("streaming", ns);
            String mapper = streamingXml.getChildTextTrim("mapper", ns);
            String reducer = streamingXml.getChildTextTrim("reducer", ns);
            String recordReader = streamingXml.getChildTextTrim("record-reader", ns);
            List list = streamingXml.getChildren("record-reader-mapping", ns);
            String[] recordReaderMapping = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                recordReaderMapping[i] = ((Element)list.get(i)).getTextTrim();
            }
            list = streamingXml.getChildren("env", ns);
            String[] env = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                env[i] = ((Element)list.get(i)).getTextTrim();
            }
            MapReduceActionExecutor.setStreaming(actionConf, mapper, reducer, recordReader, recordReaderMapping, env);
        } else if (actionXml.getChild("pipes", ns) != null) {
            Element pipesXml = actionXml.getChild("pipes", ns);
            String map = pipesXml.getChildTextTrim("map", ns);
            String reduce = pipesXml.getChildTextTrim("reduce", ns);
            String inputFormat = pipesXml.getChildTextTrim("inputformat", ns);
            String partitioner = pipesXml.getChildTextTrim("partitioner", ns);
            String writer = pipesXml.getChildTextTrim("writer", ns);
            String program = pipesXml.getChildTextTrim("program", ns);
            PipesMain.setPipes((Configuration)actionConf, (String)map, (String)reduce, (String)inputFormat, (String)partitioner, (String)writer, (String)program, (Path)appPath);
        } else {
            regularMR = true;
        }
        actionConf = super.setupActionConf(actionConf, context, actionXml, appPath);
        this.setJobName(actionConf, context);
        if (regularMR) {
            String uberJar = actionConf.get("oozie.mapreduce.uber.jar");
            if (uberJar != null) {
                Path uberJarPath;
                if (!ConfigurationService.getBoolean(OOZIE_MAPREDUCE_UBER_JAR_ENABLE)) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "MR003", "{0} property is not allowed.  Set {1} to true in oozie-site to enable.", "oozie.mapreduce.uber.jar", OOZIE_MAPREDUCE_UBER_JAR_ENABLE);
                }
                String nameNode = actionXml.getChildTextTrim("name-node", ns);
                if (nameNode != null && ((uberJarPath = new Path(uberJar)).toUri().getScheme() == null || uberJarPath.toUri().getAuthority() == null)) {
                    if (uberJarPath.isAbsolute()) {
                        Path nameNodePath = new Path(nameNode);
                        String nameNodeSchemeAuthority = nameNodePath.toUri().getScheme() + "://" + nameNodePath.toUri().getAuthority();
                        actionConf.set("oozie.mapreduce.uber.jar", new Path(nameNodeSchemeAuthority + uberJarPath).toString());
                    } else {
                        actionConf.set("oozie.mapreduce.uber.jar", new Path(appPath, uberJarPath).toString());
                    }
                }
            }
        } else if (actionConf.get("oozie.mapreduce.uber.jar") != null) {
            this.log.warn("The oozie.mapreduce.uber.jar property is only applicable for MapReduce (notstreaming nor pipes) workflows, ignoring");
            actionConf.set("oozie.mapreduce.uber.jar", "");
        }
        actionConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", true);
        return actionConf;
    }

    private void setJobName(Configuration actionConf, ActionExecutor.Context context) {
        String jobName = this.getAppName(context);
        if (jobName != null) {
            actionConf.set(MAPREDUCE_JOB_NAME, jobName.replace("oozie:launcher", "oozie:action"));
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        super.end(context, action);
        JobClient jobClient = null;
        boolean exception = false;
        try {
            if (action.getStatus() == WorkflowAction.Status.OK) {
                Element actionXml = XmlUtils.parseXml(action.getConf());
                Configuration jobConf = this.createBaseHadoopConf(context, actionXml);
                jobClient = this.createJobClient(context, jobConf);
                RunningJob runningJob = jobClient.getJob(JobID.forName((String)action.getExternalChildIDs()));
                if (runningJob == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "MR002", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", action.getExternalChildIDs(), action.getId());
                }
                Counters counters = runningJob.getCounters();
                if (counters != null) {
                    MRStats stats = new MRStats(counters);
                    String statsJsonString = stats.toJSON();
                    context.setVar(HADOOP_COUNTERS, statsJsonString);
                    if (Boolean.parseBoolean(this.evaluateConfigurationProperty(actionXml, OOZIE_ACTION_EXTERNAL_STATS_WRITE, "false")) && statsJsonString.getBytes().length <= MapReduceActionExecutor.getMaxExternalStatsSize()) {
                        context.setExecutionStats(statsJsonString);
                        this.log.debug("Printing stats for Map-Reduce action as a JSON string : [{0}]", statsJsonString);
                    }
                } else {
                    context.setVar(HADOOP_COUNTERS, "");
                    XLog.getLog(this.getClass()).warn("Could not find Hadoop Counters for: [{0}]", action.getExternalChildIDs());
                }
            }
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.log.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    private String evaluateConfigurationProperty(Element actionConf, String key, String defaultValue) throws ActionExecutorException {
        try {
            Namespace ns;
            Element e;
            String ret = defaultValue;
            if (actionConf != null && (e = actionConf.getChild("configuration", ns = actionConf.getNamespace())) != null) {
                String strConf = XmlUtils.prettyPrint(e).toString();
                XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
                ret = inlineConf.get(key, defaultValue);
            }
            return ret;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        return actionXml.getChild("streaming", ns) != null ? "mapreduce-streaming" : null;
    }

    public static void setStreaming(Configuration conf, String mapper, String reducer, String recordReader, String[] recordReaderMapping, String[] env) {
        if (mapper != null) {
            conf.set("oozie.streaming.mapper", mapper);
        }
        if (reducer != null) {
            conf.set("oozie.streaming.reducer", reducer);
        }
        if (recordReader != null) {
            conf.set("oozie.streaming.record-reader", recordReader);
        }
        ActionUtils.setStrings((Configuration)conf, (String)"oozie.streaming.record-reader-mapping", (String[])recordReaderMapping);
        ActionUtils.setStrings((Configuration)conf, (String)"oozie.streaming.env", (String[])env);
    }

    @Override
    protected void injectCallback(ActionExecutor.Context context, Configuration conf) {
        String callback = context.getCallbackUrl("$jobStatus");
        String originalCallbackURL = conf.get(JOB_END_NOTIFICATION_URL);
        if (originalCallbackURL != null) {
            this.LOG.warn("Overriding the action job end notification URI. Original value: {0}", originalCallbackURL);
        }
        conf.set(JOB_END_NOTIFICATION_URL, callback);
        super.injectCallback(context, conf);
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        Map<Object, Object> actionData = Collections.emptyMap();
        Configuration jobConf = null;
        try {
            FileSystem actionFs = context.getAppFileSystem();
            Element actionXml = XmlUtils.parseXml(action.getConf());
            jobConf = this.createBaseHadoopConf(context, actionXml);
            Path actionDir = context.getActionDir();
            actionData = LauncherHelper.getActionData(actionFs, actionDir, jobConf);
        }
        catch (Exception e) {
            this.LOG.warn("Exception in check(). Message[{0}]", e.getMessage(), e);
            throw this.convertException(e);
        }
        String newId = (String)actionData.get("newId");
        if (newId != null) {
            boolean jobCompleted;
            JobClient jobClient = null;
            boolean exception = false;
            try {
                jobClient = this.createJobClient(context, (Configuration)new JobConf(jobConf));
                RunningJob runningJob = jobClient.getJob(JobID.forName((String)newId));
                if (runningJob == null) {
                    context.setExternalStatus("FAILED");
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", newId, action.getId());
                }
                jobCompleted = runningJob.isComplete();
            }
            catch (Exception e) {
                this.LOG.warn((Object)"Unable to check the state of a running MapReduce job - please check the health of the Job History Server!", e);
                exception = true;
                throw this.convertException(e);
            }
            finally {
                if (jobClient != null) {
                    try {
                        jobClient.close();
                    }
                    catch (Exception e) {
                        if (exception) {
                            this.LOG.error((Object)"JobClient error (not re-throwing due to a previous error): ", e);
                        }
                        throw this.convertException(e);
                    }
                }
            }
            if (jobCompleted || actionData.containsKey("error.properties")) {
                super.check(context, action);
            } else {
                context.setExternalStatus("RUNNING");
                String externalAppId = TypeConverter.toYarn((org.apache.hadoop.mapreduce.JobID)JobID.forName((String)newId)).getAppId().toString();
                context.setExternalChildIDs(externalAppId);
            }
        } else {
            super.check(context, action);
        }
    }

    @Override
    void injectActionCallback(ActionExecutor.Context context, Configuration actionConf) {
        this.injectCallback(context, actionConf);
    }
}

