/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.TransitionXCommand;

public abstract class UnpauseTransitionXCommand
extends TransitionXCommand<Void> {
    public UnpauseTransitionXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public abstract void unpauseChildren() throws CommandException;

    @Override
    public final void transitToNext() throws CommandException {
        if (this.job == null) {
            this.job = this.getJob();
        }
        if (this.job.getStatus() == Job.Status.PAUSED) {
            this.job.setStatus(Job.Status.RUNNING);
        } else if (this.job.getStatus() == Job.Status.PAUSEDWITHERROR) {
            this.job.setStatus(Job.Status.RUNNINGWITHERROR);
        } else if (this.job.getStatus() == Job.Status.PREPPAUSED) {
            this.job.setStatus(Job.Status.PREP);
        } else {
            throw new CommandException(ErrorCode.E1316, this.job.getId());
        }
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            this.transitToNext();
            this.updateJob();
            this.unpauseChildren();
        }
        finally {
            this.notifyParent();
        }
        return null;
    }
}

