/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.hadoop.OozieJobInfo;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetForStartJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CoordActionStartXCommand
extends CoordinatorXCommand<Void> {
    public static final String EL_ERROR = "EL_ERROR";
    public static final String EL_EVAL_ERROR = "EL_EVAL_ERROR";
    public static final String COULD_NOT_START = "COULD_NOT_START";
    public static final String START_DATA_MISSING = "START_DATA_MISSING";
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    public static final String OOZIE_COORD_ACTION_NOMINAL_TIME = "oozie.coord.action.nominal_time";
    private final XLog log = this.getLog();
    private String actionId = null;
    private String user = null;
    private String appName = null;
    private CoordinatorActionBean coordAction = null;
    private JPAService jpaService = null;
    private String jobId = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public CoordActionStartXCommand(String id, String user, String appName, String jobId) {
        super("coord_action_start", "coord_action_start", 1);
        this.actionId = ParamChecker.notEmpty(id, "id");
        this.user = ParamChecker.notEmpty(user, "user");
        this.appName = ParamChecker.notEmpty(appName, "appName");
        this.jobId = jobId;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.actionId);
    }

    private Configuration mergeConfig(CoordinatorActionBean action) throws CommandException {
        String createdConf = action.getCreatedConf();
        String actionXml = action.getActionXml();
        Element workflowProperties = null;
        try {
            workflowProperties = XmlUtils.parseXml(actionXml);
        }
        catch (JDOMException e1) {
            this.log.warn("Configuration parse error in:" + actionXml);
            throw new CommandException(ErrorCode.E1005, new Object[]{e1.getMessage(), e1});
        }
        XConfiguration runConf = null;
        try {
            runConf = new XConfiguration(new StringReader(createdConf));
        }
        catch (IOException e1) {
            this.log.warn("Configuration parse error in:" + createdConf);
            throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
        }
        Element configElement = workflowProperties.getChild("action", workflowProperties.getNamespace()).getChild("workflow", workflowProperties.getNamespace()).getChild("configuration", workflowProperties.getNamespace());
        if (configElement != null) {
            XConfiguration localConf;
            String strConfig = XmlUtils.prettyPrint(configElement).toString();
            try {
                localConf = new XConfiguration(new StringReader(strConfig));
            }
            catch (IOException e1) {
                this.log.warn("Configuration parse error in:" + strConfig);
                throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
            }
            XConfiguration.copy(localConf, runConf);
        }
        String appPath = workflowProperties.getChild("action", workflowProperties.getNamespace()).getChild("workflow", workflowProperties.getNamespace()).getChild("app-path", workflowProperties.getNamespace()).getValue();
        runConf.set("oozie.wf.application.path", appPath);
        if (runConf.get("rerunConf") != null) {
            XConfiguration rerunConf = null;
            try {
                rerunConf = new XConfiguration(new StringReader(runConf.get("rerunConf")));
                XConfiguration.copy(rerunConf, runConf);
            }
            catch (IOException e) {
                this.log.warn("Configuration parse error in:" + (Object)((Object)rerunConf));
                throw new CommandException(ErrorCode.E1005, e.getMessage(), e);
            }
            runConf.unset("rerunConf");
        }
        return runConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected Void execute() throws CommandException {
        makeFail = true;
        errCode = "";
        errMsg = "";
        ParamChecker.notEmpty(this.user, "user");
        this.log.debug("actionid=" + this.actionId + ", status=" + this.coordAction.getStatus());
        if (this.coordAction.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            runConf = this.mergeConfig(this.coordAction);
            this.coordAction.setRunConf(XmlUtils.prettyPrint(runConf).toString());
            dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.user);
            try {
                conf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
                slaEvent = SLADbOperations.createStatusEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), SLAEvent.Status.STARTED, SLAEvent.SlaAppType.COORDINATOR_ACTION, this.log);
                if (slaEvent != null) {
                    this.insertList.add(slaEvent);
                }
                if (OozieJobInfo.isJobInfoEnabled()) {
                    conf.set("coord.id", this.actionId);
                    conf.set("coord.name", this.appName);
                    conf.set("coord.nominal.time", this.coordAction.getNominalTimestamp().toString());
                }
                JobUtils.normalizeAppPath(conf.get("user.name"), conf.get("group.name"), conf);
                if (this.coordAction.getExternalId() != null) {
                    conf.setBoolean("oozie.wf.rerun.failnodes", true);
                    dagEngine.reRun(this.coordAction.getExternalId(), conf);
                } else {
                    conf.set("oozie.coord.action.nominal_time", String.valueOf(this.coordAction.getNominalTime().getTime()));
                    wfId = dagEngine.submitJobFromCoordinator(conf, this.actionId);
                    this.coordAction.setExternalId(wfId);
                }
                this.coordAction.setStatus(CoordinatorAction.Status.RUNNING);
                this.coordAction.incrementAndGetPending();
                jpaService = Services.get().get(JPAService.class);
                if (jpaService != null) {
                    this.log.debug("Updating WF record for WFID :" + this.coordAction.getExternalId() + " with parent id: " + this.actionId);
                    wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STARTTIME, new Object[]{this.coordAction.getExternalId()});
                    wfJob.setParentId(this.actionId);
                    wfJob.setLastModifiedTime(new Date());
                    executor = BatchQueryExecutor.getInstance();
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, wfJob));
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_START, this.coordAction));
                    try {
                        executor.executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                        this.queue(new CoordActionNotificationXCommand(this.coordAction), 100L);
                        if (!EventHandlerService.isEnabled()) ** GOTO lbl52
                        CoordActionStartXCommand.generateEvent(this.coordAction, this.user, this.appName, wfJob.getStartTime());
                    }
                    catch (JPAExecutorException je) {
                        throw new CommandException(je);
                    }
                } else {
                    this.log.error((Object)ErrorCode.E0610);
                }
lbl52:
                // 3 sources

                makeFail = false;
            }
            catch (DagEngineException dee) {
                errMsg = dee.getMessage();
                errCode = dee.getErrorCode().toString();
                this.log.warn((Object)"can not create DagEngine for submitting jobs", dee);
            }
            catch (CommandException ce) {
                errMsg = ce.getMessage();
                errCode = ce.getErrorCode().toString();
                this.log.warn((Object)"command exception occurred ", ce);
            }
            catch (IOException ioe) {
                errMsg = ioe.getMessage();
                errCode = "E1005";
                this.log.warn((Object)("Configuration parse error. read from DB :" + this.coordAction.getRunConf()), ioe);
            }
            catch (Exception ex) {
                errMsg = ex.getMessage();
                errCode = "E1005";
                this.log.warn((Object)"can not create DagEngine for submitting jobs", ex);
            }
            finally {
                if (makeFail) {
                    this.log.error("Failing the action " + this.coordAction.getId() + ". Because " + errCode + " : " + errMsg);
                    this.coordAction.setStatus(CoordinatorAction.Status.FAILED);
                    if (errMsg.length() > 254) {
                        errMsg = errMsg.substring(0, 255);
                    }
                    this.coordAction.setErrorMessage(errMsg);
                    this.coordAction.setErrorCode(errCode);
                    this.updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_START, this.coordAction));
                    this.insertList = new ArrayList<JsonBean>();
                    slaEvent = SLADbOperations.createStatusEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.COORDINATOR_ACTION, this.log);
                    if (slaEvent != null) {
                        this.insertList.add(slaEvent);
                    }
                    try {
                        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                        if (EventHandlerService.isEnabled()) {
                            CoordActionStartXCommand.generateEvent(this.coordAction, this.user, this.appName, null);
                        }
                    }
                    catch (JPAExecutorException je) {
                        throw new CommandException(je);
                    }
                    this.queue(new CoordActionReadyXCommand(this.coordAction.getJobId()));
                }
            }
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        try {
            this.coordAction = this.jpaService.execute(new CoordActionGetForStartJPAExecutor(this.actionId));
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        LogUtils.setLogInfo(this.coordAction);
    }

    @Override
    protected void verifyPrecondition() throws PreconditionException {
        if (this.coordAction.getStatus() != CoordinatorAction.Status.SUBMITTED) {
            throw new PreconditionException(ErrorCode.E1100, "The coord action [" + this.actionId + "] must have status " + CoordinatorAction.Status.SUBMITTED.name() + " but has status [" + this.coordAction.getStatus().name() + "]");
        }
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

