/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.SubmitHttpXCommand;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class SubmitScriptLanguageXCommand
extends SubmitHttpXCommand {
    public SubmitScriptLanguageXCommand(String name, String type, Configuration conf) {
        super(name, type, conf);
    }

    @Override
    protected abstract String getWorkflowName();

    protected abstract String getOptions();

    protected abstract String getScriptParamters();

    @Override
    protected Namespace getSectionNamespace() {
        return Namespace.getNamespace((String)"uri:oozie:workflow:0.2");
    }

    @Override
    protected Element generateSection(Configuration conf, Namespace ns) {
        String[] args;
        String name = this.getWorkflowName();
        Element ele = new Element(name, ns);
        Element jt = new Element("job-tracker", ns);
        jt.addContent(conf.get("yarn.resourcemanager.address"));
        ele.addContent((Content)jt);
        Element nn = new Element("name-node", ns);
        nn.addContent(conf.get("fs.default.name"));
        ele.addContent((Content)nn);
        ArrayList<String> Dargs = new ArrayList<String>();
        ArrayList<String> otherArgs = new ArrayList<String>();
        for (String arg : args = ActionUtils.getStrings((Configuration)conf, (String)this.getOptions())) {
            if (arg.startsWith("-D")) {
                Dargs.add(arg);
                continue;
            }
            otherArgs.add(arg);
        }
        String[] params = ActionUtils.getStrings((Configuration)conf, (String)this.getScriptParamters());
        if (Dargs.size() > 0) {
            Element configuration = this.generateConfigurationSection(Dargs, ns);
            ele.addContent((Content)configuration);
        }
        Element script = new Element("script", ns);
        script.addContent("dummy." + name);
        ele.addContent((Content)script);
        for (String param : params) {
            Element parameter = new Element("param", ns);
            parameter.addContent(param);
            ele.addContent((Content)parameter);
        }
        for (String arg : otherArgs) {
            Element argument = new Element("argument", ns);
            argument.addContent(arg);
            ele.addContent((Content)argument);
        }
        SubmitScriptLanguageXCommand.addFileSection(ele, conf, ns);
        SubmitScriptLanguageXCommand.addArchiveSection(ele, conf, ns);
        return ele;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() {
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }
}

