/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;

public class WorkflowActionRetryInfoXCommand
extends WorkflowXCommand<List<Map<String, String>>> {
    private String actionId;
    private WorkflowJobBean wfJob;
    protected WorkflowActionBean wfAction = null;

    public WorkflowActionRetryInfoXCommand(String id) {
        super("action.retries.info", "action.retries.info", 1);
        this.actionId = id;
    }

    @Override
    protected List<Map<String, String>> execute() throws CommandException {
        ArrayList<Map<String, String>> retriesList = new ArrayList<Map<String, String>>();
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction);
        for (int i = 0; i < this.wfAction.getUserRetryCount(); ++i) {
            HashMap<String, String> retries = new HashMap<String, String>();
            String value = context.getVar(JobUtils.getRetryKey("externalChildIDs", i));
            if (value != null) {
                retries.put("externalChildIDs", value);
            }
            if ((value = context.getVar(JobUtils.getRetryKey("consoleUrl", i))) != null) {
                retries.put("consoleUrl", value);
            }
            if ((value = context.getVar(JobUtils.getRetryKey("startTime", i))) != null) {
                retries.put("startTime", JsonUtils.formatDateRfc822((Date)new Date(Long.parseLong(value))));
            }
            if ((value = context.getVar(JobUtils.getRetryKey("endTime", i))) != null) {
                retries.put("endTime", JsonUtils.formatDateRfc822((Date)new Date(Long.parseLong(value))));
            }
            retries.put("attempt", String.valueOf(i + 1));
            retriesList.add(retries);
        }
        return retriesList;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_CHECK, this.actionId);
            this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_DEFINITION, this.actionId.substring(0, this.actionId.indexOf("@")));
            LogUtils.setLogInfo(this.wfAction);
        }
        catch (JPAExecutorException ex) {
            if (ex.getErrorCode() == ErrorCode.E0605) {
                throw new CommandException(ErrorCode.E0605, this.actionId);
            }
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }
}

