/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.input.dependency.AbstractCoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordPullInputDependency;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorPhaseOne;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorResult;
import org.apache.oozie.dependency.DependencyChecker;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CoordInputLogicEvaluatorPhaseTwo
extends CoordInputLogicEvaluatorPhaseOne {
    Date actualTime;

    public CoordInputLogicEvaluatorPhaseTwo(CoordinatorActionBean coordAction, Date actualTime) {
        super(coordAction);
        this.actualTime = actualTime;
    }

    public CoordInputLogicEvaluatorPhaseTwo(CoordinatorActionBean coordAction, AbstractCoordInputDependency coordInputDependency) {
        super(coordAction, coordInputDependency);
    }

    @Override
    public CoordInputLogicEvaluatorResult evalInput(String dataSet, int min, int wait) {
        try {
            CoordPullInputDependency coordPullInputDependency = (CoordPullInputDependency)this.coordInputDependency;
            ELEvaluator eval = CoordELEvaluator.createLazyEvaluator(this.actualTime, this.coordAction.getNominalTime(), this.getInputSetEvent(dataSet), this.getConf());
            if (coordPullInputDependency.getUnResolvedDependency(dataSet) == null) {
                return super.evalInput(dataSet, min, wait);
            }
            this.cleanPreviousCheckData(coordPullInputDependency, dataSet);
            List<String> unresolvedList = coordPullInputDependency.getUnResolvedDependency(dataSet).getDependencies();
            for (String unresolved : unresolvedList) {
                String resolvedPath = "";
                CoordELFunctions.evalAndWrap(eval, unresolved);
                boolean isResolved = (Boolean)eval.getVariable("is_resolved");
                coordPullInputDependency.setDependencyMap(this.dependencyMap);
                if (eval.getVariable("resolved_path") != null) {
                    resolvedPath = eval.getVariable("resolved_path").toString();
                }
                if (resolvedPath != null) {
                    resolvedPath = this.getEvalResult(isResolved, min, wait, Arrays.asList(DependencyChecker.dependenciesAsArray(resolvedPath.toString()))).getDataSets();
                }
                this.log.trace(MessageFormat.format("Return data is {0}", resolvedPath));
                this.log.debug(MessageFormat.format("Resolved status of Data set {0} with min {1} and wait {2}  =  {3}", dataSet, min, wait, !StringUtils.isEmpty((String)resolvedPath)));
                if ((this.isInputWaitElapsed(wait) || isResolved) && !StringUtils.isEmpty((String)resolvedPath)) {
                    coordPullInputDependency.addResolvedList(dataSet, resolvedPath.toString());
                    continue;
                }
                this.cleanPreviousCheckData(coordPullInputDependency, dataSet);
                if (!this.isInputWaitElapsed(wait)) {
                    return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.TIMED_WAITING);
                }
                return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.FALSE);
            }
            coordPullInputDependency.getUnResolvedDependency(dataSet).setResolved(true);
            return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.TRUE, this.getListAsString(coordPullInputDependency.getUnResolvedDependency(dataSet).getResolvedList(), dataSet));
        }
        catch (Exception e) {
            throw new RuntimeException(" event not found" + e, e);
        }
    }

    private void cleanPreviousCheckData(CoordPullInputDependency coordPullInputDependency, String dataSet) {
        if (coordPullInputDependency.getUnResolvedDependency(dataSet) != null) {
            coordPullInputDependency.getUnResolvedDependency(dataSet).setResolvedList(new ArrayList<String>());
        }
    }

    @Override
    public CoordInputLogicEvaluatorResult evalCombineInput(String[] inputSets, int min, int wait) {
        throw new RuntimeException("Combine is not supported for latest/future");
    }

    private Element getInputSetEvent(String name) throws JDOMException {
        Element eAction = XmlUtils.parseXml(this.coordAction.getActionXml().toString());
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        List eDataEvents = inputList.getChildren("data-in", eAction.getNamespace());
        for (Element dEvent : eDataEvents) {
            if (!dEvent.getAttribute("name").getValue().equals(name)) continue;
            return dEvent;
        }
        throw new RuntimeException("Event not found");
    }
}

