/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionRetryManualGetJPAExecutor
implements JPAExecutor<List<WorkflowActionBean>> {
    private String wfId = null;
    List<WorkflowActionBean> actions;

    public WorkflowActionRetryManualGetJPAExecutor(String wfId) {
        ParamChecker.notNull(wfId, "wfId");
        this.wfId = wfId;
        this.actions = null;
    }

    @Override
    public List<WorkflowActionBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_RETRY_MANUAL_ACTIONS");
            q.setParameter("wfId", (Object)this.wfId);
            this.actions = q.getResultList();
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
        return this.actions;
    }

    @Override
    public String getName() {
        return "WorkflowActionRetryManualGetJPAExecutor";
    }
}

