/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.lock;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.MemoryLocksService;

public class MemoryLocks {
    private final ConcurrentMap<String, ReentrantReadWriteLock> locks = new MapMaker().weakValues().makeMap();

    public int size() {
        return this.locks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryLockToken getLock(String resource, MemoryLocksService.Type type, long wait) throws InterruptedException {
        Lock lock;
        ReentrantReadWriteLock newLock;
        ReentrantReadWriteLock lockEntry = (ReentrantReadWriteLock)this.locks.get(resource);
        if (lockEntry == null && (lockEntry = this.locks.putIfAbsent(resource, newLock = new ReentrantReadWriteLock(true))) == null) {
            lockEntry = newLock;
        }
        Lock lock2 = lock = type.equals((Object)MemoryLocksService.Type.READ) ? lockEntry.readLock() : lockEntry.writeLock();
        if (wait == -1L) {
            lock.lock();
        } else if (wait > 0L ? !lock.tryLock(wait, TimeUnit.MILLISECONDS) : !lock.tryLock()) {
            return null;
        }
        ConcurrentMap<String, ReentrantReadWriteLock> concurrentMap = this.locks;
        synchronized (concurrentMap) {
            if (!this.locks.containsKey(resource)) {
                this.locks.put(resource, lockEntry);
            }
        }
        return new MemoryLockToken(lockEntry, type);
    }

    public ConcurrentMap<String, ReentrantReadWriteLock> getLockMap() {
        return this.locks;
    }

    class MemoryLockToken
    implements LockToken {
        private final ReentrantReadWriteLock lockEntry;
        private final MemoryLocksService.Type type;

        public MemoryLockToken(ReentrantReadWriteLock lockEntry, MemoryLocksService.Type type) {
            this.lockEntry = lockEntry;
            this.type = type;
        }

        @Override
        public void release() {
            switch (this.type) {
                case WRITE: {
                    this.lockEntry.writeLock().unlock();
                    break;
                }
                case READ: {
                    this.lockEntry.readLock().unlock();
                }
            }
        }
    }
}

