/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetForFilterJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.SLAServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class V2SLAServlet
extends SLAServlet {
    private static final String INSTRUMENTATION_NAME = "v2sla";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];
    private static final Set<String> SLA_FILTER_NAMES = new HashSet<String>();
    private Pattern p = Pattern.compile("\\d{7}-\\d{15}-.*-B$");

    public V2SLAServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XLog.getLog(((Object)((Object)this)).getClass()).debug("Got SLA GET request:" + request.getQueryString());
        try {
            this.stopCron();
            JSONObject json = this.getSLASummaryList(request, response);
            this.startCron();
            if (json == null) {
                response.setStatus(200);
            } else {
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            }
        }
        catch (CommandException ce) {
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Command exception ", ce);
            throw new XServletException(500, ce);
        }
        catch (RuntimeException re) {
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Runtime error ", re);
            throw new XServletException(500, ErrorCode.E0307, re.getMessage());
        }
    }

    private JSONObject getSLASummaryList(HttpServletRequest request, HttpServletResponse response) throws ServletException, CommandException {
        String timeZoneId = request.getParameter("timezone") == null ? null : request.getParameter("timezone");
        String filterString = request.getParameter("filter");
        String maxResults = request.getParameter("len");
        int numMaxResults = 1000;
        if (maxResults != null) {
            numMaxResults = Integer.parseInt(maxResults);
        }
        if (filterString == null || filterString.equals("")) {
            throw new XServletException(400, ErrorCode.E0305, "filter");
        }
        try {
            Map<String, List<String>> filterList = this.parseFilter(URLDecoder.decode(filterString, "UTF-8"), SLA_FILTER_NAMES);
            SLASummaryGetForFilterJPAExecutor.SLASummaryFilter filter = new SLASummaryGetForFilterJPAExecutor.SLASummaryFilter();
            if (!(filterList.containsKey("app_name") || filterList.containsKey("id") || filterList.containsKey("parent_id") || filterList.containsKey("bundle") || filterList.containsKey("nominal_start") || filterList.containsKey("nominal_end"))) {
                StringBuffer st = new StringBuffer();
                st.append("At least one of the filter parameters - ").append("app_name").append(",").append("id").append(",").append("parent_id").append(",").append("bundle").append(",").append("nominal_start").append(" or ").append("nominal_end").append(" should be specified in the filter query parameter");
                throw new XServletException(400, ErrorCode.E0305, st.toString());
            }
            if (filterList.containsKey("id")) {
                filter.setJobId(filterList.get("id").get(0));
            }
            if (filterList.containsKey("parent_id")) {
                filter.setParentId(filterList.get("parent_id").get(0));
            }
            if (filterList.containsKey("bundle")) {
                String bundle = filterList.get("bundle").get(0);
                if (this.isBundleId(bundle)) {
                    filter.setBundleId(bundle);
                } else {
                    filter.setBundleName(bundle);
                }
            }
            if (filterList.containsKey("event_status")) {
                filter.setEventStatus(filterList.get("event_status").get(0));
            }
            if (filterList.containsKey("sla_status")) {
                filter.setSLAStatus(filterList.get("sla_status").get(0));
            }
            if (filterList.containsKey("app_name")) {
                filter.setAppName(filterList.get("app_name").get(0));
            }
            if (filterList.containsKey("nominal_start")) {
                filter.setNominalStart(DateUtils.parseDateUTC(filterList.get("nominal_start").get(0)));
            }
            if (filterList.containsKey("nominal_end")) {
                filter.setNominalEnd(DateUtils.parseDateUTC(filterList.get("nominal_end").get(0)));
            }
            JPAService jpaService = Services.get().get(JPAService.class);
            List<SLASummaryBean> slaSummaryList = null;
            if (jpaService != null) {
                slaSummaryList = jpaService.execute(new SLASummaryGetForFilterJPAExecutor(filter, numMaxResults));
            } else {
                XLog.getLog(((Object)((Object)this)).getClass()).error((Object)ErrorCode.E0610);
            }
            ArrayList<String> jobIds = new ArrayList<String>();
            for (SLASummaryBean summaryBean : slaSummaryList) {
                jobIds.add(summaryBean.getId());
            }
            List<SLARegistrationBean> SLARegistrationList = SLARegistrationQueryExecutor.getInstance().getList(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_CONFIGS, jobIds);
            HashMap<String, Map<String, String>> jobIdSLAConfigMap = new HashMap<String, Map<String, String>>();
            for (SLARegistrationBean registrationBean : SLARegistrationList) {
                jobIdSLAConfigMap.put(registrationBean.getId(), registrationBean.getSLAConfigMap());
            }
            return SLASummaryBean.toJSONObject(slaSummaryList, jobIdSLAConfigMap, timeZoneId);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
        catch (UnsupportedEncodingException e) {
            throw new XServletException(500, ErrorCode.E0307, "Unsupported Encoding", e);
        }
        catch (ParseException e) {
            throw new XServletException(400, ErrorCode.E0303, filterString, e);
        }
    }

    private boolean isBundleId(String id) {
        boolean ret = false;
        Matcher m = this.p.matcher(id);
        if (m.matches()) {
            return true;
        }
        return ret;
    }

    static {
        SLA_FILTER_NAMES.add("id");
        SLA_FILTER_NAMES.add("parent_id");
        SLA_FILTER_NAMES.add("bundle");
        SLA_FILTER_NAMES.add("app_name");
        SLA_FILTER_NAMES.add("nominal_start");
        SLA_FILTER_NAMES.add("nominal_end");
        SLA_FILTER_NAMES.add("event_status");
        SLA_FILTER_NAMES.add("sla_status");
        V2SLAServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("filter", String.class, false, Arrays.asList("GET"))));
    }
}

