/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.MultiFileReader;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogUserFilterParam;

public class XLogStreamer {
    private static XLog LOG = XLog.getLog(XLogStreamer.class);
    protected static final String CONF_PREFIX = "oozie.service.XLogStreamingService.";
    public static final String STREAM_BUFFER_LEN = "oozie.service.XLogStreamingService.buffer.len";
    private String logFile;
    private String logPath;
    protected XLogFilter logFilter;
    private long logRotation;
    Map<String, String[]> requestParam;
    protected int totalDataWritten;
    protected int bufferLen;
    public static final Pattern gzTimePattern = Pattern.compile(".*-(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)-(\\d\\d)\\.gz");

    public XLogStreamer(XLogFilter logFilter, String logPath, String logFile, long logRotationSecs) {
        if (logFile == null) {
            logFile = "oozie-app.log";
        }
        this.logFilter = logFilter;
        this.logFile = logFile;
        this.logPath = logPath;
        this.logRotation = logRotationSecs * 1000L;
        this.bufferLen = ConfigurationService.getInt(STREAM_BUFFER_LEN, 4096);
    }

    public XLogStreamer(XLogFilter logFilter) {
        this(logFilter, Services.get().get(XLogService.class).getOozieLogPath(), Services.get().get(XLogService.class).getOozieLogName(), Services.get().get(XLogService.class).getOozieLogRotation());
    }

    public XLogStreamer(XLogFilter logFilter, Map<String, String[]> params) {
        this(logFilter, Services.get().get(XLogService.class).getOozieLogPath(), Services.get().get(XLogService.class).getOozieLogName(), Services.get().get(XLogService.class).getOozieLogRotation());
        this.requestParam = params;
    }

    public XLogStreamer(Map<String, String[]> params) throws CommandException {
        this(new XLogFilter(new XLogUserFilterParam(params)));
        this.requestParam = params;
    }

    public void streamLog(Writer writer, Date startTime, Date endTime) throws IOException {
        this.streamLog(writer, startTime, endTime, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamLog(Writer writer, Date startTime, Date endTime, boolean appendDebug) throws IOException {
        try (BufferedReader reader = new BufferedReader(this.getReader(startTime, endTime));){
            if (appendDebug) {
                if (!StringUtils.isEmpty((String)this.logFilter.getTruncatedMessage())) {
                    writer.write(this.logFilter.getTruncatedMessage());
                }
                if (this.logFilter.isDebugMode()) {
                    writer.write(this.logFilter.getDebugMessage());
                }
            }
            new TimestampedMessageParser(reader, this.logFilter).processRemaining(writer, this);
        }
    }

    private MultiFileReader getReader(Date startTime, Date endTime) throws IOException {
        this.calculateAndValidateDateRange(startTime, endTime);
        return new MultiFileReader(this.getFileList(this.logFilter.getStartDate(), this.logFilter.getEndDate()));
    }

    protected void calculateAndValidateDateRange(Date startTime, Date endTime) throws IOException {
        this.logFilter.calculateAndCheckDates(startTime, endTime);
        this.logFilter.validateDateRange(startTime, endTime);
    }

    public BufferedReader makeReader(Date startTime, Date endTime) throws IOException {
        return new BufferedReader(this.getReader(startTime, endTime));
    }

    private ArrayList<File> getFileList(Date startTime, Date endTime) throws IOException {
        long startTimeMillis = 0L;
        if (startTime != null) {
            startTimeMillis = startTime.getTime();
        }
        long endTimeMillis = endTime == null ? System.currentTimeMillis() : endTime.getTime();
        File dir = new File(this.logPath);
        return this.getFileList(dir, startTimeMillis, endTimeMillis, this.logRotation, this.logFile);
    }

    private ArrayList<File> getFileList(File dir, long startTime, long endTime, long logRotationTime, String logFile) {
        String[] children = dir.list();
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        if (children == null) {
            return new ArrayList<File>();
        }
        for (int i = 0; i < children.length; ++i) {
            String fileName = children[i];
            if (!fileName.startsWith(logFile) && !fileName.equals(logFile)) continue;
            File file = new File(dir.getAbsolutePath(), fileName);
            if (fileName.endsWith(".gz")) {
                long gzFileCreationTime = this.getGZFileCreationTime(fileName, startTime, endTime);
                if (gzFileCreationTime == -1L) continue;
                fileList.add(new FileInfo(file, gzFileCreationTime));
                continue;
            }
            long modTime = file.lastModified();
            if (modTime < startTime || modTime / logRotationTime > endTime / logRotationTime + 1L) continue;
            fileList.add(new FileInfo(file, modTime));
        }
        Collections.sort(fileList);
        ArrayList<File> files = new ArrayList<File>(fileList.size());
        for (FileInfo info : fileList) {
            files.add(info.getFile());
        }
        return files;
    }

    private long getGZFileCreationTime(String fileName, long startTime, long endTime) {
        long returnVal = -1L;
        if (fileName.equals("oozie.log.gz")) {
            LOG.warn("oozie.log has been GZipped, which is unexpected");
            returnVal = 0L;
        } else {
            Matcher m = gzTimePattern.matcher(fileName);
            if (m.matches() && m.groupCount() == 4) {
                int year = Integer.parseInt(m.group(1));
                int month = Integer.parseInt(m.group(2));
                int day = Integer.parseInt(m.group(3));
                int hour = Integer.parseInt(m.group(4));
                int minute = 0;
                Calendar calendarEntry = Calendar.getInstance();
                calendarEntry.set(year, month - 1, day, hour, minute);
                long logFileStartTime = calendarEntry.getTimeInMillis();
                long milliSecondsPerHour = 3600000L;
                long logFileEndTime = logFileStartTime + milliSecondsPerHour;
                if (startTime >= logFileStartTime && startTime <= logFileEndTime || endTime >= logFileStartTime && endTime <= logFileEndTime || startTime <= logFileStartTime && endTime >= logFileEndTime) {
                    returnVal = logFileStartTime;
                }
            } else {
                LOG.debug("Filename " + fileName + " does not match the expected format");
                returnVal = -1L;
            }
        }
        return returnVal;
    }

    public boolean isLogEnabled() {
        return Services.get().get(XLogService.class).getLogOverWS();
    }

    public String getLogType() {
        return "log";
    }

    public XLogFilter getXLogFilter() {
        return this.logFilter;
    }

    public String getLogDisableMessage() {
        return "Log streaming disabled!!";
    }

    public Map<String, String[]> getRequestParam() {
        return this.requestParam;
    }

    public boolean shouldFlushOutput(int writtenBytes) {
        this.totalDataWritten += writtenBytes;
        if (this.totalDataWritten > this.getBufferLen()) {
            this.totalDataWritten = 0;
            return true;
        }
        return false;
    }

    public int getBufferLen() {
        return this.bufferLen;
    }

    public class FileInfo
    implements Comparable<FileInfo> {
        File file;
        long modTime;

        public FileInfo(File file, long modTime) {
            this.file = file;
            this.modTime = modTime;
        }

        public File getFile() {
            return this.file;
        }

        public long getModTime() {
            return this.modTime;
        }

        @Override
        public int compareTo(FileInfo fileInfo) {
            long diff = this.modTime - fileInfo.modTime;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

