/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.graph;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.apache.oozie.client.WorkflowAction;

public class WorkflowActionNode {
    private String name;
    private String type;
    private Point loc;
    private final Map<String, Boolean> arcs;
    private WorkflowAction.Status status = null;

    private WorkflowActionNode(String name, String type, HashMap<String, Boolean> arcs, Point loc, WorkflowAction.Status status) {
        this.name = name;
        this.type = type;
        this.arcs = arcs;
        this.loc = loc;
        this.status = status;
    }

    WorkflowActionNode(String name, String type) {
        this(name, type, new HashMap<String, Boolean>(), new Point(0, 0), null);
    }

    void addArc(String arc, boolean isError) {
        this.arcs.put(arc, isError);
    }

    void addArc(String arc) {
        this.addArc(arc, false);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLocation(Point loc) {
        this.loc = loc;
    }

    void setLocation(double x, double y) {
        this.loc.setLocation(x, y);
    }

    public void setStatus(WorkflowAction.Status status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    Map<String, Boolean> getArcs() {
        return this.arcs;
    }

    public Point getLocation() {
        return this.loc;
    }

    public WorkflowAction.Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Node: ").append(this.name).append("\t");
        s.append("Type: ").append(this.type).append("\t");
        s.append("Location: (").append(this.loc.getX()).append(", ").append(this.loc.getY()).append(")\t");
        s.append("Status: ").append(this.status).append("\n");
        for (Map.Entry<String, Boolean> entry : this.arcs.entrySet()) {
            s.append("\t").append(entry.getKey());
            if (entry.getValue().booleanValue()) {
                s.append(" on error\n");
                continue;
            }
            s.append("\n");
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowActionNode that = (WorkflowActionNode)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }
}

