/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.management.sampled.CacheSamplerImpl;
import net.sf.ehcache.management.sampled.SampledCacheMBean;
import net.sf.ehcache.management.sampled.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCache
extends BaseEmitterBean
implements SampledCacheMBean,
PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(SampledCache.class);
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final CacheSamplerImpl sampledCacheDelegate;
    private final String immutableCacheName;

    public SampledCache(Ehcache cache) throws NotCompliantMBeanException {
        super(SampledCacheMBean.class);
        this.immutableCacheName = cache.getName();
        cache.addPropertyChangeListener(this);
        this.sampledCacheDelegate = new CacheSamplerImpl(cache);
    }

    String getImmutableCacheName() {
        return this.immutableCacheName;
    }

    @Override
    public boolean isEnabled() {
        return this.sampledCacheDelegate.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.sampledCacheDelegate.setEnabled(enabled);
    }

    @Override
    public boolean isClusterBulkLoadEnabled() {
        return this.sampledCacheDelegate.isClusterBulkLoadEnabled();
    }

    @Override
    public boolean isNodeBulkLoadEnabled() {
        return this.sampledCacheDelegate.isNodeBulkLoadEnabled();
    }

    @Override
    public void setNodeBulkLoadEnabled(boolean bulkLoadEnabled) {
        this.sampledCacheDelegate.setNodeBulkLoadEnabled(bulkLoadEnabled);
    }

    @Override
    public void flush() {
        this.sampledCacheDelegate.flush();
        this.sendNotification("CacheFlushed", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public String getCacheName() {
        return this.sampledCacheDelegate.getCacheName();
    }

    @Override
    public String getStatus() {
        return this.sampledCacheDelegate.getStatus();
    }

    @Override
    public void removeAll() {
        this.sampledCacheDelegate.removeAll();
        this.sendNotification("CacheCleared", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getAverageGetTimeMostRecentSample() {
        return this.sampledCacheDelegate.getAverageGetTimeMostRecentSample();
    }

    @Override
    public long getAverageGetTimeNanosMostRecentSample() {
        return this.sampledCacheDelegate.getAverageGetTimeNanosMostRecentSample();
    }

    @Override
    public long getCacheEvictionRate() {
        return this.sampledCacheDelegate.getCacheEvictionRate();
    }

    @Override
    public long getCacheElementEvictedMostRecentSample() {
        return this.sampledCacheDelegate.getCacheElementEvictedMostRecentSample();
    }

    @Override
    public long getCacheExpirationRate() {
        return this.sampledCacheDelegate.getCacheExpirationRate();
    }

    @Override
    public long getCacheElementExpiredMostRecentSample() {
        return this.sampledCacheDelegate.getCacheElementExpiredMostRecentSample();
    }

    @Override
    public long getCachePutRate() {
        return this.sampledCacheDelegate.getCachePutRate();
    }

    @Override
    public long getCacheElementPutMostRecentSample() {
        return this.sampledCacheDelegate.getCacheElementPutMostRecentSample();
    }

    @Override
    public long getCacheRemoveRate() {
        return this.sampledCacheDelegate.getCacheRemoveRate();
    }

    @Override
    public long getCacheElementRemovedMostRecentSample() {
        return this.sampledCacheDelegate.getCacheElementRemovedMostRecentSample();
    }

    @Override
    public long getCacheUpdateRate() {
        return this.getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheElementUpdatedMostRecentSample() {
        return this.sampledCacheDelegate.getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheInMemoryHitRate() {
        return this.getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheHitInMemoryMostRecentSample() {
        return this.sampledCacheDelegate.getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheOffHeapHitRate() {
        return this.sampledCacheDelegate.getCacheOffHeapHitRate();
    }

    @Override
    public long getCacheHitOffHeapMostRecentSample() {
        return this.sampledCacheDelegate.getCacheHitOffHeapMostRecentSample();
    }

    @Override
    public long getCacheHitRate() {
        return this.sampledCacheDelegate.getCacheHitRate();
    }

    @Override
    public long getCacheHitMostRecentSample() {
        return this.sampledCacheDelegate.getCacheHitMostRecentSample();
    }

    @Override
    public long getCacheOnDiskHitRate() {
        return this.sampledCacheDelegate.getCacheOnDiskHitRate();
    }

    @Override
    public long getCacheHitOnDiskMostRecentSample() {
        return this.sampledCacheDelegate.getCacheHitOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissExpiredMostRecentSample() {
        return this.sampledCacheDelegate.getCacheMissExpiredMostRecentSample();
    }

    @Override
    public long getCacheMissRate() {
        return this.sampledCacheDelegate.getCacheMissRate();
    }

    @Override
    public long getCacheMissMostRecentSample() {
        return this.sampledCacheDelegate.getCacheMissMostRecentSample();
    }

    @Override
    public long getCacheInMemoryMissRate() {
        return this.sampledCacheDelegate.getCacheInMemoryMissRate();
    }

    @Override
    public long getCacheMissInMemoryMostRecentSample() {
        return this.sampledCacheDelegate.getCacheMissInMemoryMostRecentSample();
    }

    @Override
    public long getCacheOffHeapMissRate() {
        return this.sampledCacheDelegate.getCacheOffHeapMissRate();
    }

    @Override
    public long getCacheMissOffHeapMostRecentSample() {
        return this.sampledCacheDelegate.getCacheMissOffHeapMostRecentSample();
    }

    @Override
    public long getCacheOnDiskMissRate() {
        return this.sampledCacheDelegate.getCacheOnDiskMissRate();
    }

    @Override
    public long getCacheMissOnDiskMostRecentSample() {
        return this.sampledCacheDelegate.getCacheMissOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissNotFoundMostRecentSample() {
        return this.sampledCacheDelegate.getCacheMissNotFoundMostRecentSample();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.sampledCacheDelegate.getStatisticsAccuracy();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        return this.sampledCacheDelegate.getStatisticsAccuracyDescription();
    }

    @Override
    public void clearStatistics() {
        this.sampledCacheDelegate.clearStatistics();
        this.sendNotification("CacheStatisticsReset", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.sampledCacheDelegate.isStatisticsEnabled();
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.sampledCacheDelegate.isSampledStatisticsEnabled();
    }

    @Override
    public boolean isTerracottaClustered() {
        return this.sampledCacheDelegate.isTerracottaClustered();
    }

    @Override
    public String getTerracottaConsistency() {
        return this.sampledCacheDelegate.getTerracottaConsistency();
    }

    @Override
    public void enableStatistics() {
        this.sampledCacheDelegate.enableStatistics();
    }

    @Override
    public void disableStatistics() {
        this.sampledCacheDelegate.disableStatistics();
    }

    @Override
    public void setStatisticsEnabled(boolean statsEnabled) {
        this.sampledCacheDelegate.setStatisticsEnabled(statsEnabled);
    }

    @Override
    public void enableSampledStatistics() {
        this.sampledCacheDelegate.enableSampledStatistics();
    }

    @Override
    public void disableSampledStatistics() {
        this.sampledCacheDelegate.disableSampledStatistics();
    }

    @Override
    @Deprecated
    public void setNodeCoherent(boolean coherent) {
        boolean isNodeCoherent = this.isNodeCoherent();
        if (coherent != isNodeCoherent) {
            if (!coherent && this.getTransactional()) {
                LOG.warn("a transactional cache cannot be incoherent");
                return;
            }
            try {
                this.sampledCacheDelegate.getCache().setNodeCoherent(coherent);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    @Override
    @Deprecated
    public boolean isClusterCoherent() {
        try {
            return this.sampledCacheDelegate.getCache().isClusterCoherent();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    @Override
    @Deprecated
    public boolean isNodeCoherent() {
        try {
            return this.sampledCacheDelegate.getCache().isNodeCoherent();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    @Override
    public long getCacheAverageGetTime() {
        return this.sampledCacheDelegate.getCacheAverageGetTime();
    }

    @Override
    public float getAverageGetTimeMillis() {
        return this.sampledCacheDelegate.getAverageGetTimeMillis();
    }

    @Override
    public long getAverageGetTimeNanos() {
        return this.sampledCacheDelegate.getAverageGetTimeNanos();
    }

    @Override
    public long getMaxGetTimeMillis() {
        return this.sampledCacheDelegate.getMaxGetTimeMillis();
    }

    @Override
    public long getMinGetTimeMillis() {
        return this.sampledCacheDelegate.getMinGetTimeMillis();
    }

    @Override
    public long getMaxGetTimeNanos() {
        return this.sampledCacheDelegate.getMaxGetTimeNanos();
    }

    @Override
    public long getMinGetTimeNanos() {
        return this.sampledCacheDelegate.getMinGetTimeNanos();
    }

    @Override
    public long getXaCommitCount() {
        return this.sampledCacheDelegate.getXaCommitCount();
    }

    @Override
    public long getXaRollbackCount() {
        return this.sampledCacheDelegate.getXaRollbackCount();
    }

    @Override
    public long getXaRecoveredCount() {
        return this.sampledCacheDelegate.getXaRecoveredCount();
    }

    @Override
    public boolean getHasWriteBehindWriter() {
        return this.sampledCacheDelegate.getHasWriteBehindWriter();
    }

    @Override
    public long getWriterQueueLength() {
        return this.sampledCacheDelegate.getWriterQueueLength();
    }

    @Override
    public int getWriterMaxQueueSize() {
        return this.sampledCacheDelegate.getWriterMaxQueueSize();
    }

    @Override
    public int getWriterConcurrency() {
        return this.sampledCacheDelegate.getWriterConcurrency();
    }

    @Override
    public long getCacheHitCount() {
        return this.sampledCacheDelegate.getCacheHitCount();
    }

    @Override
    public long getCacheMissCount() {
        return this.sampledCacheDelegate.getCacheMissCount();
    }

    @Override
    public long getInMemoryMissCount() {
        return this.sampledCacheDelegate.getInMemoryMissCount();
    }

    @Override
    public long getOffHeapMissCount() {
        return this.sampledCacheDelegate.getOffHeapMissCount();
    }

    @Override
    public long getOnDiskMissCount() {
        return this.sampledCacheDelegate.getOnDiskMissCount();
    }

    @Override
    public long getCacheMissCountExpired() {
        return this.sampledCacheDelegate.getCacheMissCountExpired();
    }

    @Override
    public long getDiskExpiryThreadIntervalSeconds() {
        return this.sampledCacheDelegate.getDiskExpiryThreadIntervalSeconds();
    }

    @Override
    public void setDiskExpiryThreadIntervalSeconds(long seconds) {
        this.sampledCacheDelegate.setDiskExpiryThreadIntervalSeconds(seconds);
    }

    @Override
    public long getMaxEntriesLocalHeap() {
        return this.sampledCacheDelegate.getMaxEntriesLocalHeap();
    }

    @Override
    public void setMaxEntriesLocalHeap(long maxEntries) {
        this.sampledCacheDelegate.setMaxEntriesLocalHeap(maxEntries);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getMaxBytesLocalHeap() {
        return this.sampledCacheDelegate.getMaxBytesLocalHeap();
    }

    @Override
    public void setMaxBytesLocalHeap(long maxBytes) {
        this.sampledCacheDelegate.setMaxBytesLocalHeap(maxBytes);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void setMaxBytesLocalHeapAsString(String maxBytes) {
        this.sampledCacheDelegate.setMaxBytesLocalHeapAsString(maxBytes);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public String getMaxBytesLocalHeapAsString() {
        return this.sampledCacheDelegate.getMaxBytesLocalHeapAsString();
    }

    @Override
    public int getMaxElementsInMemory() {
        return this.sampledCacheDelegate.getCache().getCacheConfiguration().getMaxElementsInMemory();
    }

    @Override
    public void setMaxElementsInMemory(int maxElements) {
        if (this.getMaxElementsInMemory() != maxElements) {
            try {
                this.sampledCacheDelegate.getCache().getCacheConfiguration().setMaxElementsInMemory(maxElements);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    @Override
    public long getMaxEntriesLocalDisk() {
        return this.sampledCacheDelegate.getMaxEntriesLocalDisk();
    }

    @Override
    public void setMaxEntriesLocalDisk(long maxEntries) {
        this.sampledCacheDelegate.setMaxEntriesLocalDisk(maxEntries);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void setMaxBytesLocalDisk(long maxBytes) {
        this.sampledCacheDelegate.setMaxBytesLocalDisk(maxBytes);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void setMaxBytesLocalDiskAsString(String maxBytes) {
        this.sampledCacheDelegate.setMaxBytesLocalDiskAsString(maxBytes);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public String getMaxBytesLocalDiskAsString() {
        return this.sampledCacheDelegate.getMaxBytesLocalDiskAsString();
    }

    @Override
    public int getMaxElementsOnDisk() {
        return this.sampledCacheDelegate.getMaxElementsOnDisk();
    }

    @Override
    public void setMaxElementsOnDisk(int maxElements) {
        this.sampledCacheDelegate.setMaxElementsOnDisk(maxElements);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getMaxBytesLocalDisk() {
        return this.sampledCacheDelegate.getMaxBytesLocalDisk();
    }

    @Override
    public long getMaxBytesLocalOffHeap() {
        return this.sampledCacheDelegate.getMaxBytesLocalOffHeap();
    }

    @Override
    public String getMaxBytesLocalOffHeapAsString() {
        return this.sampledCacheDelegate.getMaxBytesLocalOffHeapAsString();
    }

    @Override
    public String getMemoryStoreEvictionPolicy() {
        return this.sampledCacheDelegate.getMemoryStoreEvictionPolicy();
    }

    @Override
    public void setMemoryStoreEvictionPolicy(String evictionPolicy) {
        this.sampledCacheDelegate.setMemoryStoreEvictionPolicy(evictionPolicy);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getTimeToIdleSeconds() {
        return this.sampledCacheDelegate.getTimeToIdleSeconds();
    }

    @Override
    public void setTimeToIdleSeconds(long tti) {
        this.sampledCacheDelegate.setTimeToIdleSeconds(tti);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getTimeToLiveSeconds() {
        return this.sampledCacheDelegate.getTimeToLiveSeconds();
    }

    @Override
    public void setTimeToLiveSeconds(long ttl) {
        this.sampledCacheDelegate.setTimeToLiveSeconds(ttl);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isDiskPersistent() {
        return this.sampledCacheDelegate.isDiskPersistent();
    }

    @Override
    public void setDiskPersistent(boolean diskPersistent) {
        this.sampledCacheDelegate.setDiskPersistent(diskPersistent);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isEternal() {
        return this.sampledCacheDelegate.isEternal();
    }

    @Override
    public void setEternal(boolean eternal) {
        this.sampledCacheDelegate.setEternal(eternal);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isOverflowToDisk() {
        return this.sampledCacheDelegate.isOverflowToDisk();
    }

    @Override
    public void setOverflowToDisk(boolean overflowToDisk) {
        this.sampledCacheDelegate.setOverflowToDisk(overflowToDisk);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.sampledCacheDelegate.isLoggingEnabled();
    }

    @Override
    public void setLoggingEnabled(boolean enabled) {
        this.sampledCacheDelegate.setLoggingEnabled(enabled);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isPinned() {
        return this.sampledCacheDelegate.isPinned();
    }

    @Override
    public String getPinnedToStore() {
        return this.sampledCacheDelegate.getPinnedToStore();
    }

    @Override
    public long getEvictedCount() {
        return this.sampledCacheDelegate.getEvictedCount();
    }

    @Override
    public long getExpiredCount() {
        return this.sampledCacheDelegate.getExpiredCount();
    }

    @Override
    public long getInMemoryHitCount() {
        return this.sampledCacheDelegate.getInMemoryHitCount();
    }

    @Override
    @Deprecated
    public long getInMemorySize() {
        return this.getLocalHeapSize();
    }

    @Override
    public long getOffHeapHitCount() {
        return this.sampledCacheDelegate.getOffHeapHitCount();
    }

    @Override
    @Deprecated
    public long getOffHeapSize() {
        return this.sampledCacheDelegate.getOffHeapSize();
    }

    @Override
    public long getOnDiskHitCount() {
        return this.sampledCacheDelegate.getOnDiskHitCount();
    }

    @Override
    @Deprecated
    public long getOnDiskSize() {
        return this.sampledCacheDelegate.getOnDiskSize();
    }

    @Override
    public long getLocalDiskSize() {
        return this.sampledCacheDelegate.getLocalDiskSize();
    }

    @Override
    public long getLocalHeapSize() {
        return this.sampledCacheDelegate.getLocalHeapSize();
    }

    @Override
    public long getLocalOffHeapSize() {
        return this.sampledCacheDelegate.getLocalOffHeapSize();
    }

    @Override
    public long getLocalDiskSizeInBytes() {
        return this.sampledCacheDelegate.getLocalDiskSizeInBytes();
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        return this.sampledCacheDelegate.getLocalHeapSizeInBytes();
    }

    @Override
    public long getLocalOffHeapSizeInBytes() {
        return this.sampledCacheDelegate.getLocalOffHeapSizeInBytes();
    }

    @Override
    public long getPutCount() {
        return this.sampledCacheDelegate.getPutCount();
    }

    @Override
    public long getRemovedCount() {
        return this.sampledCacheDelegate.getRemovedCount();
    }

    @Override
    public long getSize() {
        return this.sampledCacheDelegate.getSize();
    }

    @Override
    public long getUpdateCount() {
        return this.sampledCacheDelegate.getUpdateCount();
    }

    public Map<String, Object> getCacheAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Enabled", this.isEnabled());
        result.put("TerracottaClustered", this.isTerracottaClustered());
        result.put("LoggingEnabled", this.isLoggingEnabled());
        result.put("TimeToIdleSeconds", this.getTimeToIdleSeconds());
        result.put("TimeToLiveSeconds", this.getTimeToLiveSeconds());
        result.put("MaxEntriesLocalHeap", this.getMaxEntriesLocalHeap());
        result.put("MaxEntriesLocalDisk", this.getMaxEntriesLocalDisk());
        result.put("MaxBytesLocalHeapAsString", this.getMaxBytesLocalHeapAsString());
        result.put("MaxBytesLocalOffHeapAsString", this.getMaxBytesLocalOffHeapAsString());
        result.put("MaxBytesLocalDiskAsString", this.getMaxBytesLocalDiskAsString());
        result.put("MaxBytesLocalHeap", this.getMaxBytesLocalHeap());
        result.put("MaxBytesLocalOffHeap", this.getMaxBytesLocalOffHeap());
        result.put("MaxBytesLocalDisk", this.getMaxBytesLocalDisk());
        result.put("DiskPersistent", this.isDiskPersistent());
        result.put("Eternal", this.isEternal());
        result.put("OverflowToDisk", this.isOverflowToDisk());
        result.put("DiskExpiryThreadIntervalSeconds", this.getDiskExpiryThreadIntervalSeconds());
        result.put("MemoryStoreEvictionPolicy", this.getMemoryStoreEvictionPolicy());
        result.put("TerracottaConsistency", this.getTerracottaConsistency());
        if (this.isTerracottaClustered()) {
            result.put("NodeBulkLoadEnabled", this.isNodeBulkLoadEnabled());
            result.put("NodeCoherent", this.isNodeCoherent());
            result.put("ClusterBulkLoadEnabled", this.isClusterBulkLoadEnabled());
            result.put("ClusterCoherent", this.isClusterCoherent());
        }
        result.put("StatisticsEnabled", this.isStatisticsEnabled());
        result.put("WriterConcurrency", this.getWriterConcurrency());
        result.put("Transactional", this.getTransactional());
        result.put("PinnedToStore", this.getPinnedToStore());
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    protected void doDispose() {
        this.sampledCacheDelegate.dispose();
    }

    @Override
    public long getAverageSearchTime() {
        return this.sampledCacheDelegate.getAverageSearchTime();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.sampledCacheDelegate.getSearchesPerSecond();
    }

    @Override
    public boolean getTransactional() {
        return this.sampledCacheDelegate.getTransactional();
    }

    @Override
    public boolean getSearchable() {
        return this.sampledCacheDelegate.getSearchable();
    }

    @Override
    public long getCacheSearchRate() {
        return this.sampledCacheDelegate.getCacheSearchRate();
    }

    @Override
    public long getCacheAverageSearchTime() {
        return this.sampledCacheDelegate.getCacheAverageSearchTime();
    }

    @Override
    public long getTransactionCommitRate() {
        return this.getCacheXaCommitsMostRecentSample();
    }

    @Override
    public long getCacheXaCommitsMostRecentSample() {
        return this.sampledCacheDelegate.getCacheXaCommitsMostRecentSample();
    }

    @Override
    public long getTransactionRollbackRate() {
        return this.getCacheXaRollbacksMostRecentSample();
    }

    @Override
    public long getCacheXaRollbacksMostRecentSample() {
        return this.sampledCacheDelegate.getCacheXaRollbacksMostRecentSample();
    }

    @Override
    public int getCacheHitRatio() {
        return this.sampledCacheDelegate.getCacheHitRatio();
    }

    @Override
    public int getCacheHitRatioMostRecentSample() {
        return this.sampledCacheDelegate.getCacheHitRatioMostRecentSample();
    }

    static {
        String[] notifTypes = new String[]{"CacheEnabled", "CacheChanged", "CacheFlushed", "CacheStatisticsEnabled", "CacheStatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache SampledCache Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Ehcache SampledCache Event")};
    }
}

